/*
 * Copyright (C) 2013 Allwinnertech, kevin.z.m <kevin@allwinnertech.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#include <linux/clk-private.h>
#include <linux/clk-provider.h>
#include <linux/clkdev.h>
#include <linux/clk/sunxi.h>
#include <mach/sys_config.h>
#include "clk-sunxi.h"
#include "clk-factors.h"
#include "clk-periph.h"
#include "clk-sun8iw1.h"


static DEFINE_SPINLOCK(clk_lock);
void __iomem *sunxi_clk_base;
void __iomem *sunxi_clk_cpus_base;
int	sunxi_clk_maxreg =SUNXI_CLK_MAX_REG;
int cpus_clk_maxreg = CPUS_CLK_MAX_REG;
#ifdef CONFIG_SUNXI_CLK_DUMMY_DEBUG
unsigned int dummy_reg[1024]; 
unsigned int dummy_cpus_reg[1024]; 
unsigned int dummy_readl(unsigned int* regaddr)
{
	unsigned int val;
	val = *regaddr;
	printk("--%s-- dummy_readl to read reg 0x%x with val 0x%x\n",__func__,((unsigned int)regaddr - (unsigned int)&dummy_reg[0]),val);
	return val;
}
void  dummy_writel(unsigned int val,unsigned int* regaddr)
	{
		*regaddr = val;
		printk("--%s-- dummy_writel to write reg 0x%x with val 0x%x\n",__func__,((unsigned int)regaddr - (unsigned int)&dummy_reg[0]),val);
	}

void dummy_reg_init(void)
{
	memset(dummy_reg,0x0,sizeof(dummy_reg));				
	dummy_reg[PLL1_CFG/4]=0x00001000;
	dummy_reg[PLL2_CFG/4]=0x00035514;
	dummy_reg[PLL3_CFG/4]=0x03006207;
	dummy_reg[PLL4_CFG/4]=0x03006207;
	dummy_reg[PLL5_CFG/4]=0x00001000;
	dummy_reg[PLL6_CFG/4]=0x00041811;
	dummy_reg[PLL8_CFG/4]=0x03006207;
	dummy_reg[PLL9_CFG/4]=0x03001300;
	dummy_reg[PLL10_CFG/4]=0x03006207;
	dummy_reg[CPU_CFG/4]=0x00001000;
	dummy_reg[AHB1_CFG/4]=0x00001010;
	dummy_reg[APB2_CFG/4]=0x01000000;

	dummy_reg[PLL_LOCK/4]=0x000000FF;
	dummy_reg[CPU_LOCK/4]=0x000000FF;
}
#endif // of CONFIG_SUNXI_CLK_DUMMY_DEBUG

/* periph factors config table */
static struct sunxi_clk_factor_freq    factor_pll1_tbl[] = {
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 0  ), index = 0  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 1  ), index = 1  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 2  ), index = 2  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 3  ), index = 3  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 4  ), index = 4  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 5  ), index = 5  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 6  ), index = 6  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 7  ), index = 7  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 8  ), index = 8  */
{F_N8X5_K4X2_M0X2(8 , 0, 3), 54000000  }, /* freq = (6M * 9  ), index = 9  */
{F_N8X5_K4X2_M0X2(9 , 0, 3), 60000000  }, /* freq = (6M * 10 ), index = 10 */
{F_N8X5_K4X2_M0X2(10, 0, 3), 66000000  }, /* freq = (6M * 11 ), index = 11 */
{F_N8X5_K4X2_M0X2(8 , 0, 2), 72000000  }, /* freq = (6M * 12 ), index = 12 */
{F_N8X5_K4X2_M0X2(12, 0, 3), 78000000  }, /* freq = (6M * 13 ), index = 13 */
{F_N8X5_K4X2_M0X2(13, 0, 3), 84000000  }, /* freq = (6M * 14 ), index = 14 */
{F_N8X5_K4X2_M0X2(14, 0, 3), 90000000  }, /* freq = (6M * 15 ), index = 15 */
{F_N8X5_K4X2_M0X2(11, 0, 2), 96000000  }, /* freq = (6M * 16 ), index = 16 */
{F_N8X5_K4X2_M0X2(16, 0, 3), 102000000 }, /* freq = (6M * 17 ), index = 17 */
{F_N8X5_K4X2_M0X2(8 , 0, 1), 108000000 }, /* freq = (6M * 18 ), index = 18 */
{F_N8X5_K4X2_M0X2(18, 0, 3), 114000000 }, /* freq = (6M * 19 ), index = 19 */
{F_N8X5_K4X2_M0X2(9 , 0, 1), 120000000 }, /* freq = (6M * 20 ), index = 20 */
{F_N8X5_K4X2_M0X2(20, 0, 3), 126000000 }, /* freq = (6M * 21 ), index = 21 */
{F_N8X5_K4X2_M0X2(10, 0, 1), 132000000 }, /* freq = (6M * 22 ), index = 22 */
{F_N8X5_K4X2_M0X2(22, 0, 3), 138000000 }, /* freq = (6M * 23 ), index = 23 */
{F_N8X5_K4X2_M0X2(11, 0, 1), 144000000 }, /* freq = (6M * 24 ), index = 24 */
{F_N8X5_K4X2_M0X2(24, 0, 3), 150000000 }, /* freq = (6M * 25 ), index = 25 */
{F_N8X5_K4X2_M0X2(12, 0, 1), 156000000 }, /* freq = (6M * 26 ), index = 26 */
{F_N8X5_K4X2_M0X2(26, 0, 3), 162000000 }, /* freq = (6M * 27 ), index = 27 */
{F_N8X5_K4X2_M0X2(13, 0, 1), 168000000 }, /* freq = (6M * 28 ), index = 28 */
{F_N8X5_K4X2_M0X2(28, 0, 3), 174000000 }, /* freq = (6M * 29 ), index = 29 */
{F_N8X5_K4X2_M0X2(14, 0, 1), 180000000 }, /* freq = (6M * 30 ), index = 30 */
{F_N8X5_K4X2_M0X2(30, 0, 3), 186000000 }, /* freq = (6M * 31 ), index = 31 */
{F_N8X5_K4X2_M0X2(15, 0, 1), 192000000 }, /* freq = (6M * 32 ), index = 32 */
{F_N8X5_K4X2_M0X2(10, 2, 3), 198000000 }, /* freq = (6M * 33 ), index = 33 */
{F_N8X5_K4X2_M0X2(16, 0, 1), 204000000 }, /* freq = (6M * 34 ), index = 34 */
{F_N8X5_K4X2_M0X2(25, 0, 2), 208000000 }, /* freq = (6M * 35 ), index = 35 */
{F_N8X5_K4X2_M0X2(8 , 0, 0), 216000000 }, /* freq = (6M * 36 ), index = 36 */
{F_N8X5_K4X2_M0X2(27, 0, 2), 224000000 }, /* freq = (6M * 37 ), index = 37 */
{F_N8X5_K4X2_M0X2(18, 0, 1), 228000000 }, /* freq = (6M * 38 ), index = 38 */
{F_N8X5_K4X2_M0X2(12, 2, 3), 234000000 }, /* freq = (6M * 39 ), index = 39 */
{F_N8X5_K4X2_M0X2(9 , 0, 0), 240000000 }, /* freq = (6M * 40 ), index = 40 */
{F_N8X5_K4X2_M0X2(30, 0, 2), 248000000 }, /* freq = (6M * 41 ), index = 41 */
{F_N8X5_K4X2_M0X2(20, 0, 1), 252000000 }, /* freq = (6M * 42 ), index = 42 */
{F_N8X5_K4X2_M0X2(31, 0, 2), 256000000 }, /* freq = (6M * 43 ), index = 43 */
{F_N8X5_K4X2_M0X2(10, 0, 0), 264000000 }, /* freq = (6M * 44 ), index = 44 */
{F_N8X5_K4X2_M0X2(14, 2, 3), 270000000 }, /* freq = (6M * 45 ), index = 45 */
{F_N8X5_K4X2_M0X2(22, 0, 1), 276000000 }, /* freq = (6M * 46 ), index = 46 */
{F_N8X5_K4X2_M0X2(22, 1, 3), 276000000 }, /* freq = (6M * 47 ), index = 47 */
{F_N8X5_K4X2_M0X2(11, 0, 0), 288000000 }, /* freq = (6M * 48 ), index = 48 */
{F_N8X5_K4X2_M0X2(5 , 1, 0), 288000000 }, /* freq = (6M * 49 ), index = 49 */
{F_N8X5_K4X2_M0X2(24, 0, 1), 300000000 }, /* freq = (6M * 50 ), index = 50 */
{F_N8X5_K4X2_M0X2(16, 2, 3), 306000000 }, /* freq = (6M * 51 ), index = 51 */
{F_N8X5_K4X2_M0X2(12, 0, 0), 312000000 }, /* freq = (6M * 52 ), index = 52 */
{F_N8X5_K4X2_M0X2(19, 1, 2), 320000000 }, /* freq = (6M * 53 ), index = 53 */
{F_N8X5_K4X2_M0X2(26, 0, 1), 324000000 }, /* freq = (6M * 54 ), index = 54 */
{F_N8X5_K4X2_M0X2(8 , 2, 1), 324000000 }, /* freq = (6M * 55 ), index = 55 */
{F_N8X5_K4X2_M0X2(13, 0, 0), 336000000 }, /* freq = (6M * 56 ), index = 56 */
{F_N8X5_K4X2_M0X2(18, 2, 3), 342000000 }, /* freq = (6M * 57 ), index = 57 */
{F_N8X5_K4X2_M0X2(28, 0, 1), 348000000 }, /* freq = (6M * 58 ), index = 58 */
{F_N8X5_K4X2_M0X2(21, 1, 2), 352000000 }, /* freq = (6M * 59 ), index = 59 */
{F_N8X5_K4X2_M0X2(14, 0, 0), 360000000 }, /* freq = (6M * 60 ), index = 60 */
{F_N8X5_K4X2_M0X2(22, 1, 2), 368000000 }, /* freq = (6M * 61 ), index = 61 */
{F_N8X5_K4X2_M0X2(30, 0, 1), 372000000 }, /* freq = (6M * 62 ), index = 62 */
{F_N8X5_K4X2_M0X2(20, 2, 3), 378000000 }, /* freq = (6M * 63 ), index = 63 */
{F_N8X5_K4X2_M0X2(15, 0, 0), 384000000 }, /* freq = (6M * 64 ), index = 64 */
{F_N8X5_K4X2_M0X2(7 , 1, 0), 384000000 }, /* freq = (6M * 65 ), index = 65 */
{F_N8X5_K4X2_M0X2(10, 2, 1), 396000000 }, /* freq = (6M * 66 ), index = 66 */
{F_N8X5_K4X2_M0X2(24, 1, 2), 400000000 }, /* freq = (6M * 67 ), index = 67 */
{F_N8X5_K4X2_M0X2(16, 0, 0), 408000000 }, /* freq = (6M * 68 ), index = 68 */
{F_N8X5_K4X2_M0X2(22, 2, 3), 414000000 }, /* freq = (6M * 69 ), index = 69 */
{F_N8X5_K4X2_M0X2(25, 1, 2), 416000000 }, /* freq = (6M * 70 ), index = 70 */
{F_N8X5_K4X2_M0X2(12, 3, 2), 416000000 }, /* freq = (6M * 71 ), index = 71 */
{F_N8X5_K4X2_M0X2(17, 0, 0), 432000000 }, /* freq = (6M * 72 ), index = 72 */
{F_N8X5_K4X2_M0X2(8 , 1, 0), 432000000 }, /* freq = (6M * 73 ), index = 73 */
{F_N8X5_K4X2_M0X2(27, 1, 2), 448000000 }, /* freq = (6M * 74 ), index = 74 */
{F_N8X5_K4X2_M0X2(24, 2, 3), 450000000 }, /* freq = (6M * 75 ), index = 75 */
{F_N8X5_K4X2_M0X2(18, 0, 0), 456000000 }, /* freq = (6M * 76 ), index = 76 */
{F_N8X5_K4X2_M0X2(28, 1, 2), 464000000 }, /* freq = (6M * 77 ), index = 77 */
{F_N8X5_K4X2_M0X2(12, 2, 1), 468000000 }, /* freq = (6M * 78 ), index = 78 */
{F_N8X5_K4X2_M0X2(25, 2, 3), 468000000 }, /* freq = (6M * 79 ), index = 79 */
{F_N8X5_K4X2_M0X2(19, 0, 0), 480000000 }, /* freq = (6M * 80 ), index = 80 */
{F_N8X5_K4X2_M0X2(19, 2, 2), 480000000 }, /* freq = (6M * 81 ), index = 81 */
{F_N8X5_K4X2_M0X2(14, 3, 2), 480000000 }, /* freq = (6M * 82 ), index = 82 */
{F_N8X5_K4X2_M0X2(30, 1, 2), 496000000 }, /* freq = (6M * 83 ), index = 83 */
{F_N8X5_K4X2_M0X2(20, 0, 0), 504000000 }, /* freq = (6M * 84 ), index = 84 */
{F_N8X5_K4X2_M0X2(31, 1, 2), 512000000 }, /* freq = (6M * 85 ), index = 85 */
{F_N8X5_K4X2_M0X2(15, 3, 2), 512000000 }, /* freq = (6M * 86 ), index = 86 */
{F_N8X5_K4X2_M0X2(15, 3, 2), 512000000 }, /* freq = (6M * 87 ), index = 87 */
{F_N8X5_K4X2_M0X2(21, 0, 0), 528000000 }, /* freq = (6M * 88 ), index = 88 */
{F_N8X5_K4X2_M0X2(10, 1, 0), 528000000 }, /* freq = (6M * 89 ), index = 89 */
{F_N8X5_K4X2_M0X2(14, 2, 1), 540000000 }, /* freq = (6M * 90 ), index = 90 */
{F_N8X5_K4X2_M0X2(16, 3, 2), 544000000 }, /* freq = (6M * 91 ), index = 91 */
{F_N8X5_K4X2_M0X2(22, 0, 0), 552000000 }, /* freq = (6M * 92 ), index = 92 */
{F_N8X5_K4X2_M0X2(22, 1, 1), 552000000 }, /* freq = (6M * 93 ), index = 93 */
{F_N8X5_K4X2_M0X2(23, 0, 0), 576000000 }, /* freq = (6M * 94 ), index = 94 */
{F_N8X5_K4X2_M0X2(11, 1, 0), 576000000 }, /* freq = (6M * 95 ), index = 95 */
{F_N8X5_K4X2_M0X2(7 , 2, 0), 576000000 }, /* freq = (6M * 96 ), index = 96 */
{F_N8X5_K4X2_M0X2(5 , 3, 0), 576000000 }, /* freq = (6M * 97 ), index = 97 */
{F_N8X5_K4X2_M0X2(23, 1, 1), 576000000 }, /* freq = (6M * 98 ), index = 98 */
{F_N8X5_K4X2_M0X2(15, 2, 1), 576000000 }, /* freq = (6M * 99 ), index = 99 */
{F_N8X5_K4X2_M0X2(24, 0, 0), 600000000 }, /* freq = (6M * 100), index = 100*/
{F_N8X5_K4X2_M0X2(18, 3, 2), 608000000 }, /* freq = (6M * 101), index = 101*/
{F_N8X5_K4X2_M0X2(16, 2, 1), 612000000 }, /* freq = (6M * 102), index = 102*/
{F_N8X5_K4X2_M0X2(25, 0, 0), 624000000 }, /* freq = (6M * 103), index = 103*/
{F_N8X5_K4X2_M0X2(12, 1, 0), 624000000 }, /* freq = (6M * 104), index = 104*/
{F_N8X5_K4X2_M0X2(25, 1, 1), 624000000 }, /* freq = (6M * 105), index = 105*/
{F_N8X5_K4X2_M0X2(12, 3, 1), 624000000 }, /* freq = (6M * 106), index = 106*/
{F_N8X5_K4X2_M0X2(12, 1, 1), 624000000 }, /* freq = (6M * 107), index = 107*/
{F_N8X5_K4X2_M0X2(26, 0, 0), 648000000 }, /* freq = (6M * 108), index = 108*/
{F_N8X5_K4X2_M0X2(8 , 2, 0), 648000000 }, /* freq = (6M * 109), index = 109*/
{F_N8X5_K4X2_M0X2(26, 1, 1), 648000000 }, /* freq = (6M * 110), index = 110*/
{F_N8X5_K4X2_M0X2(17, 2, 1), 648000000 }, /* freq = (6M * 111), index = 111*/
{F_N8X5_K4X2_M0X2(27, 0, 0), 672000000 }, /* freq = (6M * 112), index = 112*/
{F_N8X5_K4X2_M0X2(13, 1, 0), 672000000 }, /* freq = (6M * 113), index = 113*/
{F_N8X5_K4X2_M0X2(18, 2, 1), 684000000 }, /* freq = (6M * 114), index = 114*/
{F_N8X5_K4X2_M0X2(28, 0, 0), 696000000 }, /* freq = (6M * 115), index = 115*/
{F_N8X5_K4X2_M0X2(28, 1, 1), 696000000 }, /* freq = (6M * 116), index = 116*/
{F_N8X5_K4X2_M0X2(28, 1, 1), 696000000 }, /* freq = (6M * 117), index = 117*/
{F_N8X5_K4X2_M0X2(28, 1, 1), 696000000 }, /* freq = (6M * 118), index = 118*/
{F_N8X5_K4X2_M0X2(29, 0, 0), 720000000 }, /* freq = (6M * 119), index = 119*/
{F_N8X5_K4X2_M0X2(14, 1, 0), 720000000 }, /* freq = (6M * 120), index = 120*/
{F_N8X5_K4X2_M0X2(9 , 2, 0), 720000000 }, /* freq = (6M * 121), index = 121*/
{F_N8X5_K4X2_M0X2(29, 1, 1), 720000000 }, /* freq = (6M * 122), index = 122*/
{F_N8X5_K4X2_M0X2(19, 2, 1), 720000000 }, /* freq = (6M * 123), index = 123*/
{F_N8X5_K4X2_M0X2(30, 0, 0), 744000000 }, /* freq = (6M * 124), index = 124*/
{F_N8X5_K4X2_M0X2(30, 1, 1), 744000000 }, /* freq = (6M * 125), index = 125*/
{F_N8X5_K4X2_M0X2(20, 2, 1), 756000000 }, /* freq = (6M * 126), index = 126*/
{F_N8X5_K4X2_M0X2(31, 0, 0), 768000000 }, /* freq = (6M * 127), index = 127*/
{F_N8X5_K4X2_M0X2(15, 1, 0), 768000000 }, /* freq = (6M * 128), index = 128*/
{F_N8X5_K4X2_M0X2(7 , 3, 0), 768000000 }, /* freq = (6M * 129), index = 129*/
{F_N8X5_K4X2_M0X2(31, 1, 1), 768000000 }, /* freq = (6M * 130), index = 130*/
{F_N8X5_K4X2_M0X2(15, 3, 1), 768000000 }, /* freq = (6M * 131), index = 131*/
{F_N8X5_K4X2_M0X2(10, 2, 0), 792000000 }, /* freq = (6M * 132), index = 132*/
{F_N8X5_K4X2_M0X2(21, 2, 1), 792000000 }, /* freq = (6M * 133), index = 133*/
{F_N8X5_K4X2_M0X2(21, 2, 1), 792000000 }, /* freq = (6M * 134), index = 134*/
{F_N8X5_K4X2_M0X2(16, 1, 0), 816000000 }, /* freq = (6M * 135), index = 135*/
{F_N8X5_K4X2_M0X2(16, 3, 1), 816000000 }, /* freq = (6M * 136), index = 136*/
{F_N8X5_K4X2_M0X2(16, 3, 1), 816000000 }, /* freq = (6M * 137), index = 137*/
{F_N8X5_K4X2_M0X2(22, 2, 1), 828000000 }, /* freq = (6M * 138), index = 138*/
{F_N8X5_K4X2_M0X2(22, 2, 1), 828000000 }, /* freq = (6M * 139), index = 139*/
{F_N8X5_K4X2_M0X2(17, 1, 0), 864000000 }, /* freq = (6M * 140), index = 140*/
{F_N8X5_K4X2_M0X2(11, 2, 0), 864000000 }, /* freq = (6M * 141), index = 141*/
{F_N8X5_K4X2_M0X2(8 , 3, 0), 864000000 }, /* freq = (6M * 142), index = 142*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 143), index = 143*/
{F_N8X5_K4X2_M0X2(17, 3, 1), 864000000 }, /* freq = (6M * 144), index = 144*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 145), index = 145*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 146), index = 146*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 147), index = 147*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 148), index = 148*/
{F_N8X5_K4X2_M0X2(23, 2, 1), 864000000 }, /* freq = (6M * 149), index = 149*/
{F_N8X5_K4X2_M0X2(24, 2, 1), 900000000 }, /* freq = (6M * 150), index = 150*/
{F_N8X5_K4X2_M0X2(24, 2, 1), 900000000 }, /* freq = (6M * 151), index = 151*/
{F_N8X5_K4X2_M0X2(18, 1, 0), 912000000 }, /* freq = (6M * 152), index = 152*/
{F_N8X5_K4X2_M0X2(18, 3, 1), 912000000 }, /* freq = (6M * 153), index = 153*/
{F_N8X5_K4X2_M0X2(18, 3, 1), 912000000 }, /* freq = (6M * 154), index = 154*/
{F_N8X5_K4X2_M0X2(18, 3, 1), 912000000 }, /* freq = (6M * 155), index = 155*/
{F_N8X5_K4X2_M0X2(12, 2, 1), 936000000 }, /* freq = (6M * 156), index = 156*/
{F_N8X5_K4X2_M0X2(25, 2, 1), 936000000 }, /* freq = (6M * 157), index = 157*/
{F_N8X5_K4X2_M0X2(25, 2, 1), 936000000 }, /* freq = (6M * 158), index = 158*/
{F_N8X5_K4X2_M0X2(25, 2, 1), 936000000 }, /* freq = (6M * 159), index = 159*/
{F_N8X5_K4X2_M0X2(19, 1, 0), 960000000 }, /* freq = (6M * 160), index = 160*/
{F_N8X5_K4X2_M0X2(9 , 3, 0), 960000000 }, /* freq = (6M * 161), index = 161*/
{F_N8X5_K4X2_M0X2(9 , 3, 0), 960000000 }, /* freq = (6M * 162), index = 162*/
{F_N8X5_K4X2_M0X2(19, 1, 0), 960000000 }, /* freq = (6M * 163), index = 163*/
{F_N8X5_K4X2_M0X2(9 , 3, 0), 960000000 }, /* freq = (6M * 164), index = 164*/
{F_N8X5_K4X2_M0X2(9 , 3, 0), 960000000 }, /* freq = (6M * 165), index = 165*/
{F_N8X5_K4X2_M0X2(19, 1, 0), 960000000 }, /* freq = (6M * 166), index = 166*/
{F_N8X5_K4X2_M0X2(9 , 3, 0), 960000000 }, /* freq = (6M * 167), index = 167*/
{F_N8X5_K4X2_M0X2(20, 1, 0), 1008000000}, /* freq = (6M * 168), index = 168*/
{F_N8X5_K4X2_M0X2(13, 2, 0), 1008000000}, /* freq = (6M * 169), index = 169*/
{F_N8X5_K4X2_M0X2(20, 1, 0), 1008000000}, /* freq = (6M * 170), index = 170*/
{F_N8X5_K4X2_M0X2(13, 2, 0), 1008000000}, /* freq = (6M * 171), index = 171*/
{F_N8X5_K4X2_M0X2(20, 1, 0), 1008000000}, /* freq = (6M * 172), index = 172*/
{F_N8X5_K4X2_M0X2(13, 2, 0), 1008000000}, /* freq = (6M * 173), index = 173*/
{F_N8X5_K4X2_M0X2(13, 2, 0), 1008000000}, /* freq = (6M * 174), index = 174*/
{F_N8X5_K4X2_M0X2(21, 1, 0), 1056000000}, /* freq = (6M * 175), index = 175*/
{F_N8X5_K4X2_M0X2(10, 3, 0), 1056000000}, /* freq = (6M * 176), index = 176*/
{F_N8X5_K4X2_M0X2(21, 1, 0), 1056000000}, /* freq = (6M * 177), index = 177*/
{F_N8X5_K4X2_M0X2(10, 3, 0), 1056000000}, /* freq = (6M * 178), index = 178*/
{F_N8X5_K4X2_M0X2(21, 1, 0), 1056000000}, /* freq = (6M * 179), index = 179*/
{F_N8X5_K4X2_M0X2(14, 2, 0), 1080000000}, /* freq = (6M * 180), index = 180*/
{F_N8X5_K4X2_M0X2(14, 2, 0), 1080000000}, /* freq = (6M * 181), index = 181*/
{F_N8X5_K4X2_M0X2(14, 2, 0), 1080000000}, /* freq = (6M * 182), index = 182*/
{F_N8X5_K4X2_M0X2(14, 2, 0), 1080000000}, /* freq = (6M * 183), index = 183*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 184), index = 184*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 185), index = 185*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 186), index = 186*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 187), index = 187*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 188), index = 188*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 189), index = 189*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 190), index = 190*/
{F_N8X5_K4X2_M0X2(22, 1, 0), 1104000000}, /* freq = (6M * 191), index = 191*/
{F_N8X5_K4X2_M0X2(23, 1, 0), 1152000000}, /* freq = (6M * 192), index = 192*/
{F_N8X5_K4X2_M0X2(15, 2, 0), 1152000000}, /* freq = (6M * 193), index = 193*/
{F_N8X5_K4X2_M0X2(11, 3, 0), 1152000000}, /* freq = (6M * 194), index = 194*/
{F_N8X5_K4X2_M0X2(23, 1, 0), 1152000000}, /* freq = (6M * 195), index = 195*/
{F_N8X5_K4X2_M0X2(15, 2, 0), 1152000000}, /* freq = (6M * 196), index = 196*/
{F_N8X5_K4X2_M0X2(11, 3, 0), 1152000000}, /* freq = (6M * 197), index = 197*/
{F_N8X5_K4X2_M0X2(23, 1, 0), 1152000000}, /* freq = (6M * 198), index = 198*/
{F_N8X5_K4X2_M0X2(15, 2, 0), 1152000000}, /* freq = (6M * 199), index = 199*/
{F_N8X5_K4X2_M0X2(24, 1, 0), 1200000000}, /* freq = (6M * 200), index = 200*/
{F_N8X5_K4X2_M0X2(24, 1, 0), 1200000000}, /* freq = (6M * 201), index = 201*/
{F_N8X5_K4X2_M0X2(24, 1, 0), 1200000000}, /* freq = (6M * 202), index = 202*/
{F_N8X5_K4X2_M0X2(24, 1, 0), 1200000000}, /* freq = (6M * 203), index = 203*/
{F_N8X5_K4X2_M0X2(16, 2, 0), 1224000000}, /* freq = (6M * 204), index = 204*/
{F_N8X5_K4X2_M0X2(16, 2, 0), 1224000000}, /* freq = (6M * 205), index = 205*/
{F_N8X5_K4X2_M0X2(16, 2, 0), 1224000000}, /* freq = (6M * 206), index = 206*/
{F_N8X5_K4X2_M0X2(16, 2, 0), 1224000000}, /* freq = (6M * 207), index = 207*/
{F_N8X5_K4X2_M0X2(25, 1, 0), 1248000000}, /* freq = (6M * 208), index = 208*/
{F_N8X5_K4X2_M0X2(12, 3, 0), 1248000000}, /* freq = (6M * 209), index = 209*/
{F_N8X5_K4X2_M0X2(25, 1, 0), 1248000000}, /* freq = (6M * 210), index = 210*/
{F_N8X5_K4X2_M0X2(12, 3, 0), 1248000000}, /* freq = (6M * 211), index = 211*/
{F_N8X5_K4X2_M0X2(25, 1, 0), 1248000000}, /* freq = (6M * 212), index = 212*/
{F_N8X5_K4X2_M0X2(12, 3, 0), 1248000000}, /* freq = (6M * 213), index = 213*/
{F_N8X5_K4X2_M0X2(25, 1, 0), 1248000000}, /* freq = (6M * 214), index = 214*/
{F_N8X5_K4X2_M0X2(12, 3, 0), 1248000000}, /* freq = (6M * 215), index = 215*/
{F_N8X5_K4X2_M0X2(26, 1, 0), 1296000000}, /* freq = (6M * 216), index = 216*/
{F_N8X5_K4X2_M0X2(17, 2, 0), 1296000000}, /* freq = (6M * 217), index = 217*/
{F_N8X5_K4X2_M0X2(26, 1, 0), 1296000000}, /* freq = (6M * 218), index = 218*/
{F_N8X5_K4X2_M0X2(17, 2, 0), 1296000000}, /* freq = (6M * 219), index = 219*/
{F_N8X5_K4X2_M0X2(26, 1, 0), 1296000000}, /* freq = (6M * 220), index = 220*/
{F_N8X5_K4X2_M0X2(17, 2, 0), 1296000000}, /* freq = (6M * 221), index = 221*/
{F_N8X5_K4X2_M0X2(26, 1, 0), 1296000000}, /* freq = (6M * 222), index = 222*/
{F_N8X5_K4X2_M0X2(17, 2, 0), 1296000000}, /* freq = (6M * 223), index = 223*/
{F_N8X5_K4X2_M0X2(27, 1, 0), 1344000000}, /* freq = (6M * 224), index = 224*/
{F_N8X5_K4X2_M0X2(13, 3, 0), 1344000000}, /* freq = (6M * 225), index = 225*/
{F_N8X5_K4X2_M0X2(13, 3, 0), 1344000000}, /* freq = (6M * 226), index = 226*/
{F_N8X5_K4X2_M0X2(13, 3, 0), 1344000000}, /* freq = (6M * 227), index = 227*/
{F_N8X5_K4X2_M0X2(18, 2, 0), 1368000000}, /* freq = (6M * 228), index = 228*/
{F_N8X5_K4X2_M0X2(18, 2, 0), 1368000000}, /* freq = (6M * 229), index = 229*/
{F_N8X5_K4X2_M0X2(18, 2, 0), 1368000000}, /* freq = (6M * 230), index = 230*/
{F_N8X5_K4X2_M0X2(18, 2, 0), 1368000000}, /* freq = (6M * 231), index = 231*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 232), index = 232*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 233), index = 233*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 234), index = 234*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 235), index = 235*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 236), index = 236*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 237), index = 237*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 238), index = 238*/
{F_N8X5_K4X2_M0X2(28, 1, 0), 1392000000}, /* freq = (6M * 239), index = 239*/
{F_N8X5_K4X2_M0X2(29, 1, 0), 1440000000}, /* freq = (6M * 240), index = 240*/
};
static struct sunxi_clk_factor_freq    factor_pll6_tbl[] = {
{F_N8X5_K4X2(0 , 0), 12000000 }, /* freq = (12M * 0  ), index = 0  */
{F_N8X5_K4X2(0 , 0), 12000000 }, /* freq = (12M * 1  ), index = 1  */
{F_N8X5_K4X2(1 , 0), 24000000 }, /* freq = (12M * 2  ), index = 2  */
{F_N8X5_K4X2(2 , 0), 36000000 }, /* freq = (12M * 3  ), index = 3  */
{F_N8X5_K4X2(3 , 0), 48000000 }, /* freq = (12M * 4  ), index = 4  */
{F_N8X5_K4X2(4 , 0), 60000000 }, /* freq = (12M * 5  ), index = 5  */
{F_N8X5_K4X2(5 , 0), 72000000 }, /* freq = (12M * 6  ), index = 6  */
{F_N8X5_K4X2(6 , 0), 84000000 }, /* freq = (12M * 7  ), index = 7  */
{F_N8X5_K4X2(7 , 0), 96000000 }, /* freq = (12M * 8  ), index = 8  */
{F_N8X5_K4X2(8 , 0), 108000000 }, /* freq = (12M * 9  ), index = 9  */
{F_N8X5_K4X2(9 , 0), 120000000 }, /* freq = (12M * 10 ), index = 10 */
{F_N8X5_K4X2(10 , 0),132000000 }, /* freq = (12M * 11 ), index = 11 */
{F_N8X5_K4X2(11 , 0),144000000 }, /* freq = (12M * 12 ), index = 12 */
{F_N8X5_K4X2(12 , 0),156000000 }, /* freq = (12M * 13 ), index = 13 */
{F_N8X5_K4X2(13 , 0),168000000 }, /* freq = (12M * 14 ), index = 14 */
{F_N8X5_K4X2(14 , 0),180000000 }, /* freq = (12M * 15 ), index = 15 */
{F_N8X5_K4X2(15 , 0),192000000 }, /* freq = (12M * 16 ), index = 16 */
{F_N8X5_K4X2(16 , 0),204000000 }, /* freq = (12M * 17 ), index = 17 */
{F_N8X5_K4X2(17 , 0),216000000 }, /* freq = (12M * 18 ), index = 18 */
{F_N8X5_K4X2(18 , 0),228000000 }, /* freq = (12M * 19 ), index = 19 */
{F_N8X5_K4X2(19 , 0),240000000 }, /* freq = (12M * 20 ), index = 20 */
{F_N8X5_K4X2(20 , 0),252000000 }, /* freq = (12M * 21 ), index = 21 */
{F_N8X5_K4X2(21, 0), 264000000 }, /* freq = (12M * 22 ), index = 22 */
{F_N8X5_K4X2(22, 0), 276000000 }, /* freq = (12M * 23 ), index = 23 */
{F_N8X5_K4X2(23 , 0),288000000 }, /* freq = (12M * 24 ), index = 24 */
{F_N8X5_K4X2(24 , 0),300000000 }, /* freq = (12M * 25 ), index = 25 */
{F_N8X5_K4X2(25, 0), 312000000 }, /* freq = (12M * 26 ), index = 26 */
{F_N8X5_K4X2(26, 0), 324000000 }, /* freq = (12M * 27 ), index = 27 */
{F_N8X5_K4X2(27 , 0),336000000 }, /* freq = (12M * 28 ), index = 28 */
{F_N8X5_K4X2(28, 0), 348000000 }, /* freq = (12M * 29 ), index = 29 */
{F_N8X5_K4X2(29, 0), 360000000 }, /* freq = (12M * 30 ), index = 30 */
{F_N8X5_K4X2(30, 0), 372000000 }, /* freq = (12M * 31 ), index = 31 */
{F_N8X5_K4X2(31 , 0),	384000000 }, /* freq = (12M * 32 ), index = 32 */
{F_N8X5_K4X2(10 , 2),	396000000 }, /* freq = (12M * 33 ), index = 33 */
{F_N8X5_K4X2(16, 1), 408000000}, /* freq = (12M * 34 ), index = 34 */
{F_N8X5_K4X2(16, 1), 408000000}, /* freq = (12M * 35 ), index = 35 */
{F_N8X5_K4X2(17 ,1), 432000000}, /* freq = (12M * 36 ), index = 36 */
{F_N8X5_K4X2(17 ,1), 432000000}, /* freq = (12M * 37 ), index = 37 */
{F_N8X5_K4X2(18, 1), 444000000}, /* freq = (12M * 38 ), index = 38 */
{F_N8X5_K4X2(12 , 2),468000000}, /* freq = (12M * 39 ), index = 39 */
{F_N8X5_K4X2(19 , 1),480000000}, /* freq = (12M * 40 ), index = 40 */
{F_N8X5_K4X2(19 , 1),480000000}, /* freq = (12M * 41 ), index = 41 */
{F_N8X5_K4X2(20, 1), 504000000}, /* freq = (12M * 42 ), index = 42 */
{F_N8X5_K4X2(20, 1), 504000000}, /* freq = (12M * 43 ), index = 43 */
{F_N8X5_K4X2(21, 1), 528000000}, /* freq = (12M * 44 ), index = 44 */
{F_N8X5_K4X2(14, 2), 540000000}, /* freq = (12M * 45 ), index = 45 */
{F_N8X5_K4X2(22, 1), 552000000}, /* freq = (12M * 46 ), index = 46 */
{F_N8X5_K4X2(22, 1), 552000000}, /* freq = (12M * 47 ), index = 47 */
{F_N8X5_K4X2(23 ,1), 576000000}, /* freq = (12M * 48 ), index = 48 */
{F_N8X5_K4X2(23 ,1), 576000000}, /* freq = (12M * 49 ), index = 49 */
{F_N8X5_K4X2(24, 1), 600000000}, /* freq = (12M * 50 ), index = 50 */
};

/* media factors config table, frequency = 24*N/M */
static struct sunxi_clk_factor_freq factor_m_tbl[] = {
{F_N8X7_M0X4(0 , 3), 6000000  }, /* freq = (3M * 0  ), index = 0  */
{F_N8X7_M0X4(0 , 3), 6000000  }, /* freq = (3M * 1  ), index = 1  */
{F_N8X7_M0X4(0 , 3), 6000000  }, /* freq = (3M * 2  ), index = 2  */
{F_N8X7_M0X4(0 , 2), 8000000  }, /* freq = (3M * 3  ), index = 3  */
{F_N8X7_M0X4(1 , 3), 12000000 }, /* freq = (3M * 4  ), index = 4  */
{F_N8X7_M0X4(1 , 2), 16000000 }, /* freq = (3M * 5  ), index = 5  */
{F_N8X7_M0X4(2 , 3), 18000000 }, /* freq = (3M * 6  ), index = 6  */
{F_N8X7_M0X4(2 , 3), 18000000 }, /* freq = (3M * 7  ), index = 7  */
{F_N8X7_M0X4(0 , 0), 24000000 }, /* freq = (3M * 8  ), index = 8  */
{F_N8X7_M0X4(2 , 2), 24000000 }, /* freq = (3M * 9  ), index = 9  */
{F_N8X7_M0X4(4 , 3), 30000000 }, /* freq = (3M * 10 ), index = 10 */
{F_N8X7_M0X4(3 , 2), 32000000 }, /* freq = (3M * 11 ), index = 11 */
{F_N8X7_M0X4(5 , 3), 36000000 }, /* freq = (3M * 12 ), index = 12 */
{F_N8X7_M0X4(4 , 2), 40000000 }, /* freq = (3M * 13 ), index = 13 */
{F_N8X7_M0X4(6 , 3), 42000000 }, /* freq = (3M * 14 ), index = 14 */
{F_N8X7_M0X4(6 , 3), 42000000 }, /* freq = (3M * 15 ), index = 15 */
{F_N8X7_M0X4(1 , 0), 48000000 }, /* freq = (3M * 16 ), index = 16 */
{F_N8X7_M0X4(1 , 0), 48000000 }, /* freq = (3M * 17 ), index = 17 */
{F_N8X7_M0X4(8 , 3), 54000000 }, /* freq = (3M * 18 ), index = 18 */
{F_N8X7_M0X4(6 , 2), 56000000 }, /* freq = (3M * 19 ), index = 19 */
{F_N8X7_M0X4(4 , 1), 60000000 }, /* freq = (3M * 20 ), index = 20 */
{F_N8X7_M0X4(8 , 2), 64000000 }, /* freq = (3M * 21 ), index = 21 */
{F_N8X7_M0X4(10, 3), 66000000 }, /* freq = (3M * 22 ), index = 22 */
{F_N8X7_M0X4(10, 3), 66000000 }, /* freq = (3M * 23 ), index = 23 */
{F_N8X7_M0X4(2 , 0), 72000000 }, /* freq = (3M * 24 ), index = 24 */
{F_N8X7_M0X4(2 , 0), 72000000 }, /* freq = (3M * 25 ), index = 25 */
{F_N8X7_M0X4(12, 3), 78000000 }, /* freq = (3M * 26 ), index = 26 */
{F_N8X7_M0X4(12, 3), 78000000 }, /* freq = (3M * 27 ), index = 27 */
{F_N8X7_M0X4(6 , 1), 84000000 }, /* freq = (3M * 28 ), index = 28 */
{F_N8X7_M0X4(14, 3), 90000000 }, /* freq = (3M * 29 ), index = 29 */
{F_N8X7_M0X4(14, 3), 90000000 }, /* freq = (3M * 30 ), index = 30 */
{F_N8X7_M0X4(14, 3), 90000000 }, /* freq = (3M * 31 ), index = 31 */
{F_N8X7_M0X4(3 , 0), 96000000 }, /* freq = (3M * 32 ), index = 32 */
{F_N8X7_M0X4(3 , 0), 96000000 }, /* freq = (3M * 33 ), index = 33 */
{F_N8X7_M0X4(16, 3), 102000000}, /* freq = (3M * 34 ), index = 34 */
{F_N8X7_M0X4(16, 3), 102000000}, /* freq = (3M * 35 ), index = 35 */
{F_N8X7_M0X4(8 , 1), 108000000}, /* freq = (3M * 36 ), index = 36 */
{F_N8X7_M0X4(8 , 1), 108000000}, /* freq = (3M * 37 ), index = 37 */
{F_N8X7_M0X4(18, 3), 114000000}, /* freq = (3M * 38 ), index = 38 */
{F_N8X7_M0X4(4 , 0), 120000000}, /* freq = (3M * 39 ), index = 39 */
{F_N8X7_M0X4(4 , 0), 120000000}, /* freq = (3M * 40 ), index = 40 */
{F_N8X7_M0X4(4 , 0), 120000000}, /* freq = (3M * 41 ), index = 41 */
{F_N8X7_M0X4(20, 3), 126000000}, /* freq = (3M * 42 ), index = 42 */
{F_N8X7_M0X4(20, 3), 126000000}, /* freq = (3M * 43 ), index = 43 */
{F_N8X7_M0X4(10, 1), 132000000}, /* freq = (3M * 44 ), index = 44 */
{F_N8X7_M0X4(10, 1), 132000000}, /* freq = (3M * 45 ), index = 45 */
{F_N8X7_M0X4(22, 3), 138000000}, /* freq = (3M * 46 ), index = 46 */
{F_N8X7_M0X4(22, 3), 138000000}, /* freq = (3M * 47 ), index = 47 */
{F_N8X7_M0X4(5 , 0), 144000000}, /* freq = (3M * 48 ), index = 48 */
{F_N8X7_M0X4(5 , 0), 144000000}, /* freq = (3M * 49 ), index = 49 */
{F_N8X7_M0X4(24, 3), 150000000}, /* freq = (3M * 50 ), index = 50 */
{F_N8X7_M0X4(24, 3), 150000000}, /* freq = (3M * 51 ), index = 51 */
{F_N8X7_M0X4(12, 1), 156000000}, /* freq = (3M * 52 ), index = 52 */
{F_N8X7_M0X4(12, 1), 156000000}, /* freq = (3M * 53 ), index = 53 */
{F_N8X7_M0X4(12, 1), 156000000}, /* freq = (3M * 54 ), index = 54 */
{F_N8X7_M0X4(6 , 0), 168000000}, /* freq = (3M * 55 ), index = 55 */
{F_N8X7_M0X4(6 , 0), 168000000}, /* freq = (3M * 56 ), index = 56 */
{F_N8X7_M0X4(6 , 0), 168000000}, /* freq = (3M * 57 ), index = 57 */
{F_N8X7_M0X4(6 , 0), 168000000}, /* freq = (3M * 58 ), index = 58 */
{F_N8X7_M0X4(14, 1), 180000000}, /* freq = (3M * 59 ), index = 59 */
{F_N8X7_M0X4(14, 1), 180000000}, /* freq = (3M * 60 ), index = 60 */
{F_N8X7_M0X4(14, 1), 180000000}, /* freq = (3M * 61 ), index = 61 */
{F_N8X7_M0X4(14, 1), 180000000}, /* freq = (3M * 62 ), index = 62 */
{F_N8X7_M0X4(7 , 0), 192000000}, /* freq = (3M * 63 ), index = 63 */
{F_N8X7_M0X4(7 , 0), 192000000}, /* freq = (3M * 64 ), index = 64 */
{F_N8X7_M0X4(7 , 0), 192000000}, /* freq = (3M * 65 ), index = 65 */
{F_N8X7_M0X4(24, 2), 200000000}, /* freq = (3M * 66 ), index = 66 */
{F_N8X7_M0X4(24, 2), 200000000}, /* freq = (3M * 67 ), index = 67 */
{F_N8X7_M0X4(16, 1), 204000000}, /* freq = (3M * 68 ), index = 68 */
{F_N8X7_M0X4(16, 1), 204000000}, /* freq = (3M * 69 ), index = 69 */
{F_N8X7_M0X4(16, 1), 204000000}, /* freq = (3M * 70 ), index = 70 */
{F_N8X7_M0X4(8 , 0), 216000000}, /* freq = (3M * 71 ), index = 71 */
{F_N8X7_M0X4(8 , 0), 216000000}, /* freq = (3M * 72 ), index = 72 */
{F_N8X7_M0X4(8 , 0), 216000000}, /* freq = (3M * 73 ), index = 73 */
{F_N8X7_M0X4(8 , 0), 216000000}, /* freq = (3M * 74 ), index = 74 */
{F_N8X7_M0X4(18, 1), 228000000}, /* freq = (3M * 75 ), index = 75 */
{F_N8X7_M0X4(18, 1), 228000000}, /* freq = (3M * 76 ), index = 76 */
{F_N8X7_M0X4(18, 1), 228000000}, /* freq = (3M * 77 ), index = 77 */
{F_N8X7_M0X4(18, 1), 228000000}, /* freq = (3M * 78 ), index = 78 */
{F_N8X7_M0X4(9 , 0), 240000000}, /* freq = (3M * 79 ), index = 79 */
{F_N8X7_M0X4(9 , 0), 240000000}, /* freq = (3M * 80 ), index = 80 */
{F_N8X7_M0X4(9 , 0), 240000000}, /* freq = (3M * 81 ), index = 81 */
{F_N8X7_M0X4(9 , 0), 240000000}, /* freq = (3M * 82 ), index = 82 */
{F_N8X7_M0X4(20, 1), 252000000}, /* freq = (3M * 83 ), index = 83 */
{F_N8X7_M0X4(20, 1), 252000000}, /* freq = (3M * 84 ), index = 84 */
{F_N8X7_M0X4(20, 1), 252000000}, /* freq = (3M * 85 ), index = 85 */
{F_N8X7_M0X4(20, 1), 252000000}, /* freq = (3M * 86 ), index = 86 */
{F_N8X7_M0X4(10, 0), 264000000}, /* freq = (3M * 87 ), index = 87 */
{F_N8X7_M0X4(10, 0), 264000000}, /* freq = (3M * 88 ), index = 88 */
{F_N8X7_M0X4(22, 1), 276000000}, /* freq = (3M * 89 ), index = 89 */
{F_N8X7_M0X4(10, 0), 270000000}, /* freq = (3M * 90 ), index = 90 */
{F_N8X7_M0X4(22, 1), 276000000}, /* freq = (3M * 91 ), index = 91 */
{F_N8X7_M0X4(22, 1), 276000000}, /* freq = (3M * 92 ), index = 92 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 93 ), index = 93 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 94 ), index = 94 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 95 ), index = 95 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 96 ), index = 96 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 97 ), index = 97 */
{F_N8X7_M0X4(11, 0), 288000000}, /* freq = (3M * 98 ), index = 98 */
{F_N8X7_M0X4(11, 0), 297000000}, /* freq = (3M * 99 ), index = 99 */
{F_N8X7_M0X4(24, 1), 300000000}, /* freq = (3M * 100), index = 100*/
{F_N8X7_M0X4(24, 1), 300000000}, /* freq = (3M * 101), index = 101*/
{F_N8X7_M0X4(24, 1), 300000000}, /* freq = (3M * 102), index = 102*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 103), index = 103*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 104), index = 104*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 105), index = 105*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 106), index = 106*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 107), index = 107*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 108), index = 108*/
{F_N8X7_M0X4(12, 0), 312000000}, /* freq = (3M * 109), index = 109*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 110), index = 110*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 111), index = 111*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 112), index = 112*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 113), index = 113*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 114), index = 114*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 115), index = 115*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 116), index = 116*/
{F_N8X7_M0X4(13, 0), 336000000}, /* freq = (3M * 117), index = 117*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 118), index = 118*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 119), index = 119*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 120), index = 120*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 121), index = 121*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 122), index = 122*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 123), index = 123*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 124), index = 124*/
{F_N8X7_M0X4(14, 0), 360000000}, /* freq = (3M * 125), index = 125*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 126), index = 126*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 127), index = 127*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 128), index = 128*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 129), index = 129*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 130), index = 130*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 131), index = 131*/
{F_N8X7_M0X4(15, 0), 384000000}, /* freq = (3M * 132), index = 132*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 133), index = 133*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 134), index = 134*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 135), index = 135*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 136), index = 136*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 137), index = 137*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 138), index = 138*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 139), index = 139*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 140), index = 140*/
{F_N8X7_M0X4(16, 0), 408000000}, /* freq = (3M * 141), index = 141*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 142), index = 142*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 143), index = 143*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 144), index = 144*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 145), index = 145*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 146), index = 146*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 147), index = 147*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 148), index = 148*/
{F_N8X7_M0X4(17, 0), 432000000}, /* freq = (3M * 149), index = 149*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 150), index = 150*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 151), index = 151*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 152), index = 152*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 153), index = 153*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 154), index = 154*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 155), index = 155*/
{F_N8X7_M0X4(18, 0), 456000000}, /* freq = (3M * 156), index = 156*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 157), index = 157*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 158), index = 158*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 159), index = 159*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 160), index = 160*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 161), index = 161*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 162), index = 162*/
{F_N8X7_M0X4(19, 0), 480000000}, /* freq = (3M * 163), index = 163*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 164), index = 164*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 165), index = 165*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 166), index = 166*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 167), index = 167*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 168), index = 168*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 169), index = 169*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 170), index = 170*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 171), index = 171*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 172), index = 172*/
{F_N8X7_M0X4(20, 0), 504000000}, /* freq = (3M * 173), index = 173*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 174), index = 174*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 175), index = 175*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 176), index = 176*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 177), index = 177*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 178), index = 178*/
{F_N8X7_M0X4(21, 0), 528000000}, /* freq = (3M * 179), index = 179*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 180), index = 180*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 181), index = 181*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 182), index = 182*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 183), index = 183*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 184), index = 184*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 185), index = 185*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 186), index = 186*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 187), index = 187*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 188), index = 188*/
{F_N8X7_M0X4(22, 0), 552000000}, /* freq = (3M * 189), index = 189*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 190), index = 190*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 191), index = 191*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 192), index = 192*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 193), index = 193*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 194), index = 194*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 195), index = 195*/
{F_N8X7_M0X4(23, 0), 576000000}, /* freq = (3M * 196), index = 196*/
{F_N8X7_M0X4(24, 0), 600000000}, /* freq = (3M * 197), index = 197*/
{F_N8X7_M0X4(24, 0), 600000000}, /* freq = (3M * 198), index = 198*/
{F_N8X7_M0X4(24, 0), 600000000}, /* freq = (3M * 199), index = 199*/
{F_N8X7_M0X4(99 , 3), 600000000}, /* freq = (3M * 201), index = 200*/
{F_N8X7_M0X4(99 , 3), 600000000}, /* freq = (3M * 201), index = 201*/
{F_N8X7_M0X4(100, 3), 606000000}, /* freq = (3M * 202), index = 202*/
{F_N8X7_M0X4(100, 3), 606000000}, /* freq = (3M * 203), index = 203*/
{F_N8X7_M0X4(101, 3), 612000000}, /* freq = (3M * 204), index = 204*/
{F_N8X7_M0X4(101, 3), 612000000}, /* freq = (3M * 205), index = 205*/
{F_N8X7_M0X4(102, 3), 618000000}, /* freq = (3M * 206), index = 206*/
{F_N8X7_M0X4(102, 3), 618000000}, /* freq = (3M * 207), index = 207*/
{F_N8X7_M0X4(103, 3), 624000000}, /* freq = (3M * 208), index = 208*/
{F_N8X7_M0X4(103, 3), 624000000}, /* freq = (3M * 209), index = 209*/
{F_N8X7_M0X4(104, 3), 630000000}, /* freq = (3M * 210), index = 210*/
{F_N8X7_M0X4(104, 3), 630000000}, /* freq = (3M * 211), index = 211*/
{F_N8X7_M0X4(105, 3), 636000000}, /* freq = (3M * 212), index = 212*/
{F_N8X7_M0X4(105, 3), 636000000}, /* freq = (3M * 213), index = 213*/
{F_N8X7_M0X4(106, 3), 642000000}, /* freq = (3M * 214), index = 214*/
{F_N8X7_M0X4(106, 3), 642000000}, /* freq = (3M * 215), index = 215*/
{F_N8X7_M0X4(107, 3), 648000000}, /* freq = (3M * 216), index = 216*/
{F_N8X7_M0X4(107, 3), 648000000}, /* freq = (3M * 217), index = 217*/
{F_N8X7_M0X4(108, 3), 654000000}, /* freq = (3M * 218), index = 218*/
{F_N8X7_M0X4(108, 3), 654000000}, /* freq = (3M * 219), index = 219*/
{F_N8X7_M0X4(109, 3), 660000000}, /* freq = (3M * 220), index = 220*/
{F_N8X7_M0X4(109, 3), 660000000}, /* freq = (3M * 221), index = 221*/
{F_N8X7_M0X4(110, 3), 666000000}, /* freq = (3M * 222), index = 222*/
{F_N8X7_M0X4(110, 3), 666000000}, /* freq = (3M * 223), index = 223*/
{F_N8X7_M0X4(111, 3), 672000000}, /* freq = (3M * 224), index = 224*/
{F_N8X7_M0X4(111, 3), 672000000}, /* freq = (3M * 225), index = 225*/
{F_N8X7_M0X4(112, 3), 678000000}, /* freq = (3M * 226), index = 226*/
{F_N8X7_M0X4(112, 3), 678000000}, /* freq = (3M * 227), index = 227*/
{F_N8X7_M0X4(113, 3), 684000000}, /* freq = (3M * 228), index = 228*/
{F_N8X7_M0X4(113, 3), 684000000}, /* freq = (3M * 229), index = 229*/
{F_N8X7_M0X4(114, 3), 690000000}, /* freq = (3M * 230), index = 230*/
{F_N8X7_M0X4(114, 3), 690000000}, /* freq = (3M * 231), index = 231*/
{F_N8X7_M0X4(115, 3), 696000000}, /* freq = (3M * 232), index = 232*/
{F_N8X7_M0X4(115, 3), 696000000}, /* freq = (3M * 233), index = 233*/
{F_N8X7_M0X4(116, 3), 702000000}, /* freq = (3M * 224), index = 234*/
{F_N8X7_M0X4(116, 3), 702000000}, /* freq = (3M * 225), index = 235*/
{F_N8X7_M0X4(117, 3), 708000000}, /* freq = (3M * 226), index = 236*/
{F_N8X7_M0X4(117, 3), 708000000}, /* freq = (3M * 227), index = 237*/
{F_N8X7_M0X4(118, 3), 714000000}, /* freq = (3M * 226), index = 238*/
{F_N8X7_M0X4(118, 3), 714000000}, /* freq = (3M * 227), index = 239*/  
{F_N8X7_M0X4(119, 3), 720000000}, /* freq = (3M * 240), index = 240*/  
};

/*                        ns  nw  ks  kw  ms  mw  ps  pw  d1s  d1w  d2s  d2w  {frac  out  mode}  en-s   sdmss  sdmsw  sdmpat      sdmval*/
SUNXI_CLK_FACTORS(pll1,   8,  5,  4,  2,  0,  2,  0,  0,  0,   0,   0,   0,    0,    0,   0,     31,    0,     0,       0,        0);
SUNXI_CLK_FACTORS(pll2,   8,  7,  0,  0,  0,  5,  16, 4,  0,   0,   0,   0,    0,    0,   0,     31,    0,     0,       0,        0);
SUNXI_CLK_FACTORS(media,  8,  7,  0,  0,  0,  4,  0,  0,  0,   0,   0,   0,    1,    25,  24,    31,    0,     0,       0,        0);
SUNXI_CLK_FACTORS(pll6,   8,  5,  4,  2,  0,  2,  0,  0,  0,   0,   0,   0,    0,    0,   0,     31,    0,     0,       0,        0);
SUNXI_CLK_FACTORS(mipi,   8,  4,  4,  2,  0,  4,  0,  0,  0,   0,   0,   0,    0,    0,   0,     31,    0,     0,       0,        0);

static int get_factors_pll1(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{
   int index;
    u64 tmp_rate;
    if(!factor)
        return -1;
    tmp_rate = rate>1440000000 ? 1440000000 : rate;
    do_div(tmp_rate, 6000000);
    index = tmp_rate;
 		if(sunxi_clk_get_common_factors(&sunxi_clk_factor_pll1,factor, factor_pll1_tbl,index,sizeof(factor_pll1_tbl)))
 			return -1;
    return 0;
}
static int get_factors_pll6(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{
   int index;
    u64 tmp_rate;
    if(!factor)
        return -1;
    tmp_rate = rate>600000000 ? 600000000 : rate;
    do_div(tmp_rate, 12000000);
    index = tmp_rate;
        if(sunxi_clk_get_common_factors(&sunxi_clk_factor_pll6,factor, factor_pll6_tbl,index,sizeof(factor_pll6_tbl)))
 			return -1;
    return 0;
}
static int get_factors_pll2(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{
    if(rate == 22579200) {
        factor->factorn = 78;
        factor->factorm = 20;
        factor->factorp = 3;
    } else if(rate == 24576000) {
        factor->factorn = 85;
        factor->factorm = 20;
        factor->factorp = 3;
    } else
        return -1;

    return 0;
}

static int get_factors_media(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{
    u64 tmp_rate;	
    int index;    
    if(!factor)
        return -1;

    tmp_rate = rate>720000000 ? 7200000000 : rate;
    do_div(tmp_rate, 3000000);
    index = tmp_rate;
 		if(sunxi_clk_get_common_factors(&sunxi_clk_factor_media,factor, factor_m_tbl,index,sizeof(factor_m_tbl)))
 			return -1;
    if(rate == 297000000) {
        factor->frac_mode = 0;
        factor->frac_freq = 1;
    }
    else if(rate == 270000000) {
        factor->frac_mode = 0;
        factor->frac_freq = 0;
    } else {
        factor->frac_mode = 1;
        factor->frac_freq = 0;
    }

    return 0;
}
static int get_factors_mipi(u32 rate, u32 parent_rate, struct clk_factors_value *factor)
{

    u64 tmp_rate;
    u32 delta1,delta2,want_rate,new_rate,save_rate=0;
    int n,k,m;
    if(!factor)
        return -1;
    tmp_rate = rate>1440000000 ? 1440000000 : rate;
    do_div(tmp_rate, 1000000);
    want_rate = tmp_rate;
    for(m=1;			m <=16;	m++)
		for(k=1;			k <=4;	k++)
            for(n=1;			n <=16;	n++)
            {
                new_rate = (parent_rate/1000000)*k*n/m;
                delta1 = (new_rate > want_rate)?(new_rate - want_rate):(want_rate - new_rate);
                delta2 =  (save_rate > want_rate)?(save_rate - want_rate):(want_rate - save_rate);
                if(delta1 < delta2)
                {
                    factor->factorn = n-1;
                    factor->factork = k-1;
                    factor->factorm = m-1;
                    save_rate = new_rate;
                }
            }
 
    return 0;
}
static unsigned long calc_rate_pll1(u32 parent_rate, struct clk_factors_value *factor)
{
    return (unsigned long)(parent_rate?parent_rate:24000000) * (factor->factorn+1) * (factor->factork+1) / (factor->factorm+1);
}

static unsigned long calc_rate_pll2(u32 parent_rate, struct clk_factors_value *factor)
{
    if((factor->factorn == 78) && (factor->factorm == 20) && (factor->factorp == 3))
        return 22579200;
    else if((factor->factorn == 85) && (factor->factorm == 20) && (factor->factorp == 3))
        return 24576000;
    else
        return (unsigned long)(parent_rate?parent_rate:24000000) * (factor->factorn+1)/((factor->factorm+1) * (factor->factorp+1));
}

static unsigned long calc_rate_media(u32 parent_rate, struct clk_factors_value *factor)
{
    if(factor->frac_mode == 0)
    {
        if(factor->frac_freq == 1)
          return 297000000;
        else
          return 270000000;
    }
    else
    {
    return (unsigned long)(parent_rate?parent_rate:24000000) * (factor->factorn+1)/(factor->factorm+1);
    }
}

static unsigned long calc_rate_pll6(u32 parent_rate, struct clk_factors_value *factor)
{
    return (unsigned long)(parent_rate?(parent_rate/2):12000000) * (factor->factorn+1) * (factor->factork+1);
}
static unsigned long calc_rate_mipi(u32 parent_rate, struct clk_factors_value *factor)
{
    return (unsigned long)(parent_rate?parent_rate:24000000) * (factor->factorn+1) * (factor->factork+1) / (factor->factorm+1);
}
u8 get_parent_mipi(struct clk_hw *hw)
{
    u8 parent;
    unsigned long reg;
	struct sunxi_clk_factors *factor = to_clk_factor(hw);

    if(!factor->reg)
        return 0;
    reg = readl(factor->reg);
    parent = GET_BITS(21, 1, reg);

    return parent;
}


int set_parent_mipi(struct clk_hw *hw, u8 index)
{
    unsigned long reg;
	struct sunxi_clk_factors *factor = to_clk_factor(hw);

    if(!factor->reg)
        return 0;
    reg = readl(factor->reg);
    reg = SET_BITS(21, 1, reg, index);
    writel(reg, factor->reg);
    return 0;
}
static const char *hosc_parents[] = {"hosc"};
static const char *mipi_parents[] = {"pll3","pll7"};
struct clk_ops mipi_ops;
struct factor_init_data sunxi_factos[] = {
    /* name  parent        parent_num, flags reg       lock_reg   lock_bit  config                     get_factors          calc_rate       priv_ops*/
    {"pll1", hosc_parents, 1,          0,    PLL1_CFG, PLL1_CFG,  28,       &sunxi_clk_factor_pll1,  &get_factors_pll1,   &calc_rate_pll1  ,(struct clk_ops*)NULL},
    {"pll2", hosc_parents, 1,          0,    PLL2_CFG, PLL2_CFG,  28,       &sunxi_clk_factor_pll2,  &get_factors_pll2,   &calc_rate_pll2  ,(struct clk_ops*)NULL},
    {"pll3", hosc_parents, 1,          0,    PLL3_CFG, PLL3_CFG,  28,       &sunxi_clk_factor_media, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll4", hosc_parents, 1,          0,    PLL4_CFG, PLL4_CFG,  28,       &sunxi_clk_factor_media, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll5", hosc_parents, 1,          0,    PLL5_CFG, PLL5_CFG,  28,       &sunxi_clk_factor_pll1,  &get_factors_pll1,   &calc_rate_pll1  ,(struct clk_ops*)NULL},
    {"pll6", hosc_parents, 1,          0,    PLL6_CFG, PLL6_CFG,  28,       &sunxi_clk_factor_pll6,	 &get_factors_pll6,   &calc_rate_pll6  ,(struct clk_ops*)NULL},
    {"pll7", hosc_parents, 1,          0,    PLL7_CFG, PLL7_CFG,  28,       &sunxi_clk_factor_media, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll8", hosc_parents, 1,          0,    PLL8_CFG, PLL8_CFG,  28,       &sunxi_clk_factor_media, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll9", hosc_parents, 1,          0,    PLL9_CFG, PLL9_CFG,  28,       &sunxi_clk_factor_media, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll10",hosc_parents, 1,          0,    PLL10_CFG,PLL10_CFG, 28,       &sunxi_clk_factor_media, &get_factors_media,  &calc_rate_media ,(struct clk_ops*)NULL},
    {"pll_mipi",mipi_parents,2,        0,    MIPI_PLL,MIPI_PLL,   28,       &sunxi_clk_factor_mipi,  &get_factors_mipi,   &calc_rate_mipi  ,&mipi_ops},
};


struct periph_init_data {
    const char          *name;
    unsigned long				flags;    
    const char          **parent_names;
    int                 num_parents;
    struct sunxi_clk_periph *periph;
};

static const char *cpu_parents[] = {"losc", "hosc", "pll1", "pll1"};
static const char *axi_parents[] = {"cpu"};
static const char *pll6ahb1_parents[] = {"pll6"};
static const char *ahb1_parents[] = {"losc", "hosc", "axi", "pll6ahb1"};
static const char *apb1_parents[] = {"ahb1"};
static const char *apb2_parents[] = {"losc", "hosc", "pll6", "pll6"};
static const char *perph1_parents[] = {"hosc", "pll6"};
static const char *audio_parents[] = {"pll2x8", "pll2x4", "pll2x2", "pll2"};
static const char *display_parents[] = {"pll3", "pll7", "pll6x2", "pll8", "pll9", "pll10"};
static const char *mdfs_parents[] = {"pll5", "pll6"};
static const char *lcd_parents[] = {"pll3", "pll7", "pll3x2", "pll7x2", "pll_mipi"};
static const char *csi_s_parents[] = {"pll3", "pll7", "pll9", "pll10", "pll_mipi", "pll4"};
static const char *csi_m_parents[] = {"pll3", "pll7", "", "", "", "hosc"};
static const char *mbus_parents[] = {"hosc", "pll6x2", "pll5"};
static const char *mipidsi_parents[] = {"pll3", "", "pll3x2"};
static const char *mipidphy_parents[] = {"pll3", "", "pll6"};
static const char *gpu_parents[] = {"pll8", "", "pll3", "pll7", "pll9", "pll10"};
static const char *pll2_parents[] = {"pll2"};
static const char *pll4_parents[] = {"pll4"};
static const char *ahb1mod_parents[] = {"ahb1"};
static const char *apb1mod_parents[] = {"apb1"};
static const char *apb2mod_parents[] = {"apb2"};
static const char *ps_parents[] = {"lcd1ch1"};
static const char *cpurdev_parents[]  = {"losc", "hosc","",""};

/*
SUNXI_CLK_PERIPH(name,    mux_reg,    mux_shift, mux_width, div_reg,    div_mshift, div_mwidth, div_nshift, div_nwidth, gate_flags, enable_reg, reset_reg, bus_gate_reg, drm_gate_reg, enable_shift, reset_shift, bus_gate_shift, dram_gate_shift, lock,com_gate,com_gate_off)
*/
SUNXI_CLK_PERIPH(cpu,     CPU_CFG,    16,        2,         0,          0,          0,          0,          0,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(axi,     0,           0,        0,         CPU_CFG,    0,          2,          0,          0,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(pll6ahb1, AHB1_CFG,   0,         0,        AHB1_CFG,   6,          2,          0,          0,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(ahb1,    AHB1_CFG,   12,        2,         AHB1_CFG,   0,          0,          4,          2,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(apb1,    0,           0,        0,         AHB1_CFG,   0,          0,          8,          2,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(apb2,    APB2_CFG,   24,        2,         APB2_CFG,   0,          5,          16,         2,          0,          0,          0,         0,            0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(nand0,   NAND0_CFG,  24,        2,         NAND0_CFG,  0,          4,          16,         2,          0,          NAND0_CFG,  AHB1_RST0, AHB1_GATE0,   0,           31,           13,          13,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(nand1,   NAND1_CFG,  24,        2,         NAND1_CFG,  0,          4,          16,         2,          0,          NAND1_CFG,  AHB1_RST0, AHB1_GATE0,   0,           31,           12,          12,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(sdmmc0,  SD0_CFG,    24,        2,         SD0_CFG,    0,          4,          16,         2,          0,          SD0_CFG,    AHB1_RST0, AHB1_GATE0,   0,           31,            8,           8,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(sdmmc1,  SD1_CFG,    24,        2,         SD1_CFG,    0,          4,          16,         2,          0,          SD1_CFG,    AHB1_RST0, AHB1_GATE0,   0,           31,            9,           9,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(sdmmc2,  SD2_CFG,    24,        2,         SD2_CFG,    0,          4,          16,         2,          0,          SD2_CFG,    AHB1_RST0, AHB1_GATE0,   0,           31,           10,          10,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(sdmmc3,  SD3_CFG,    24,        2,         SD3_CFG,    0,          4,          16,         2,          0,          SD3_CFG,    AHB1_RST0, AHB1_GATE0,   0,           31,           11,          11,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(ts,      TS_CFG,     24,        2,         TS_CFG,     0,          4,          16,         2,          0,          TS_CFG,     AHB1_RST0, AHB1_GATE0,   0,           31,           18,          18,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(ss,      SS_CFG,     24,        2,         SS_CFG,     0,          4,          16,         2,          0,          SS_CFG,     AHB1_RST0, AHB1_GATE0,   0,           31,            5,           5,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(spi0,    SPI0_CFG,   24,        2,         SPI0_CFG,   0,          4,          16,         2,          0,          SPI0_CFG,   AHB1_RST0, AHB1_GATE0,   0,           31,           20,          20,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(spi1,    SPI1_CFG,   24,        2,         SPI1_CFG,   0,          4,          16,         2,          0,          SPI1_CFG,   AHB1_RST0, AHB1_GATE0,   0,           31,           21,          21,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(spi2,    SPI2_CFG,   24,        2,         SPI2_CFG,   0,          4,          16,         2,          0,          SPI2_CFG,   AHB1_RST0, AHB1_GATE0,   0,           31,           22,          22,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(spi3,    SPI3_CFG,   24,        2,         SPI3_CFG,   0,          4,          16,         2,          0,          SPI3_CFG,   AHB1_RST0, AHB1_GATE0,   0,           31,           23,          23,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(i2s0,    I2S0_CFG,   16,        2,         0,          0,          0,          0,          0,          0,          I2S0_CFG,   APB1_RST,  APB1_GATE,    0,           31,           12,          12,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(i2s1,    I2S1_CFG,   16,        2,         0,          0,          0,          0,          0,          0,          I2S1_CFG,   APB1_RST,  APB1_GATE,    0,           31,           13,          13,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(spdif,   SPDIF_CFG,  16,        2,         0,          0,          0,          0,          0,          0,          SPDIF_CFG,  APB1_RST,  APB1_GATE,    0,           31,            1,           1,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbohci0,0,           0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    AHB1_RST0, AHB1_GATE0,   0,           16,           29,          29,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbohci1,0,           0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    AHB1_RST0, AHB1_GATE0,   0,           17,           30,          30,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbohci2,0,           0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    AHB1_RST0, AHB1_GATE0,   0,           18,           31,          31,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbehci0,0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST0, AHB1_GATE0,   0,            0,           26,          26,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbehci1,0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST0, AHB1_GATE0,   0,            0,           27,          27,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbotg,  0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST0, AHB1_GATE0,   0,            0,           24,          24,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbphy0, 0,           0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    USB_CFG,   0,            0,            8,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbphy1, 0,           0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    USB_CFG,   0,            0,            9,            1,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(usbphy2, 0,           0,        0,         0,          0,          0,          0,          0,          0,          USB_CFG,    USB_CFG,   0,            0,           10,            2,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(mdfs,    MDFS_CFG,   24,        2,         MDFS_CFG,   0,          4,          16,         2,          0,          MDFS_CFG,   0,         0,            0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(debe0,   BE0_CFG,    24,        3,         BE0_CFG,    0,          4,          0,          0,          0,          BE0_CFG,    AHB1_RST1, AHB1_GATE1,   DRAM_GATE,   31,           12,          12,             26,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(debe1,   BE1_CFG,    24,        3,         BE1_CFG,    0,          4,          0,          0,          0,          BE1_CFG,    AHB1_RST1, AHB1_GATE1,   DRAM_GATE,   31,           13,          13,             27,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(defe0,   FE0_CFG,    24,        3,         FE0_CFG,    0,          4,          0,          0,          0,          FE0_CFG,    AHB1_RST1, AHB1_GATE1,   DRAM_GATE,   31,           14,          14,             24,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(defe1,   FE1_CFG,    24,        3,         FE1_CFG,    0,          4,          0,          0,          0,          FE1_CFG,    AHB1_RST1, AHB1_GATE1,   DRAM_GATE,   31,           15,          15,             25,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(mp,      MP_CFG,     24,        2,         MP_CFG,     0,          4,          0,          0,          0,          MP_CFG,     AHB1_RST1, AHB1_GATE1,   DRAM_GATE,   31,           18,          18,             28,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(lcd0ch0, LCD0_CH0,   24,        3,         0,          0,          0,          0,          0,          0,          LCD0_CH0,   AHB1_RST1, AHB1_GATE1,   0,           31,            4,           4,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(lcd0ch1, LCD0_CH1,   24,        3,         LCD0_CH1,   0,          4,          0,          0,          0,          LCD0_CH1,   AHB1_RST1, AHB1_GATE1,   0,           31,            4,           4,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(lcd1ch0, LCD1_CH0,   24,        3,         0,          0,          0,          0,          0,          0,          LCD1_CH0,   AHB1_RST1, AHB1_GATE1,   0,           31,            5,           5,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(lcd1ch1, LCD1_CH1,   24,        3,         LCD1_CH1,   0,          4,          0,          0,          0,          LCD1_CH1,   AHB1_RST1, AHB1_GATE1,   0,           31,            5,           5,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(csi0_s,  CSI0_CFG,   24,        3,         CSI0_CFG,   16,         4,          0,          0,          0,          CSI0_CFG,   AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   31,            8,           8,              1,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(csi0_m,  CSI0_CFG,    8,        3,         CSI0_CFG,   0,          4,          0,          0,          0,          CSI0_CFG,   AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   15,            8,           8,              1,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(csi1_m,  CSI1_CFG,    8,        3,         CSI1_CFG,   0,          4,          0,          0,          0,          CSI1_CFG,   AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   15,            8,           8,              1,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(ve,      0,           0,        0,         VE_CFG,     16,         3,          0,          0,          0,          VE_CFG,     AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(adda,    0,           0,        0,         0,          0,          0,          0,          0,          0,          ADDA_CFG,   APB1_RST,   APB1_GATE,   0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(avs,     0,           0,        0,         0,          0,          0,          0,          0,          0,          AVS_CFG,    0,          0,           0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(dmic,    0,           0,        0,         0,          0,          0,          0,          0,          0,          DMIC_CFG,   0,          0,           0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(hdmi,    HDMI_CFG,   24,        2,         HDMI_CFG,   0,          4,          0,          0,          0,          HDMI_CFG,   AHB1_RST1,  AHB1_GATE1,  0,           31,           11,          11,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(hdmi_ddc,HDMI_CFG,    0,        0,         0,          0,          0,          0,          0,          0,          HDMI_CFG,   0,          0,           0,           30,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(ps,      0,           0,        0,         0,          0,          0,          0,          0,          0,          PS_CFG,     0,          0,           0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(mtcacc,  MTCACC_CFG, 24,        2,         MTCACC_CFG, 0,          4,          16,         2,          0,          MTCACC_CFG, AHB1_RST1, AHB1_GATE1,   0,           31,           27,          27,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(mbus0,   MBUS0_CFG,  24,        2,         MBUS0_CFG,  0,          3,          0,          0,          0,          MBUS0_CFG,  0,          0,           0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(mbus1,   MBUS1_CFG,  24,        2,         MBUS1_CFG,  0,          3,          0,          0,          0,          MBUS1_CFG,  0,          0,           0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(mipidsi, MIPI_DSI,   24,        2,         MIPI_DSI,   16,         4,          0,          0,          0,          MIPI_DSI,   AHB1_RST0,  AHB1_GATE0,  0,           31,            1,           1,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(mipidphy,MIPI_DSI,    8,        2,         MIPI_DSI,   0,          4,          0,          0,          0,          MIPI_DSI,   AHB1_RST0,  AHB1_GATE0,  0,           15,            1,           1,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(mipicsi, MIPI_CSI,    8,        2,         MIPI_CSI,   0,          4,          0,          0,          0,          MIPI_CSI,   AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   15,            8,           8,              1,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(drc0,    DRC0_CFG,   24,        3,         DRC0_CFG,   0,          4,          0,          0,          0,          DRC0_CFG,   AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   31,           25,          25,             16,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(drc1,    DRC1_CFG,   24,        3,         DRC1_CFG,   0,          4,          0,          0,          0,          DRC1_CFG,   AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   31,           26,          26,             17,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(deu0,    DEU0_CFG,   24,        3,         DEU0_CFG,   0,          4,          0,          0,          0,          DEU0_CFG,   AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   31,           23,          23,             18,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(deu1,    DEU1_CFG,   24,        3,         DEU1_CFG,   0,          4,          0,          0,          0,          DEU1_CFG,   AHB1_RST1,  AHB1_GATE1,  DRAM_GATE,   31,           24,          24,             19,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(gpucore, GPU_CORE,   24,        3,         GPU_CORE,   0,          3,          0,          0,          0,          GPU_CORE,    AHB1_RST1,  AHB1_GATE1, 0,           31,           20,          20,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(gpumem,  GPU_MEM,    24,        3,         GPU_MEM,    0,          3,          0,          0,          0,          GPU_MEM,     0,          0,          0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(gpuhyd,  GPU_HYD,    24,        3,         GPU_HYD,    0,          3,          0,          0,          0,          GPU_HYD,     0,          0,          0,           31,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(dma,     0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST0,  AHB1_GATE0,  0,            0,            6,           6,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(gmac,    0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST0,  AHB1_GATE0,  0,            0,           17,          17,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(hstmr,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST0,  AHB1_GATE0,  0,            0,           19,          19,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(msgbox,  0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST1,  AHB1_GATE1,  0,            0,           21,          21,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(spinlock,0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST1,  AHB1_GATE1,  0,            0,           22,          22,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(lvds,    0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          AHB1_RST2,  0,           0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(pio,     0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          0,          APB1_GATE,   0,            0,            0,           5,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(twi0,    0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,            0,           0,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(twi1,    0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,            1,           1,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(twi2,    0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,            2,           2,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(twi3,    0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,            3,           3,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart0,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           16,          16,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart1,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           17,          17,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart2,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           18,          18,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart3,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           19,          19,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart4,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           20,          20,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(uart5,   0,           0,        0,         0,          0,          0,          0,          0,          0,          0,          APB2_RST,   APB2_GATE,   0,            0,           21,          21,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(cpur1w,   CPUS_ONEWRITE,24,     2,         CPUS_ONEWRITE,0,        5,          16,         2,          0,          CPUS_ONEWRITE,CPUS_APB0_GATE,CPUS_APB0_RST,0,     31,            5,           5,              0,               &clk_lock,NULL,             0);
SUNXI_CLK_PERIPH(cpurcir,  CPUS_CIR,  24,        2,         CPUS_CIR,   0,          4,          16,         2,          0,          CPUS_CIR,     CPUS_APB0_GATE,CPUS_APB0_RST,0,     31,            1,           1,              0,               &clk_lock,NULL,             0);



struct periph_init_data sunxi_periphs_init[] = {
    {"cpu",      0,       				cpu_parents,      ARRAY_SIZE(cpu_parents),      &sunxi_clk_periph_cpu},
    {"axi",      0,       				axi_parents,      ARRAY_SIZE(axi_parents),      &sunxi_clk_periph_axi},
    {"pll6ahb1",  0,       				pll6ahb1_parents,  ARRAY_SIZE(pll6ahb1_parents),  &sunxi_clk_periph_pll6ahb1},
    {"ahb1",     0,       				ahb1_parents,     ARRAY_SIZE(ahb1_parents),     &sunxi_clk_periph_ahb1},
    {"apb1",     0,       				apb1_parents,     ARRAY_SIZE(apb1_parents),     &sunxi_clk_periph_apb1},
    {"apb2",     0,       				apb2_parents,     ARRAY_SIZE(apb2_parents),     &sunxi_clk_periph_apb2},
    {"nand0",    0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_nand0},
    {"nand1",    0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_nand1},
    {"sdmmc0",   0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_sdmmc0},
    {"sdmmc1",   0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_sdmmc1},
    {"sdmmc2",   0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_sdmmc2},
    {"sdmmc3",   0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_sdmmc3},
    {"ts",       0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_ts},
    {"ss",       0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_ss},
    {"spi0",     0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_spi0},
    {"spi1",     0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_spi1},
    {"spi2",     0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_spi2},
    {"spi3",     0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_spi3},
    {"i2s0",     0,       				audio_parents,    ARRAY_SIZE(audio_parents),    &sunxi_clk_periph_i2s0},
    {"i2s1",     0,       				audio_parents,    ARRAY_SIZE(audio_parents),    &sunxi_clk_periph_i2s1},
    {"spdif",    0,       				audio_parents,    ARRAY_SIZE(audio_parents),    &sunxi_clk_periph_spdif},
    {"usbohci0", 0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbohci0},
    {"usbohci1", 0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbohci1},
    {"usbohci2", 0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbohci2},
    {"usbehci0", 0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbehci0},
    {"usbehci1", 0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbehci1},
    {"usbotg",   0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbotg},
    {"usbphy0",  0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbphy0},
    {"usbphy1",  0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbphy1},
    {"usbphy2",  0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_usbphy2},
    {"mdfs",     0,       				mdfs_parents,   	 ARRAY_SIZE(mdfs_parents),  	 &sunxi_clk_periph_mdfs},
    {"debe0",    0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_debe0},
    {"debe1",    0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_debe1},
    {"defe0",    0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_defe0},
    {"defe1",    0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_defe1},
    {"mp",       0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_mp},
    {"lcd0ch0",  0,       				lcd_parents,      ARRAY_SIZE(lcd_parents),      &sunxi_clk_periph_lcd0ch0},
    {"lcd0ch1",  0,       				lcd_parents,      ARRAY_SIZE(lcd_parents),      &sunxi_clk_periph_lcd0ch1},
    {"lcd1ch0",  0,       				lcd_parents,      ARRAY_SIZE(lcd_parents),      &sunxi_clk_periph_lcd1ch0},
    {"lcd1ch1",  0,       				lcd_parents,      ARRAY_SIZE(lcd_parents),      &sunxi_clk_periph_lcd1ch1},
    {"csi0_s",   0,       				csi_s_parents,    ARRAY_SIZE(csi_s_parents),    &sunxi_clk_periph_csi0_s},
    {"csi0_m",   0,       				csi_m_parents,    ARRAY_SIZE(csi_m_parents),    &sunxi_clk_periph_csi0_m},
    {"csi1_m",   0,       				csi_m_parents,    ARRAY_SIZE(csi_m_parents),    &sunxi_clk_periph_csi1_m},
    {"ve",       0,       				pll4_parents,     ARRAY_SIZE(pll4_parents),     &sunxi_clk_periph_ve},
    {"adda",     0,       				pll2_parents,     ARRAY_SIZE(pll2_parents),     &sunxi_clk_periph_adda},
    {"avs",      0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_avs},
    {"dmic",     0,       				pll2_parents,     ARRAY_SIZE(pll2_parents),     &sunxi_clk_periph_dmic},
    {"hdmi",     0,       				lcd_parents,      ARRAY_SIZE(lcd_parents),      &sunxi_clk_periph_hdmi},
    {"hdmi_ddc", 0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_hdmi_ddc},
    {"ps",       0,       				ps_parents,       ARRAY_SIZE(ps_parents),      &sunxi_clk_periph_ps},
    {"mtcacc",   0,       				perph1_parents,   ARRAY_SIZE(perph1_parents),   &sunxi_clk_periph_mtcacc},
    {"mbus0",    0,       				mbus_parents,     ARRAY_SIZE(mbus_parents),     &sunxi_clk_periph_mbus0},
    {"mbus1",    0,       				mbus_parents,     ARRAY_SIZE(mbus_parents),     &sunxi_clk_periph_mbus1},
    {"mipidsi",  0,       				mipidsi_parents,  ARRAY_SIZE(mipidsi_parents),  &sunxi_clk_periph_mipidsi},
    {"mipidphy", 0,       				mipidphy_parents, ARRAY_SIZE(mipidphy_parents), &sunxi_clk_periph_mipidphy},
    {"mipicsi",  0,       				lcd_parents,      ARRAY_SIZE(lcd_parents),      &sunxi_clk_periph_mipicsi},
    {"drc0",     0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_drc0},
    {"drc1",     0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_drc1},
    {"deu0",     0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_deu0},
    {"deu1",     0,       				display_parents,  ARRAY_SIZE(display_parents),  &sunxi_clk_periph_deu1},
    {"gpucore",  CLK_IGNORE_AUTORESET,	gpu_parents,      ARRAY_SIZE(gpu_parents),      &sunxi_clk_periph_gpucore},
    {"gpumem",   CLK_IGNORE_AUTORESET,	gpu_parents,      ARRAY_SIZE(gpu_parents),      &sunxi_clk_periph_gpumem},
    {"gpuhyd",   CLK_IGNORE_AUTORESET,	gpu_parents,      ARRAY_SIZE(gpu_parents),      &sunxi_clk_periph_gpuhyd},
    {"dma",      0,       				ahb1mod_parents,  ARRAY_SIZE(ahb1mod_parents),  &sunxi_clk_periph_dma},
    {"gmac",     0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_gmac},
    {"hstmr",    0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_hstmr},
    {"msgbox",   0,       				ahb1mod_parents,  ARRAY_SIZE(ahb1mod_parents),  &sunxi_clk_periph_msgbox},
    {"spinlock", 0,       				ahb1mod_parents,  ARRAY_SIZE(ahb1mod_parents),  &sunxi_clk_periph_spinlock},
    {"lvds",     0,       				hosc_parents,     ARRAY_SIZE(hosc_parents),     &sunxi_clk_periph_lvds},
    {"pio",      0,       				apb1mod_parents,  ARRAY_SIZE(apb1mod_parents),  &sunxi_clk_periph_pio},
    {"twi0",     0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_twi0},
    {"twi1",     0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_twi1},
    {"twi2",     0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_twi2},
    {"twi3",     0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_twi3},
    {"uart0", 	 0,						apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart0},
    {"uart1",    0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart1},
    {"uart2",    0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart2},
    {"uart3",    0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart3},
    {"uart4",    0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart4},
    {"uart5",    0,       				apb2mod_parents,  ARRAY_SIZE(apb2mod_parents),  &sunxi_clk_periph_uart5},
};
struct periph_init_data sunxi_periphs_cpus_init[] = {
    {"cpur1w",CLK_GET_RATE_NOCACHE,     cpurdev_parents,ARRAY_SIZE(cpurdev_parents),    &sunxi_clk_periph_cpur1w},   
    {"cpurcir",CLK_GET_RATE_NOCACHE,    cpurdev_parents,ARRAY_SIZE(cpurdev_parents),    &sunxi_clk_periph_cpurcir},        
};

void __init sunxi_init_clocks(void)
{
    int     i;
	struct clk *clk;
    struct factor_init_data *factor;
    struct periph_init_data *periph;
#ifdef CONFIG_SUNXI_CLK_DUMMY_DEBUG
		sunxi_clk_base = &dummy_reg[0]; 
 		sunxi_clk_cpus_base = &dummy_cpus_reg[0];        
		dummy_reg_init();
#else
    /* get clk register base address */
    sunxi_clk_base = IO_ADDRESS(0x01c20000);
    sunxi_clk_cpus_base = IO_ADDRESS(0x01f01400);        
#endif

    /* register oscs */
    clk = clk_register_fixed_rate(NULL, "losc", NULL, CLK_IS_ROOT, 32768);
    clk_register_clkdev(clk, "losc", NULL);

    clk = clk_register_fixed_rate(NULL, "hosc", NULL, CLK_IS_ROOT, 24000000);
    clk_register_clkdev(clk, "hosc", NULL);

    sunxi_clk_get_factors_ops(&mipi_ops);
    mipi_ops.get_parent = get_parent_mipi;
    mipi_ops.set_parent = set_parent_mipi;
    /* register normal factors, based on sunxi factor framework */
    for(i=0; i<ARRAY_SIZE(sunxi_factos); i++) {
        factor = &sunxi_factos[i];
        clk = sunxi_clk_register_factors(NULL,  sunxi_clk_base, &clk_lock,factor);
        clk_register_clkdev(clk, factor->name, NULL);
    }

    /* register fixed factors, based on clk-fixed-factor framework, such as pllx2 for ex. */
    clk = clk_register_fixed_factor(NULL, "pll2x8", "pll2", 0, 8, 1);
    clk_register_clkdev(clk, "pll2x8", NULL);

    clk = clk_register_fixed_factor(NULL, "pll2x4", "pll2", 0, 8, 2);
    clk_register_clkdev(clk, "pll2x4", NULL);

    clk = clk_register_fixed_factor(NULL, "pll2x2", "pll2", 0, 8, 4);
    clk_register_clkdev(clk, "pll2x2", NULL);

    clk = clk_register_fixed_factor(NULL, "pll3x2", "pll3", 0, 2, 1);
    clk_register_clkdev(clk, "pll3x2", NULL);

    clk = clk_register_fixed_factor(NULL, "pll6x2", "pll6", 0, 2, 1);
    clk_register_clkdev(clk, "pll6x2", NULL);

    
    /* register periph clock */
    for(i=0; i<ARRAY_SIZE(sunxi_periphs_init); i++) {
        periph = &sunxi_periphs_init[i];
        clk = sunxi_clk_register_periph(periph->name, periph->parent_names,
                        periph->num_parents,periph->flags, sunxi_clk_base, periph->periph);
        clk_register_clkdev(clk, periph->name, NULL);
    }

    for(i=0; i<ARRAY_SIZE(sunxi_periphs_cpus_init); i++) {
        periph = &sunxi_periphs_cpus_init[i];
        clk = sunxi_clk_register_periph(periph->name, periph->parent_names,
                        periph->num_parents,periph->flags, sunxi_clk_cpus_base , periph->periph);
        clk_register_clkdev(clk, periph->name, NULL);
        }    
}
