/*
 * A V4L2 driver for t4k05 cameras.
 *
 */
#include <linux/init.h>
#include <linux/module.h>
#include <linux/slab.h>
#include <linux/i2c.h>
#include <linux/delay.h>
#include <linux/videodev2.h>
#include <linux/clk.h>
#include <media/v4l2-device.h>
#include <media/v4l2-chip-ident.h>
#include <media/v4l2-mediabus.h>
#include <linux/io.h>


#include "camera.h"

MODULE_AUTHOR("raymonxiu");
MODULE_DESCRIPTION("A low-level driver for t4k05 sensors");
MODULE_LICENSE("GPL");

//for internel driver debug
#define DEV_DBG_EN      1 
#if(DEV_DBG_EN == 1)    
#define vfe_dev_dbg(x,arg...) printk("[t4k05]"x,##arg)
#else
#define vfe_dev_dbg(x,arg...) 
#endif
#define vfe_dev_err(x,arg...) printk("[t4k05]"x,##arg)
#define vfe_dev_print(x,arg...) printk("[t4k05]"x,##arg)

#define LOG_ERR_RET(x)  { \
                          int ret;  \
                          ret = x; \
                          if(ret < 0) {\
                            vfe_dev_err("error at %s\n",__func__);  \
                            return ret; \
                          } \
                        }

//define module timing
#define MCLK              (24*1000*1000)
#define VREF_POL          V4L2_MBUS_VSYNC_ACTIVE_HIGH
#define HREF_POL          V4L2_MBUS_HSYNC_ACTIVE_HIGH
#define CLK_POL           V4L2_MBUS_PCLK_SAMPLE_FALLING
#define V4L2_IDENT_SENSOR 0x4005

//define the voltage level of control signal
#define CSI_STBY_ON     0
#define CSI_STBY_OFF    1
#define CSI_RST_ON      0
#define CSI_RST_OFF     1
#define CSI_PWR_ON      1
#define CSI_PWR_OFF     0
#define CSI_AF_PWR_ON   1
#define CSI_AF_PWR_OFF  0
#define regval_list reg_list_a16_d8


#define REG_TERM 0xfffe
#define VAL_TERM 0xfe
#define REG_DLY  0xffff

/*
 * Our nominal (default) frame rate.
 */

#define SENSOR_FRAME_RATE 30


/*
 * The t4k05 sits on i2c with ID 0x6c
 */
#define I2C_ADDR (0x6c)
#define  SENSOR_NAME "t4k05"
static struct v4l2_subdev *glb_sd;

/*
 * Information we maintain about a known sensor.
 */
struct sensor_format_struct;  /* coming later */

struct cfg_array { /* coming later */
	struct regval_list * regs;
	int size;
};

static inline struct sensor_info *to_state(struct v4l2_subdev *sd)
{
  return container_of(sd, struct sensor_info, sd);
}


/*
 * The default register settings
 *
 */


static struct regval_list sensor_default_regs[] = {
//new initial setting

0x0000,0x14,//[RO] RO_MODEL_ID[15:8] ;
0x0001,0x61,//[RO] RO_MODEL_ID[7:0] ;
0x0005,0xFF,//[RO] R_FRAME_COUNT[7:0] ;
0x0100,0x00,//-/-/-/-/-/-/-/MODE_SELECT ;
0x0101,0x00,//-/-/-/-/-/-/IMAGE_ORIENT[1:0] ;
0x0103,0x00,//-/-/-/-/-/-/-/SOFTWARE_RESET ;
0x0104,0x00,//-/-/-/-/-/-/-/GROUP_PARA_HOLD ;
0x0105,0x00,//-/-/-/-/-/-/-/MSK_CORRUPT_FR ;
0x0108,0x00,//-/-/-/-/-/-/-/OUTPUT_FRAME_MASK ;
0x0112,0x0A,//CSI_DATA_FORMAT[15:8] ;
0x0113,0x0A,//CSI_DATA_FORMAT[7:0] ;
0x0114,0x03,//-/-/-/-/-/-/CSI_LANE_MODE[1:0] ;
0x0116,0x00,//-/-/-/-/-/-/VIRTUAL_CN_ID[1:0] ;
0x0138,0x01,//-/-/-/-/-/-/-/TEMPSEMSORCONTROL ;
0x013A,0x32,//[RO] TEMP_SENSOR_OUT[7:0] ;
0x0140,0x00,//[RO] CUR_CTX_FR_CNT[7:0] ;
0x0141,0x00,//-/-/-/-/-/CTX_SW_CTL[2:0] ;
0x0200,0x07,//[RO] -/RO_FINE_INTEGR_TIM[14:8] ;
0x0201,0x6B,//[RO] RO_FINE_INTEGR_TIM[7:0] ;
0x0202,0x07,//COAR_INTEGR_TIM[15:8] ;
0x0203,0x5C,//COAR_INTEGR_TIM[7:0] ;
0x0204,0x07,//[RO] -/RO_FINE_INTEGR_TIM2[14:8] ;
0x0205,0x6B,//[RO] RO_FINE_INTEGR_TIM2[7:0] ;
0x0206,0x02,//COAR_INTEGR_TIM2[15:8] ;
0x0207,0x24,//COAR_INTEGR_TIM2[7:0] ;
0x0208,0x00,//ANA_GA_CODE_GL[15:8] ;0x0000
0x0209,0x86,//ANA_GA_CODE_GL[7:0] ;
0x020E,0x01,//-/-/-/-/-/-/AWB_GAIN_GREEN[9:8] ;
0x020F,0x00,//AWB_GAIN_GREEN[7:0] ;
0x0210,0x01,//-/-/-/-/-/-/AWB_GAIN_RED[9:8] ;
0x0211,0x68,//AWB_GAIN_RED[7:0] ;
0x0212,0x01,//-/-/-/-/-/-/AWB_GAIN_BLUE[9:8] ;
0x0213,0x60,//AWB_GAIN_BLUE[7:0] ;
0x0214,0x00,//-/-/-/-/-/-/ALC_DIG_GAIN[9:8] ;
0x0215,0x00,//ALC_DIG_GAIN[7:0] ;
0x0301,0x08,//-/-/-/-/VT_PIX_CLK_DIV[3:0] ;
0x0303,0x00,//-/-/-/-/VT_SYS_CLK_DIV[3:0] ;
0x0305,0x00,//-/-/-/-/-/PRE_PLL_CLK_DIV[2:0] ;
0x0306,0x00,//-/-/-/-/-/-/-/PLL_MULTIPLIER[8] ;
0x0307,0x21,//PLL_MULTIPLIER[7:0] ;
0x0309,0x08,//-/-/-/-/OP_PIX_CLK_DIV[3:0] ;
0x030B,0x00,//-/-/-/-/OP_SYS_CLK_DIV[3:0] ;
0x0340,0x07,//FR_LENGTH_LINES[15:8] ;
0x0341,0x5C,//FR_LENGTH_LINES[7:0] ;
0x0342,0x0E,//LINE_LENGTH_PCK[15:8] ;
0x0343,0x00,//LINE_LENGTH_PCK[7:0] ;
0x0344,0x00,//X_ADDR_START[15:8] ;
0x0345,0x00,//X_ADDR_START[7:0] ;
0x0346,0x01,//Y_ADDR_START[15:8] ;
0x0347,0x3C,//Y_ADDR_START[7:0] ;
0x0348,0x0C,//X_ADDR_END[15:8] ;
0x0349,0xCF,//X_ADDR_END[7:0] ;
0x034A,0x08,//Y_ADDR_END[15:8] ;
0x034B,0x73,//Y_ADDR_END[7:0] ;
0x034C,0x07,//X_OUTPUT_SIZE[15:8] ;
0x034D,0x80,//X_OUTPUT_SIZE[7:0] ;
0x034E,0x04,//Y_OUTPUT_SIZE[15:8] ;
0x034F,0x38,//Y_OUTPUT_SIZE[7:0] ;
0x0350,0x00,//CONT_FRCNT[7:0] ;
0x0381,0x00,//-/-/-/-/-/-/H_MONI[1:0] ;
0x0382,0x00,//-/-/-/-/-/-/V_MONI[1:0] ;
0x0383,0x00,//-/-/-/-/-/-/BINNING_WEIGHTING[1:0] ;
0x0401,0x02,//-/-/-/-/-/-/SCALING_MODE[1:0] ;
0x0403,0x00,//-/-/-/-/-/-/-/SPATIAL_SAMPLING ;
0x0405,0x1B,//SCALE_M[7:0] ;
0x0406,0x00,//[RO] RO_SCALE_N[15:8] ;
0x0407,0x10,//[RO] RO_SCALE_N[7:0] ;
0x0408,0x00,//-/-/-/DCROP_XOFS[12:8] ;
0x0409,0x28,//DCROP_XOFS[7:0] ;
0x040A,0x00,//-/-/-/-/DCROP_YOFS[11:8] ;
0x040B,0x18,//DCROP_YOFS[7:0] ;
0x040C,0x0C,//-/-/-/DCROP_WIDTH[12:8] ;
0x040D,0xA8,//DCROP_WIDTH[7:0] ;
0x040E,0x07,//-/-/-/-/DCROP_HIGT[11:8] ;
0x040F,0x20,//DCROP_HIGT[7:0] ;
0x0601,0x00,//-/-/-/-/TEST_PATT_MODE[3:0] ;
0x0602,0x02,//-/-/-/-/-/-/TEST_DATA_RED[9:8] ;
0x0603,0xC0,//TEST_DATA_RED[7:0] ;
0x0604,0x02,//-/-/-/-/-/-/TEST_DATA_GREENR[9:8] ;
0x0605,0xC0,//TEST_DATA_GREENR[7:0] ;
0x0606,0x02,//-/-/-/-/-/-/TEST_DATA_BLUE[9:8] ;
0x0607,0xC0,//TEST_DATA_BLUE[7:0] ;
0x0608,0x02,//-/-/-/-/-/-/TEST_DATA_GREENB[9:8] ;
0x0609,0xC0,//TEST_DATA_GREENB[7:0] ;
0x060A,0x00,//HO_CURS_WIDTH[15:8] ;
0x060B,0x00,//HO_CURS_WIDTH[7:0] ;
0x060C,0x00,//HO_CURS_POSITION[15:8] ;
0x060D,0x00,//HO_CURS_POSITION[7:0] ;
0x060E,0x00,//VE_CURS_WIDTH[15:8] ;
0x060F,0x00,//VE_CURS_WIDTH[7:0] ;
0x0610,0x00,//VE_CURS_POSITION[15:8] ;
0x0611,0x00,//VE_CURS_POSITION[7:0] ;
0x0800,0x80,//TCLK_POST[7:3]/-/-/- ;
0x0801,0x28,//THS_PREPARE[7:3]/-/-/- ;
0x0802,0x68,//THS_ZERO[7:3]/-/-/- ;
0x0803,0x48,//THS_TRAIL[7:3]/-/-/- ;
0x0804,0x40,//TCLK_TRAIL[7:3]/-/-/- ;
0x0805,0x28,//TCLK_PREPARE[7:3]/-/-/- ;
0x0806,0xF8,//TCLK_ZERO[7:3]/-/-/- ;
0x0807,0x38,//TLPX[7:3]/-/-/- ;
0x0808,0x01,//-/-/-/-/-/-/DPHY_CTRL[1:0] ;
0x0820,0x06,//MSB_LBRATE[15:8] ;
0x0821,0x30,//MSB_LBRATE[7:0] ;
0x0B05,0x00,//-/-/-/-/-/-/-/MAP_DEF_EN ;
0x0B06,0x01,//-/-/-/-/-/-/-/CPL_MAP_DEF_EN ;
0x2101,0x00,//-/-/-/-/-/-/IMAGE_ORIENT_1B[1:0] ;
0x2112,0x0A,//CSI_DATA_FORMAT_1B[15:8] ;
0x2113,0x0A,//CSI_DATA_FORMAT_1B[7:0] ;
0x2114,0x03,//-/-/-/-/-/-/CSI_LANE_MODE_1B[1:0] ;
0x2116,0x00,//-/-/-/-/-/-/VIRTUAL_CN_ID_1B[1:0] ;
0x2200,0x07,//[RO] -/RO_FINE_INTEGR_TIM_1B[14:8] ;
0x2201,0x6B,//[RO] RO_FINE_INTEGR_TIM_1B[7:0] ;
0x2202,0x00,//COAR_INTEGR_TIM_1B[15:8] ;
0x2203,0x10,//COAR_INTEGR_TIM_1B[7:0] ;
0x2204,0x07,//[RO] -/RO_FINE_INTEGR_TIM2_1B[14:8] ;
0x2205,0x6B,//[RO] RO_FINE_INTEGR_TIM2_1B[7:0] ;
0x2206,0x00,//COAR_INTEGR_TIM2_1B[15:8] ;
0x2207,0x10,//COAR_INTEGR_TIM2_1B[7:0] ;
0x2208,0x00,//ANA_GA_CODE_GL_1B[15:8] ;
0x2209,0x45,//ANA_GA_CODE_GL_1B[7:0] ;
0x220E,0x01,//-/-/-/-/-/-/AWB_GAIN_GREEN_1B[9:8] ;
0x220F,0x00,//AWB_GAIN_GREEN_1B[7:0] ;
0x2210,0x01,//-/-/-/-/-/-/AWB_GAIN_RED_1B[9:8] ;
0x2211,0x00,//AWB_GAIN_RED_1B[7:0] ;
0x2212,0x01,//-/-/-/-/-/-/AWB_GAIN_BLUE_1B[9:8] ;
0x2213,0x00,//AWB_GAIN_BLUE_1B[7:0] ;
0x2214,0x00,//-/-/-/-/-/-/ALC_DIG_GAIN_1B[9:8] ;
0x2215,0x00,//ALC_DIG_GAIN_1B[7:0] ;
0x2340,0x09,//FR_LENGTH_LINES_1B[15:8] ;
0x2341,0xCE,//FR_LENGTH_LINES_1B[7:0] ;
0x2342,0x0E,//LINE_LENGTH_PCK_1B[15:8] ;
0x2343,0x74,//LINE_LENGTH_PCK_1B[7:0] ;
0x2344,0x00,//X_ADDR_START_1B[15:8] ;
0x2345,0x00,//X_ADDR_START_1B[7:0] ;
0x2346,0x00,//Y_ADDR_START_1B[15:8] ;
0x2347,0x00,//Y_ADDR_START_1B[7:0] ;
0x2348,0x0C,//X_ADDR_END_1B[15:8] ;
0x2349,0xCF,//X_ADDR_END_1B[7:0] ;
0x234A,0x09,//Y_ADDR_END_1B[15:8] ;
0x234B,0x9F,//Y_ADDR_END_1B[7:0] ;
0x234C,0x0C,//X_OUTPUT_SIZE_1B[15:8] ;
0x234D,0xD0,//X_OUTPUT_SIZE_1B[7:0] ;
0x234E,0x09,//Y_OUTPUT_SIZE_1B[15:8] ;
0x234F,0xA0,//Y_OUTPUT_SIZE_1B[7:0] ;
0x2350,0x00,//CONT_FRCNT_1B[7:0] ;
0x2381,0x00,//-/-/-/-/-/-/H_MONI_1B[1:0] ;
0x2382,0x00,//-/-/-/-/-/-/V_MONI_1B[1:0] ;
0x2383,0x00,//-/-/-/-/-/-/BINNING_WEIGHTING_1B[1:0] ;
0x2401,0x00,//-/-/-/-/-/-/SCALING_MODE_1B[1:0] ;
0x2403,0x00,//-/-/-/-/-/-/-/SPATIAL_SAMPLING_1B ;
0x2405,0x10,//SCALE_M_1B[7:0] ;
0x2406,0x00,//[RO] RO_SCALE_N_1B[15:8] ;
0x2407,0x10,//[RO] RO_SCALE_N_1B[7:0] ;
0x2408,0x00,//-/-/-/DCROP_XOFS_1B[12:8] ;
0x2409,0x00,//DCROP_XOFS_1B[7:0] ;
0x240A,0x00,//-/-/-/-/DCROP_YOFS_1B[11:8] ;
0x240B,0x00,//DCROP_YOFS_1B[7:0] ;
0x240C,0x0C,//-/-/-/DCROP_WIDTH_1B[12:8] ;
0x240D,0xD0,//DCROP_WIDTH_1B[7:0] ;
0x240E,0x09,//-/-/-/-/DCROP_HIGT_1B[11:8] ;
0x240F,0xA0,//DCROP_HIGT_1B[7:0] ;
0x2601,0x00,//-/-/-/-/TEST_PATT_MODE_1B[3:0] ;
0x2602,0x02,//-/-/-/-/-/-/TEST_DATA_RED_1B[9:8] ;
0x2603,0xC0,//TEST_DATA_RED_1B[7:0] ;
0x2604,0x02,//-/-/-/-/-/-/TEST_DATA_GREENR_1B[9:8] ;
0x2605,0xC0,//TEST_DATA_GREENR_1B[7:0] ;
0x2606,0x02,//-/-/-/-/-/-/TEST_DATA_BLUE_1B[9:8] ;
0x2607,0xC0,//TEST_DATA_BLUE_1B[7:0] ;
0x2608,0x02,//-/-/-/-/-/-/TEST_DATA_GREENB_1B[9:8] ;
0x2609,0xC0,//TEST_DATA_GREENB_1B[7:0] ;
0x260A,0x00,//HO_CURS_WIDTH_1B[15:8] ;
0x260B,0x00,//HO_CURS_WIDTH_1B[7:0] ;
0x260C,0x00,//HO_CURS_POSITION_1B[15:8] ;
0x260D,0x00,//HO_CURS_POSITION_1B[7:0] ;
0x260E,0x00,//VE_CURS_WIDTH_1B[15:8] ;
0x260F,0x00,//VE_CURS_WIDTH_1B[7:0] ;
0x2610,0x00,//VE_CURS_POSITION_1B[15:8] ;
0x2611,0x00,//VE_CURS_POSITION_1B[7:0] ;
0x3000,0x00,//DPCM6EMB/EMB_OUT_SW/LB_LANE_SEL[1:0]/LBTEST_CLR/LB_TEST_EN/-/LB_MO;
0x3001,0x00,//[RO] -/RO_LBTEST_ERR_K/RO_LBTEST_ERR_M/RO_LBTEST_CNT[4:0] ;
0x3002,0xFF,//[RO] RO_CRC[15:8] ;
0x3003,0xFF,//[RO] RO_CRC[7:0] ;
0x3004,0x00,//-/-/-/ESC_AUTO_OFF/-/TX_TRIGOPT/CLKULPS/ESCREQ ;
0x3005,0x78,//ESCDATA[7:0] ;
0x3006,0x00,//TRIG_DUMMY[7:0] ;
0x3007,0x00,//-/-/-/-/-/-/MIPI_HS_TMODE[1:0] ;
0x3008,0x40,//-/PHASE_ADJUST[2:0]/PISO_STP_X/TXEV_EN/-/- ;
0x3009,0x20,//-/-/MIPI_CLK_MODE/CCP2BLKD/-/CCP2_4L/CCP2_3L/CCP2_2L ;
0x300A,0x0F,//-/-/-/-/LVDS_CLK_DELAY[3:0] ;
0x300B,0x00,//LVDS_D1_DELAY[3:0]/LVDS_D2_DELAY[3:0] ;
0x300C,0x00,//LVDS_D3_DELAY[3:0]/LVDS_D4_DELAY[3:0] ;
0x300D,0x12,//-/-/EMB_ID[5:0] ;
0x300E,0x00,//-/-/-/-/HS_SR_CNT[1:0]/LP_SR_CNT[1:0] ;
0x300F,0x00,//-/-/-/-/-/APP_EMB_EN/MIPI_VS_EN/MIPI_VS_POL ;
0x3010,0x00,//-/-/-/-/-/-/FIFODLY[9:8] ;
0x3011,0x00,//FIFODLY[7:0] ;
0x3012,0x01,//-/-/-/-/-/-/-/LNKBTWK_ON ;
0x3013,0xD8,//NUMWAKE[7:0] ;
0x3014,0x60,//-/ZERO_CONV_MR/ZERO_CONV_MD/ZERO_CONV_CD/SM8SM[3:0] ;
0x3015,0x00,//T_VALUE1[7:0] ;
0x3016,0x00,//T_VALUE2[7:0] ;
0x3017,0x00,//T_VALUE3[7:0] ;
0x3018,0x00,//T_VALUE4[7:0] ;
0x3019,0x00,//-/-/-/-/-/-/-/CWAKE_OFF ;
0x301A,0x00,//-/-/-/-/-/-/PAR_NOMRGN/PAR_MODE ;
0x301B,0x0F,//[RO] -/-/-/-/RO_LINE_NUM[11:8] ;
0x301C,0xFF,//[RO] RO_LINE_NUM[7:0] ;
0x301F,0x00,//-/-/-/-/REG18_CNT[3:0] ;
0x3020,0x27,//-/AD_CNTL[2:0]/-/ST_CNTL[2:0] ;
0x3021,0x03,//-/-/-/-/-/BST_CNTL[2:0] ;
0x3030,0x00,//-/-/-/-/-/H_CROP[2:0] ;
0x3031,0x00,//-/HCRP_AUTO/-/HGAIN2/-/-/HFCORROFF/EQ_MONI ;
0x3033,0x00,//-/-/-/-/-/-/-/MONI_MODE ;
0x3040,0x00,//-/-/CONT_MDSEL_FRVAL[1:0]/-/-/CONT_FRCNT_MSK/CONT_GRHOLD_MSK ;
0x30A0,0x00,//[RO] PISO[15:8] ;
0x30A1,0x00,//[RO] PISO[7:0] ;
0x30A2,0xD0,//DCLK_DRVUP/DOUT_DRVUP/SDA_DRVUP/FLASH_DRVUP/-/-/-/PISO_MSKN ;
0x30A3,0xF8,//PARA_HZ/DCLK_POL/-/SER_HZ/-/PARA_SW[2:0] ;
0x30A4,0x80,//WAIT_TIME_SEL[1:0]/-/-/VTCK_SEL[1:0]/OPCK_SEL[1:0] ;
0x30A5,0x01,//SLEEP_SW/VCO_STP_SW/PHY_PWRON_SW/-/SLEEP_MN/VCO_STP_MN/PHY_PWRON_M;
0x30A6,0x0B,//PLL_SNR_CNTL[1:0]/PLL_SYS_CNTL[1:0]/PLL_SINGLE_CKSP/PLL_SINGLE_SW/;
0x30A7,0x00,//AUTO_IR_SEL_LG/AUTO_IR_SEL_ST/ICP_SEL[1:0]/LPFR_SEL[1:0]/-/- ;
0x30A8,0x21,//PCMODE/-/ICP_PCH/ICP_NCH/PISO_STPX_SW/PISO_STPX_MN/-/VCO_TESTSEL ;
0x30A9,0x00,//-/AMON0_SEL[2:0]/-/REGVD_SEL/PLLEV_EN/PLLEV_SEL ;
0x30AA,0x88,//VOUT_SWSB[3:0]/VOUT_SEL[3:0] ;
0x30AB,0x07,//-/-/-/-/BIAS28_SEL/CAMP28_EN/BIAS_SEL/CAMP_EN ;
0x30AC,0x09,//MHZ_EXTCLK_TB[15:8] ;
0x30AD,0x60,//MHZ_EXTCLK_TB[7:0] ;
0x30AE,0x00,//-/-/-/-/-/-/-/PLL_MULT_ST[8] ;
0x30AF,0x21,//PLL_MULT_ST[7:0] ;
0x30B0,0x00,//-/-/-/-/-/PRE_PLL_CNTL_ST[2:0] ;
0x30B1,0x00,//-/-/-/-/-/TM_PARA_SEL[2:0] ;
0x30B2,0x00,//-/-/-/TEST_EN/TESTPIN[3:0] ;
0x30B3,0x79,//-/VOUT28_SEL[2:0]/REGSTP28_X/-/CL_SEL[1:0] ;
0x30CF,0x00,//-/-/-/-/-/-/THERMO_MODE[1:0] ;
0x30D0,0x19,//THERMO_ADTEST/THERMO_OUTSEL/THERMO_ENX/THERMO_PNP/THERMO_DIV[1:0]/;
0x30D1,0x25,//THERMO_OFFSET[7:0] ;
0x30D2,0x01,//-/-/-/-/-/-/THERMO_MPY[9:8] ;
0x30D3,0x3B,//THERMO_MPY[7:0] ;
0x3100,0x07,//OTP_RWT/OTP_RNUM[1:0]/OTP_VERIFY/OTP_VMOD/OTP_PCLK[2:0] ;
0x3101,0x00,//[RO] OTP_ISTS[2:0]/OTP_VE/OTP_TOE/OTP_VIR/-/- ;
0x3102,0x00,//OTP_TEST[3:0]/OTP_SPBE/OTP_TOEC/OTP_VEEC/OTP_STRC ;
0x3103,0x00,//[RO] OTP_VEE[7:0] ;
0x3104,0x06,//OTP_LD_FEND/OTP_LD_RELD/-/-/-/OTP_LD_STS[1:0]/OTP_LD_ING ;
0x3400,0x00,//OTP_STA/-/-/-/-/OTP_CLRE/OTP_WREC/OTP_ENBL ;
0x3401,0x00,//[RO] -/-/-/-/OTP_IIU/OTP_DCOR/OTP_WIR/OTP_RIR ;
0x3402,0x00,//OTP_PSEL[7:0] ;
0x3404,0x00,//OTP_DATA0[7:0] ;
0x3405,0x00,//OTP_DATA1[7:0] ;
0x3406,0x00,//OTP_DATA2[7:0] ;
0x3407,0x00,//OTP_DATA3[7:0] ;
0x3408,0x00,//OTP_DATA4[7:0] ;
0x3409,0x00,//OTP_DATA5[7:0] ;
0x340A,0x00,//OTP_DATA6[7:0] ;
0x340B,0x00,//OTP_DATA7[7:0] ;
0x340C,0x00,//OTP_DATA8[7:0] ;
0x340D,0x00,//OTP_DATA9[7:0] ;
0x340E,0x00,//OTP_DATA10[7:0] ;
0x340F,0x00,//OTP_DATA11[7:0] ;
0x3410,0x00,//OTP_DATA12[7:0] ;
0x3411,0x00,//OTP_DATA13[7:0] ;
0x3412,0x00,//OTP_DATA14[7:0] ;
0x3413,0x00,//OTP_DATA15[7:0] ;
0x3414,0x00,//OTP_DATA16[7:0] ;
0x3415,0x00,//OTP_DATA17[7:0] ;
0x3416,0x00,//OTP_DATA18[7:0] ;
0x3417,0x00,//OTP_DATA19[7:0] ;
0x3418,0x00,//OTP_DATA20[7:0] ;
0x3419,0x00,//OTP_DATA21[7:0] ;
0x341A,0x00,//OTP_DATA22[7:0] ;
0x341B,0x00,//OTP_DATA23[7:0] ;
0x341C,0x00,//OTP_DATA24[7:0] ;
0x341D,0x00,//OTP_DATA25[7:0] ;
0x341E,0x00,//OTP_DATA26[7:0] ;
0x341F,0x00,//OTP_DATA27[7:0] ;
0x3420,0x00,//OTP_DATA28[7:0] ;
0x3421,0x00,//OTP_DATA29[7:0] ;
0x3422,0x00,//OTP_DATA30[7:0] ;
0x3423,0x00,//OTP_DATA31[7:0] ;
0x3424,0x00,//OTP_DATA32[7:0] ;
0x3425,0x00,//OTP_DATA33[7:0] ;
0x3426,0x00,//OTP_DATA34[7:0] ;
0x3427,0x00,//OTP_DATA35[7:0] ;
0x3428,0x00,//OTP_DATA36[7:0] ;
0x3429,0x00,//OTP_DATA37[7:0] ;
0x342A,0x00,//OTP_DATA38[7:0] ;
0x342B,0x00,//OTP_DATA39[7:0] ;
0x342C,0x00,//OTP_DATA40[7:0] ;
0x342D,0x00,//OTP_DATA41[7:0] ;
0x342E,0x00,//OTP_DATA42[7:0] ;
0x342F,0x00,//OTP_DATA43[7:0] ;
0x3430,0x00,//OTP_DATA44[7:0] ;
0x3431,0x00,//OTP_DATA45[7:0] ;
0x3432,0x00,//OTP_DATA46[7:0] ;
0x3433,0x00,//OTP_DATA47[7:0] ;
0x3434,0x00,//OTP_DATA48[7:0] ;
0x3435,0x00,//OTP_DATA49[7:0] ;
0x3436,0x00,//OTP_DATA50[7:0] ;
0x3437,0x00,//OTP_DATA51[7:0] ;
0x3438,0x00,//OTP_DATA52[7:0] ;
0x3439,0x00,//OTP_DATA53[7:0] ;
0x343A,0x00,//OTP_DATA54[7:0] ;
0x343B,0x00,//OTP_DATA55[7:0] ;
0x343C,0x00,//OTP_DATA56[7:0] ;
0x343D,0x00,//OTP_DATA57[7:0] ;
0x343E,0x00,//OTP_DATA58[7:0] ;
0x343F,0x00,//OTP_DATA59[7:0] ;
0x3440,0x00,//OTP_DATA60[7:0] ;
0x3441,0x00,//OTP_DATA61[7:0] ;
0x3442,0x00,//OTP_DATA62[7:0] ;
0x3443,0x00,//OTP_DATA63[7:0] ;
0x3200,0x10,//MKCP_MSK[1:0]/-/MSK_OFF/VCO_CONV[2:0]/- ;
0x3202,0x04,//ES_MARGIN[7:0] ;
0x3203,0x04,//ES_MARGIN2[7:0] ;
0x3205,0x00,//FLS_ESMODE/-/-/-/TEST_MTC_VGSW/TEST_MTC_RG_VG/-/- ;
0x3206,0x04,//-/KUMA_SW/KURI_SET/KURI_FCSET/ESYNC_SW/VSYNC_PH/HSYNC_PH/- ;
0x3207,0x00,//-/-/-/-/-/-/-/KACHIMASK ;
0x3209,0x00,//-/-/-/-/-/-/-/GLBRST_REQ ;
0x320A,0x00,//-/-/-/GLBRST_FLSH_OFF/-/-/GLBRST_MODE[1:0] ;
0x320B,0x51,//-/GLBRST_STRPOS[2:0]/-/-/GLBRST_DRVUNIT[1:0] ;
0x320C,0x00,//DRVR_STB_U[15:8] ;
0x320D,0x20,//DRVR_STB_U[7:0] ;
0x320E,0x00,//DRVR_STB_W[15:8] ;
0x320F,0x08,//DRVR_STB_W[7:0] ;
0x3210,0x00,//FLSH_STB_U[15:8] ;
0x3211,0x20,//FLSH_STB_U[7:0] ;
0x3212,0x00,//FLSH_STB_W[15:8] ;
0x3213,0x40,//FLSH_STB_W[7:0] ;
0x3214,0x13,//GRST_RDY_W[7:0] ;
0x3215,0x10,//-/-/GLBRST_SENTG_W[5:0] ;
0x3216,0x00,//-/-/-/-/-/-/-/MANU_CKNUM_SEL ;
0x3217,0x00,//MANU_CKNUM_SPCK[7:0] ;
0x3218,0x05,//GLBRST_RESERVE[7:4]/GRST_ALLZEROSET_N[3:0] ;
0x321B,0x80,//DFCT_YADJ[3:0]/DFCT_XADJ[3:0] ;
0x321C,0x00,//-/-/-/-/-/-/-/DCROP_SEL ;
0x321D,0x00,//-/-/SPCKSW_VEN/SPCKSW_HEN/-/-/-/- ;
0x321E,0x00,//-/HC_PRESET[14:8] ;
0x321F,0x00,//HC_PRESET[7:0] ;
0x3220,0x00,//VC_PRESET[15:8] ;
0x3221,0x00,//VC_PRESET[7:0] ;
0x3222,0x26,//TPG_HSTOFST[7:0] ;
0x3223,0x04,//TPG_VSTOFST[7:0] ;
0x3227,0x10,//V_YUKO_START[7:0] ;
0x3228,0x28,//H_YUKO_START[7:0] ;
0x3229,0x0F,//H_OB_START[7:0] ;
0x322A,0x00,//PP_VBLK_START[7:0] ;
0x322B,0x00,//PP_VBLK_WIDTH[7:0] ;
0x322C,0x1C,//PP_HBLK_START[7:0] ;
0x322D,0x00,//PP_HBLK_WIDTH[7:0] ;
0x322E,0x00,//-/-/-/TEST_TG_VGSW/VOB_DISP/-/-/- ;
0x322F,0x00,//SBNRY_V_START[7:0] ;
0x3230,0x00,//SBNRY_H_START[7:0] ;
0x3231,0x10,//SBNRY_VBLK_START[7:0] ;
0x3232,0x00,//SBNRY_VBLK_WIDTH[7:0] ;
0x3233,0x28,//SBNRY_HBLK_START[7:0] ;
0x3234,0x00,//SBNRY_HBLK_WIDTH[7:0] ;
0x3235,0x3B,//HLNR_HBLK_START[7:0] ;
0x3236,0x00,//HLNR_HBLK_WIDTH[7:0] ;
0x3237,0x00,//-/-/-/-/-/SP_COUNT[10:8] ;
0x3238,0xE7,//SP_COUNT[7:0] ;
0x3239,0x00,//AG_LIMSW/-/TEST_AGC_VGSW/TEST_SPG_VGSW/TEST_MAG/TEST_AGCONT/-/- ;
0x323A,0x80,//AG_MIN[7:0] ;
0x323B,0x42,//AG_MAX[7:0] ;
0x323C,0x00,//-/-/-/-/-/HREG_HRST_POS[10:8] ;
0x323D,0x00,//HREG_HRST_POS[7:0] ;
0x323E,0x0F,//TPG_RNSW/-/TPG_DINSW[1:0]/TPG_DOUTASW/TPG_DIN_DLYA[2:0] ;
0x323F,0x1F,//-/TPG_LIPOL/TPG_CSPOL/TPG_CNTR/TPG_DOUTBSW/TPG_DIN_DLYB[2:0] ;
0x3240,0x00,//TPG_NOISE_MP[7:0] ;
0x3241,0x00,//TPG_OBLVL[7:0] ;
0x3242,0x10,//-/-/TPG_BLKLVL_SEL[1:0]/-/-/TPG_TPBP_PIX[1:0] ;
0x3243,0x00,//TPG_DANSASW/TPG_NOISESW/TPG_NOISE_SEL[1:0]/-/-/-/- ;
0x3244,0x80,//TPG_R_DANSA[7:0] ;
0x3245,0x80,//TPG_GR_DANSA[7:0] ;
0x3246,0x80,//TPG_GB_DANSA[7:0] ;
0x3247,0x80,//TPG_B_DANSA[7:0] ;
0x3248,0x00,//TPG_RDIN[7:0] ;
0x3249,0x07,//-/TPG_CNTSFT[2:0]/-/TPG_CNTLM[2:0] ;
0x324A,0x00,//-/-/-/TPG_CNTSEL/-/-/TPG_CNTSK[1:0] ;
0x324B,0x00,//-/-/-/-/-/-/-/LDNRSW ;
0x324C,0x00,//HNCLIM1[3:0]/HNCLIM0[3:0] ;
0x324D,0x00,//-/-/-/-/HNCLIM2[3:0] ;
0x324E,0x00,//-/-/-/-/LDNRGA[3:0] ;
0x3250,0x03,//-/-/-/-/-/-/DANSAOFF/BLCSW ;
0x3251,0xFF,//AREASEL[7:0] ;
0x3252,0xFF,//S_ADJ[7:0] ;
0x3253,0x40,//-/OB_BLACK[6:0] ;
0x3254,0x00,//-/GR1_G[6:0] ;
0x3255,0x00,//-/GR2_G[6:0] ;
0x3256,0x00,//-/GB1_G[6:0] ;
0x3257,0x00,//-/GB2_G[6:0] ;
0x3258,0x00,//-/R1_G[6:0] ;
0x3259,0x00,//-/R2_G[6:0] ;
0x325A,0x00,//-/B1_G[6:0] ;
0x325B,0x00,//-/B2_G[6:0] ;
0x325C,0x3F,//-/-/IMPLIM[5:0] ;
0x325D,0x1F,//-/-/-/OBNLIM[4:0] ;
0x325E,0x00,//-/-/-/-/VOB_ADJ[3:0] ;
0x325F,0x07,//-/-/-/-/-/CALCSEL[2:0] ;
0x3260,0x00,//-/-/-/-/-/-/GDANSASW/PEDAJSW ;
0x3261,0x00,//GDANSALV[7:0] ;
0x3262,0x00,//GRPED1[3:0]/GRPED0[3:0] ;
0x3263,0x00,//RPED1[3:0]/RPED0[3:0] ;
0x3264,0x00,//BPED1[3:0]/BPED0[3:0] ;
0x3265,0x00,//GBPED1[3:0]/GBPED0[3:0] ;
0x3266,0x00,//-/-/-/-/GDANSAG[3:0] ;
0x3267,0x00,//[RO] RO_RG_BLKLVL[7:0] ;
0x3268,0x00,//[RO] RO_GB_BLKLVL[7:0] ;
0x326A,0x09,//[RO] RO_MTC_VCNT[15:8] ;
0x326B,0xCD,//[RO] RO_MTC_VCNT[7:0] ;
0x326C,0x00,//[RO] RO_MTC_VCNT_REM[15:8] ;
0x326D,0x02,//[RO] RO_MTC_VCNT_REM[7:0] ;
0x3270,0x00,//TEMPSEN_START[15:8] ;
0x3271,0x02,//TEMPSEN_START[7:0] ;
0x3272,0x00,//TEMPSEN_WIDTH[15:8] ;
0x3273,0x02,//TEMPSEN_WIDTH[7:0] ;
0x3276,0x00,//-/-/-/-/-/-/-/PWBSW ;
0x3277,0x40,//PWBGAINR[7:0] ;
0x3278,0x00,//PWBGAINGR[7:0] ;
0x3279,0x00,//PWBGAINGB[7:0] ;
0x327A,0x80,//PWBGAINB[7:0] ;
0x327C,0x00,//HBPIX_L[3:0]/HBPIX_R[3:0] ;
0x327D,0x00,//VBPIX_T[3:0]/VBPIX_B[3:0] ;
0x327E,0x04,//HVBPIX_VAL[7:0] ;
0x3280,0x01,//-/-/-/-/-/-/-/LSSCSW ;
0x3281,0x00,//-/-/-/-/-/-/LSLIPOL/LSCSPOL ;
0x3282,0x00,//-/-/-/-/-/-/-/LSAGSW ;
0x3284,0x00,//-/-/-/-/-/-/-/LSVCNT_MPYSW ;
0x3285,0x00,//LSHCNT_ADJ[7:0] ;
0x3286,0x00,//LSVCNT_ADJ[7:0] ;
0x3287,0x00,//-/LS4SIG[2:0]/-/LS1SIG[2:0] ;
0x3288,0x80,//LSHOFG[7:0] ;
0x3289,0x80,//LSHOFR[7:0] ;
0x328A,0x80,//LSHOFB[7:0] ;
0x328B,0x80,//LSVOFG[7:0] ;
0x328C,0x80,//LSVOFR[7:0] ;
0x328D,0x80,//LSVOFB[7:0] ;
0x328E,0x00,//LSALUG[7:0] ;
0x328F,0x00,//LSALUR[7:0] ;
0x3290,0x00,//LSALUB[7:0] ;
0x3291,0x00,//LSARUG[7:0] ;
0x3292,0x00,//LSARUR[7:0] ;
0x3293,0x00,//LSARUB[7:0] ;
0x3294,0x00,//LSALDG[7:0] ;
0x3295,0x00,//LSALDR[7:0] ;
0x3296,0x00,//LSALDB[7:0] ;
0x3297,0x00,//LSARDG[7:0] ;
0x3298,0x00,//LSARDR[7:0] ;
0x3299,0x00,//LSARDB[7:0] ;
0x329A,0xA0,//LSBLG[7:0] ;
0x329B,0xB0,//LSBLR[7:0] ;
0x329C,0x80,//LSBLB[7:0] ;
0x329D,0xA0,//LSBRG[7:0] ;
0x329E,0xB0,//LSBRR[7:0] ;
0x329F,0x80,//LSBRB[7:0] ;
0x32A0,0xA0,//LSCUG[7:0] ;
0x32A1,0xB0,//LSCUR[7:0] ;
0x32A2,0x80,//LSCUB[7:0] ;
0x32A3,0xA0,//LSCDG[7:0] ;
0x32A4,0xB0,//LSCDR[7:0] ;
0x32A5,0x80,//LSCDB[7:0] ;
0x32A6,0x20,//LSDLG[7:0] ;
0x32A7,0x20,//LSDLR[7:0] ;
0x32A8,0x20,//LSDLB[7:0] ;
0x32A9,0x20,//LSDRG[7:0] ;
0x32AA,0x20,//LSDRR[7:0] ;
0x32AB,0x20,//LSDRB[7:0] ;
0x32AC,0x20,//LSEUG[7:0] ;
0x32AD,0x20,//LSEUR[7:0] ;
0x32AE,0x20,//LSEUB[7:0] ;
0x32AF,0x20,//LSEDG[7:0] ;
0x32B0,0x20,//LSEDR[7:0] ;
0x32B1,0x20,//LSEDB[7:0] ;
0x32B2,0x00,//-/-/-/-/LSAG_L[3:0] ;
0x32B3,0x00,//-/-/-/-/LSAR_L[3:0] ;
0x32B4,0x00,//-/-/-/-/LSAB_L[3:0] ;
0x32B5,0x00,//LSBLG_L[3:0]/LSBRG_L[3:0] ;
0x32B6,0x00,//LSBLR_L[3:0]/LSBRR_L[3:0] ;
0x32B7,0x00,//LSBLB_L[3:0]/LSBRB_L[3:0] ;
0x32B8,0x00,//LSCUG_L[3:0]/LSCDG_L[3:0] ;
0x32B9,0x00,//LSCUR_L[3:0]/LSCDR_L[3:0] ;
0x32BA,0x00,//LSCUB_L[3:0]/LSCDB_L[3:0] ;
0x32BB,0x80,//LSHCNT_MPY[7:0] ;
0x32BC,0x01,//-/-/-/-/LSVCNT_MPY[11:8] ;
0x32BD,0x00,//LSVCNT_MPY[7:0] ;
0x32BE,0x02,//-/-/-/-/-/-/LSMGSEL[1:0] ;
0x32BF,0x0F,//-/-/-/-/WBPSW/BBPSW/ANRSW/ABPCSW ;
0x32C0,0x00,//CONLV1[7:0] ;
0x32C1,0xFF,//CONLV2[7:0] ;
0x32C2,0x0C,//BBPLV[7:0] ;
0x32C4,0x20,//WBPLV0[7:0] ;
0x32C5,0x00,//WHTAG[7:0] ;
0x32C6,0x68,//ANCNTLV[7:0] ;
0x32C7,0x00,//WBPLV2[3:0]/WBPLV1[3:0] ;
0x32C8,0x08,//NSGAIN1[3:0]/NSGAIN0[3:0] ;
0x32C9,0x00,//-/-/-/-/NSGAIN2[3:0] ;
0x32CA,0x03,//EGCRNG1[3:0]/EGCRNG0[3:0] ;
0x32CB,0x00,//-/-/-/-/EGCRNG2[3:0] ;
0x32CC,0x80,//EGGAIN[3:0]/EGLIMS[1:0]/EGLIMSG[1:0] ;
0x32CD,0x04,//-/-/-/-/AJUST0[3:0] ;
0x32CE,0x00,//-/-/-/MAP_RLPOL/-/-/DFCT_VBIN/TEST_MAPABPC ;
0x32CF,0x00,//[RO] DFCT_NUM[7:0] ;
0x32D0,0x00,//-/-/-/-/-/-/WDRSW_VREG/WDRSW ;
0x32D1,0x00,//WDR_MDSEL/-/-/-/-/-/WDRMD[1:0] ;
0x32D2,0x00,//WDRLV0[7:0] ;
0x32D3,0x00,//ANRG1[3:0]/ANRG0[3:0] ;
0x32D4,0x00,//ANRG3[3:0]/ANRG2[3:0] ;
0x32D5,0x88,//WDRBLSH1[3:0]/WDRBLSH0[3:0] ;
0x32D6,0x88,//WDRBLSH3[3:0]/WDRBLSH2[3:0] ;
0x32D7,0x88,//WDRBLSL1[3:0]/WDRBLSL0[3:0] ;
0x32D8,0x88,//WDRBLSL3[3:0]/WDRBLSL2[3:0] ;
0x32D9,0x00,//-/-/-/-/-/-/-/SLSIG ;
0x32DA,0x00,//WD_BBPLV[7:0] ;
0x32DB,0x00,//WD_WBPLV[7:0] ;
0x32DC,0x00,//-/-/-/-/-/DATA_NOCLP/WDRSFT/YADJSW ;
0x32DD,0x00,//-/-/-/-/-/-/GPO_OUT_SYNC/GPO_OUT ;
0x32DE,0x00,//-/-/-/-/-/-/DPC_THRESHOLD_SEL[1:0] ;
0x32DF,0x03,//-/-/-/-/-/-/FLASH_GPO_SYNC/FLASH_GPO ;
0x32E0,0x00,//-/-/-/-/-/-/-/FLASH_TRG ;
0x32E1,0x00,//[RO] -/-/-/-/-/-/-/FLASH_STATUS ;
0x32E2,0x00,//-/-/FLASH_MODE[5:0] ;
0x32E3,0x01,//FLASH_ADJ[7:0] ;
0x32E4,0x00,//FLASH_LINE[15:8] ;
0x32E5,0x01,//FLASH_LINE[7:0] ;
0x32E6,0x00,//FLASH_DELAY[15:8] ;
0x32E7,0x20,//FLASH_DELAY[7:0] ;
0x32E8,0x00,//FLASH_WIDTH1H[15:8] ;
0x32E9,0x04,//FLASH_WIDTH1H[7:0] ;
0x32EA,0x00,//FLASH_WIDTH2H[15:8] ;
0x32EB,0x04,//FLASH_WIDTH2H[7:0] ;
0x32EC,0x00,//FLASH_WIDTHL[15:8] ;
0x32ED,0x04,//FLASH_WIDTHL[7:0] ;
0x32EE,0x00,//FLASH_COUNT[7:0] ;
0x32F0,0x00,//AF_LLV_CNTR[7:0] ;
0x32F1,0x00,//AF_TRG_PNT[15:8] ;
0x32F2,0x00,//AF_TRG_PNT[7:0] ;
0x32F3,0x00,//AF_MAIN_T3[15:8] ;
0x32F4,0x00,//AF_MAIN_T3[7:0] ;
0x32F5,0x00,//AF_MAIN_PC[7:0] ;
0x32F6,0x00,//AF_PH1_T3[15:8] ;
0x32F7,0x00,//AF_PH1_T3[7:0] ;
0x32F8,0x00,//AF_PH1_PC[7:0] ;
0x32F9,0x00,//AF_PH2_T3[15:8] ;
0x32FA,0x00,//AF_PH2_T3[7:0] ;
0x32FB,0x00,//AF_PH2_PC[7:0] ;
0x3300,0x0C,//-/-/-/-/POSLFIX/NEGLFIX/-/NEGLEAKCUT ;
0x3301,0x0B,//BSTPOSEV/BSTPOS2EN/-/BSTNEGCNT[4:0] ;
0x3302,0xB4,//BSTPOS2SEL/BSTPOS2CNT[2:0]/BSTPOSSEL/BSTPOSCNT[2:0] ;
0x3303,0x12,//-/BSTPOS2HG[2:0]/-/BSTPOSHG[2:0] ;
0x3304,0x56,//-/BSTPOSGA[2:0]/GDMOS2CNT[1:0]/GDMOSCNTX4/GDMOSBGREN ;
0x3305,0x0F,//READVDSEL[1:0]/-/-/GDMOS2EN_MODE4/GDMOS2EN_MODE3/GDMOS2EN_MODE2/GD;
0x3306,0x80,//RSTVDSEL_AZS[1:0]/RSTVDSEL_NML[1:0]/RSTDRNVDSEL_GLB[1:0]/RSTDRNVDS;
0x3307,0x44,//KBIASCNT_RNG4[3:0]/KBIASCNT_RNG3[3:0] ;
0x3308,0x44,//KBIASCNT_RNG2[3:0]/KBIASCNT_RNG1[3:0] ;
0x3309,0x00,//-/-/-/BSVBPSEL[4:0] ;
0x330A,0x66,//DRADRVLV_RNG4[3:0]/DRADRVLV_RNG3[3:0] ;
0x330B,0x66,//DRADRVLV_RNG2[3:0]/DRADRVLV_RNG1[3:0] ;
0x330C,0x2C,//-/-/DRADRVPU[1:0]/DRADRVI_AZS[1:0]/DRADRVI_NML[1:0] ;
0x330D,0x0C,//VREFIMX4_SEL/-/-/VREFV[4:0] ;
0x330E,0x48,//VREFTEST[1:0]/VREFIMBC/VREFALN/VREFAI[3:0] ;
0x330F,0xE3,//SINTLSEL2/SINTLSEL/SINTSELPH2/SINTSELPH1/-/SINTSELFB[2:0] ;
0x3310,0x20,//SINTSELOUT2[3:0]/SINTSELOUT1[3:0] ;
0x3311,0xD5,//ADSW2WEAK/ADSW1WEAK/-/BGRDVSTPEN/-/ADCMP1SRTSEL/AGADJ_REV_INT/REV_;
0x3312,0x24,//ADCKSEL/-/ADCKDIV[1:0]/-/SENSEMODE[2:0] ;
0x3313,0x05,//-/-/-/-/BIASRSTCNT_NML[3:0] ;
0x3314,0x00,//-/-/SPARE[1:0]/ANAMON1_SEL[3:0] ;
0x3315,0x07,//HREG_TEST/-/NONHEF_PS_ORDER/DATA_LATCH_DLY/TEST_ST_VGSW/BINVSIG/BI;
0x3316,0x00,//EXT_HCNT_MAX_ON/-/-/HCNT_MAX_MODE/-/-/-/MLT_SPL_MODE ;
0x3317,0x03,//HCNT_MAX_FIXVAL[15:8] ;
0x3318,0xD8,//HCNT_MAX_FIXVAL[7:0] ;
0x3319,0x00,//-/-/VREG_TEST[1:0]/-/-/DIS_MODE/RODATA_U ;
0x331A,0x80,//BSC_ULMT_AGRNG3[7:0] ;
0x331B,0x40,//BSC_ULMT_AGRNG2[7:0] ;
0x331C,0x20,//BSC_ULMT_AGRNG1[7:0] ;
0x331D,0x0F,//BSC_OFF/DRESET_HIGH/DRESET_LOW/-/LIMIT_BSC_RNG4/LIMIT_BSC_RNG3/LIM;
0x331E,0x08,//DRESET_LBSC_U[7:0] ;
0x331F,0x20,//DRESET_LBSC_D[7:0] ;
0x3320,0x24,//FTLSNS_LBSC_U[7:0] ;
0x3321,0x00,//FTLSNS_HIGH/-/-/-/FTLSNS_LBSC_D[3:0] ;
0x3322,0x2C,//SADR_LBSC_U[7:0] ;
0x3323,0x00,//SADR_HIGH/-/-/-/SADR_LBSC_D[3:0] ;
0x3324,0x03,//ESREAD_ALT_OFF/-/-/-/-/-/AUTO_READ_W/AUTO_ESREAD_2D ;
0x3325,0x07,//-/-/-/-/FRAC_EXP_TIME_10B[11:8] ;
0x3326,0x8E,//FRAC_EXP_TIME_10B[7:0] ;
0x3327,0x06,//-/-/-/-/FRAC_EXP_TIME_M10[11:8] ;
0x3328,0x9C,//FRAC_EXP_TIME_M10[7:0] ;
0x3329,0x48,//ESREAD_1D[7:0] ;
0x332A,0x47,//ESREAD_1W[7:0] ;
0x332B,0x03,//ES1MODE/-/-/ESREAD_2D[12:8] ;
0x332C,0x68,//ESREAD_2D[7:0] ;
0x332D,0x67,//ESREAD_2W[7:0] ;
0x332E,0x0A,//ESTGRESET_LOW/ESTGRESET_D[6:0] ;
0x332F,0x40,//ALLZEROSET_ON/ALLZEROSET_1ST_ON/ALLZEROSET_CHG_ON/EXTD_ROTGRESET/-;
0x3330,0x04,//ROTGRESET_U[7:0] ;
0x3331,0x10,//-/-/ROTGRESET_W[5:0] ;
0x3332,0x00,//ROREAD_U[7:0] ;
0x3333,0x67,//ROREAD_W[7:0] ;
0x3334,0x00,//RORSTDRN_D_SEL/ALL0SET_U_SEL/-/-/-/-/-/ZEROSET_U[8] ;
0x3335,0x0A,//ZEROSET_U[7:0] ;
0x3336,0x24,//ZEROSET_W[7:0] ;
0x333A,0x3A,//ALLRSTDRN_U[7:0] ;
0x333B,0x0A,//ALLRSTDRN_D[7:0] ;
0x333C,0x46,//ALL0SET_U[7:0] ;
0x333D,0x24,//ALL0SET_W[7:0] ;
0x333E,0x3A,//ALL0SET_INTVL[7:0] ;
0x333F,0x00,//-/-/-/-/-/-/-/BSRSTSW_MPS_AD_U[8] ;
0x3340,0x00,//BSRSTSW_MPS_AD_U[7:0] ;
0x3341,0x00,//BSRSTSW_AD_U[7:0] ;
0x3342,0x11,//BIASRSTCNT_RNG4[3:0]/BIASRSTCNT_RNG3[3:0] ;
0x3343,0x11,//BIASRSTCNT_RNG2[3:0]/BIASRSTCNT_RNG1[3:0] ;
0x3344,0x20,//RSTNWEAK_HIGH/RSTNWEAK_LOW/RSTNWEAK_AZS/-/-/-/-/- ;
0x3345,0x00,//RORSTDRN_D[7:0] ;
0x3346,0x3A,//-/RORSTDRN_U[6:0] ;
0x3347,0x01,//DRCUT_DMY_OFF/INTERMIT_DRCUT/DRCUT_SIGIN/-/-/-/-/GDMOSCNT_GCR_RET[;
0x3348,0x9C,//GDMOSCNT_GCR_RET[7:0] ;
0x3349,0x31,//GDMOSCNT_NML_VAL[3:0]/GDMOSCNT_GCR_VAL[3:0] ;
0x334A,0x00,//BGRDVSTP_LOW/-/-/-/-/-/-/- ;
0x334D,0x1C,//BSRSTSW_HIGH/BSRSTSW_LOW/-/BSRSTSW_U[4:0] ;
0x334E,0x0E,//BSRSTSW_D[7:0] ;
0x334F,0x00,//-/-/-/-/-/-/-/SIGIN_ON ;
0x3351,0x18,//ADSW1_D[7:0] ;
0x3352,0x00,//ADSW_U[7:0] ;
0x3353,0x0C,//ADSW1_HIGH/ADSW1DMX_LOW/-/ADSW1DMX_U[4:0] ;
0x3354,0x30,//ADSW1LK_HIGH/ADSW1LK_D[6:0] ;
0x3355,0x30,//ADSW1LKX_LOW/ADSW1LKX_U[6:0] ;
0x3356,0x00,//ADCMP1SRT_NML_RS_U[7:0] ;
0x3357,0x00,//-/-/-/-/-/-/ADCMP1SRT_NML_AD_U[9:8] ;
0x3358,0x00,//ADCMP1SRT_NML_AD_U[7:0] ;
0x3359,0x00,//ADCMP1SRT_MPS_RS_U[7:0] ;
0x335A,0x00,//-/-/-/-/-/-/ADCMP1SRT_MPS_AD1_U[9:8] ;
0x335B,0x00,//ADCMP1SRT_MPS_AD1_U[7:0] ;
0x335C,0x00,//ADCMP1SRT_MPS_ADX_U[7:0] ;
0x335D,0x23,//ADCMP1SRT_LOW/ADCMP1SRT_D[6:0] ;
0x335E,0x18,//ADSW2_HIGH/-/ADSW2_D[5:0] ;
0x335F,0x0C,//ADSW2DMX_LOW/-/-/ADSW2DMX_U[4:0] ;
0x3360,0x00,//RO_DMY_CR_MODE/-/-/-/FIX_ADENX[1:0]/-/- ;
0x3361,0x1F,//-/-/-/BSTCKLFIX_ADC_U[4:0] ;
0x3362,0x01,//-/-/-/BSTCKLFIX_ADC_D[4:0] ;
0x3363,0x00,//CMPI_GCR_CHG[7:0] ;
0x3364,0x01,//-/-/-/-/-/-/-/CMPI_NML_RET[8] ;
0x3365,0x9C,//CMPI_NML_RET[7:0] ;
0x3366,0x03,//CMPI1_NML_VAL[3:0]/CMPI2_NML_VAL[3:0] ;
0x3367,0x33,//CMPI1_GCR_VAL[3:0]/CMPI2_GCR_VAL[3:0] ;
0x3368,0x03,//-/-/-/-/-/GCR_MODE/CDS_ADC_BSTOFF/CDS_STOPBST ;
0x3369,0x10,//BSTCKLFIX_HIGH/BSTCKLFIX_CMP_U[6:0] ;
0x336A,0x14,//-/BSTCKLFIX_CMP_D[6:0] ;
0x336B,0x01,//-/-/-/-/-/-/M10_ADV_INTVL[9:8] ;
0x336C,0x80,//M10_ADV_INTVL[7:0] ;
0x336D,0x00,//-/-/-/-/-/-/M10_RSV_INTVL[9:8] ;
0x336E,0x97,//M10_RSV_INTVL[7:0] ;
0x336F,0x03,//-/-/-/-/SINT_ZS_U[3:0] ;
0x3370,0x3B,//-/SINT_10B_ZS_W[6:0] ;
0x3371,0x2B,//SINT_NML_RS_U[7:0] ;
0x3372,0x59,//SINT_10B_RS_W[7:0] ;
0x3373,0x1D,//SINT_FB_U[7:0] ;
0x3374,0x3B,//-/SINT_10B_FB_W[6:0] ;
0x3375,0x00,//-/-/-/-/-/-/SINT_10B_AD_U[9:8] ;
0x3376,0xBA,//SINT_10B_AD_U[7:0] ;
0x3377,0x01,//-/-/-/-/-/-/SINT_10B_AD_W[9:8] ;
0x3378,0x19,//SINT_10B_AD_W[7:0] ;
0x3379,0x11,//SINT_NML_RF_U[7:0] ;
0x337A,0x59,//SINT_10B_RF_W[7:0] ;
0x337B,0x11,//-/-/SINTX_DSHIFT[1:0]/-/-/SINTX_USHIFT[1:0] ;
0x337C,0x3B,//-/SINT_M10_ZS_W[6:0] ;
0x337D,0x59,//SINT_M10_RS_W[7:0] ;
0x337E,0x6C,//SINT_M10_RS_U[7:0] ;
0x337F,0x00,//-/-/-/-/-/-/SINT_M10_AD1_U[9:8] ;
0x3380,0xBA,//SINT_M10_AD1_U[7:0] ;
0x3381,0x3B,//-/SINT_M10_FB_W[6:0] ;
0x3382,0x01,//-/-/-/-/-/-/SINT_M10_AD_W[9:8] ;
0x3383,0x19,//SINT_M10_AD_W[7:0] ;
0x3384,0x0C,//-/SINT_MPS_FB_D[6:0] ;
0x3385,0x09,//-/SINT_MPS_IRS_U[6:0] ;
0x3386,0x16,//-/SINT_M10_IRS_W[6:0] ;
0x3387,0x09,//SINT_MPS_IAD_U[7:0] ;
0x3388,0x46,//SINT_M10_IAD_W[7:0] ;
0x3389,0x09,//SINT_MPS_RF_U[7:0] ;
0x338A,0x01,//-/-/-/-/-/-/SRST_10B_RS_U[9:8] ;
0x338B,0x1C,//SRST_10B_RS_U[7:0] ;
0x338C,0x1A,//-/-/SRST_RS_W[5:0] ;
0x338D,0x00,//-/-/-/-/-/-/-/SRST_10B_ZS_U[8] ;
0x338E,0x87,//SRST_10B_ZS_U[7:0] ;
0x338F,0x1A,//-/-/SRST_ZS_W[5:0] ;
0x3390,0x03,//-/-/-/-/SRST_AD_U[3:0] ;
0x3391,0x00,//-/-/-/-/-/-/-/SRST_10B_AD_D[8] ;
0x3392,0x91,//SRST_10B_AD_D[7:0] ;
0x3393,0x00,//-/-/-/-/-/-/-/SRST_M10_AD2_D[8] ;
0x3394,0x91,//SRST_M10_AD2_D[7:0] ;
0x3395,0x01,//-/-/-/-/-/SRST_M10_RS2_U[10:8] ;
0x3396,0xC3,//SRST_M10_RS2_U[7:0] ;
0x3397,0x1A,//-/-/SRST_MPS_AD_W[5:0] ;
0x3398,0x03,//VREFSHBGR_LOW/VREFSHBGR_HIGH/-/-/VREFSHBGR_D[3:0] ;
0x3399,0xE8,//VREFSHBGR_U[7:0] ;
0x339A,0x80,//EN_VREFC_ZERO/-/-/-/-/-/-/- ;
0x339B,0xF0,//VREF_H_START_U[7:0] ;
0x339D,0x00,//ADCKEN_MASK[1:0]/-/-/-/-/-/- ;
0x339E,0x0B,//ADCKEN_NML_RS_U[7:0] ;
0x339F,0x0F,//-/-/-/ADCKEN_RS_D[4:0] ;
0x33A0,0x0B,//ADCKEN_NML_AD_U[7:0] ;
0x33A1,0x0F,//-/-/-/ADCKEN_AD_D[4:0] ;
0x33A2,0x0B,//ADCKEN_MPS_RS_U[7:0] ;
0x33A3,0x0B,//ADCKEN_MPS_AD_U[7:0] ;
0x33A4,0x09,//-/-/-/-/CNTRSTX_U[3:0] ;
0x33A5,0x0F,//-/-/-/CNT0RSTX_RS_D[4:0] ;
0x33A6,0x09,//-/-/-/-/CNT0RSTX_AD_U[3:0] ;
0x33A7,0x0F,//CNTRD_HCNT_DRV/-/-/CNT0RSTX_AD_D[4:0] ;
0x33A8,0x17,//CNTRD_HCNT_U[7:0] ;
0x33A9,0x0B,//-/-/-/CNTINVX_START[4:0] ;
0x33AA,0x14,//EDCONX_RS_D[7:0] ;
0x33AB,0x00,//EDCONX_RS_HIGH/EDCONX_AD_HIGH/-/-/-/-/-/EDCONX_AD_D[8] ;
0x33AC,0x28,//EDCONX_AD_D[7:0] ;
0x33AD,0x0F,//-/-/-/-/BSDIGITAL_RNG4/BSDIGITAL_RNG3/BSDIGITAL_RNG2/BSDIGITAL_RNG;
0x33AE,0x00,//ADTESTCK_INTVL[3:0]/-/-/ADTESTCK_ON/COUNTER_TEST ;
0x33B0,0x04,//EXT_VCD_ADJ_ON/ROUND_VREF_CODE/AUTO_BIT_SFT_VCD/AG_SEN_SHIFT/VCD_C;
0x33B1,0x00,//VCD_COEF_FIXVAL[7:0] ;
0x33B2,0x40,//VCD_RNG_TYPE_SEL[1:0]/VCD_INTC_FIXVAL[5:0] ;
0x33B3,0x1B,//VREFAD_RNG1_SEL[1:0]/VREFAD_RNG2_SEL[1:0]/VREFAD_RNG3_SEL[1:0]/VRE;
0x33B4,0x00,//-/-/-/-/-/-/VREFIC_MODE[1:0] ;
0x33B5,0x80,//RI_VREFAD_COEF[7:0] ;
0x33B6,0x00,//-/-/-/-/-/-/AGADJ1_VREFI_ZS[9:8] ;
0x33B7,0x3C,//AGADJ1_VREFI_ZS[7:0] ;
0x33B8,0x00,//-/-/-/-/-/-/AGADJ2_VREFI_ZS[9:8] ;
0x33B9,0x1E,//AGADJ2_VREFI_ZS[7:0] ;
0x33BA,0x00,//-/-/-/-/-/-/-/AGADJ1_VREFI_AD[8] ;
0x33BB,0x3C,//AGADJ1_VREFI_AD[7:0] ;
0x33BC,0x00,//-/-/-/-/-/-/-/AGADJ2_VREFI_AD[8] ;
0x33BD,0x1E,//AGADJ2_VREFI_AD[7:0] ;
0x33BE,0x70,//-/AGADJ_VREFIC[2:0]/-/AGADJ_VREFC[2:0] ;
0x33BF,0x00,//EXT_VREFI_ZS_ON/-/-/-/-/-/VREFI_ZS_FIXVAL[9:8] ;
0x33C0,0x00,//VREFI_ZS_FIXVAL[7:0] ;
0x33C1,0x00,//EXT_VREFI_FB_ON/VREFI_FB_FIXVAL[6:0] ;
0x33C2,0x00,//EXT_VREFC_ON/VREFC_FIXVAL[2:0]/EXT_VREFIC_ON/VREFIC_FIXVAL[2:0] ;
0x33C3,0x00,//-/-/VREFICAID_OFF[1:0]/-/FIX_VREFICAID[2:0] ;
0x33C4,0x00,//-/-/-/-/-/-/VREFICAID_W[9:8] ;
0x33C5,0x78,//VREFICAID_W[7:0] ;
0x33C6,0x00,//EXT_PLLFREQ_ON/-/-/-/PLLFREQ_FIXVAL[3:0] ;
0x33C8,0x00,//-/-/-/ACT_TESTDAC/-/-/-/TESTDACEN ;
0x33C9,0x80,//TDAC_INT[7:0] ;
0x33CA,0x00,//TDAC_MIN[7:0] ;
0x33CB,0x10,//TDAC_STEP[3:0]/-/-/TDAC_SWD[1:0] ;
0x33CC,0x00,//-/-/-/-/-/-/-/AG_TEST ;
0x33CD,0x00,//DACS_INT[7:0] ;
0x33CE,0xFF,//DACS_MAX[7:0] ;
0x33CF,0x10,//DACS_STEP[3:0]/-/-/DACS_SWD[1:0] ;
0x33D0,0x80,//TESTDAC_RSVOL[7:0] ;
0x33D1,0x60,//TESTDAC_ADVOL[7:0] ;
0x33D2,0x02,//-/-/-/-/-/AGADJ_EXEC_MODE[2:0] ;
0x33D3,0x02,//MPS_AGADJ_MODE/AGADJ_CALC_MODE/-/-/AGADJ_FIX_COEF[11:8] ;
0x33D4,0x06,//AGADJ_FIX_COEF[7:0] ;
0x33D5,0x0E,//-/-/-/ZSV_EXEC_MODE[4:0] ;
0x33D6,0x31,//ZSV_FORCE_END[3:0]/-/ZSV_SUSP_OFF/ZSV_SUSP_RANGE[1:0] ;
0x33D7,0x8E,//ZSV_SUSP_CND/-/-/EN_PS_VREFI_ZS[4:0] ;
0x33D8,0x10,//VZS_STEP_M10[7:0] ;
0x33D9,0xA0,//ZSV_LEVEL[7:0] ;
0x33DA,0x20,//-/-/ZSV_IN_RANGE[5:0] ;
0x33DB,0xC7,//PS_VZS_10B_COEF[7:0] ;
0x33DC,0x00,//-/PS_VZS_10B_INTC[6:0] ;
0x33DD,0x30,//VZS_STEP_10B[7:0] ;
0x33DE,0xC4,//ZSV_STOP_CND[1:0]/-/-/ZSV_IN_LINES[3:0] ;
0x33DF,0xC7,//PS_VZS_M10_COEF[7:0] ;
0x33E0,0x00,//-/PS_VZS_M10_INTC[6:0] ;
0x33E1,0x10,//-/FBC_IN_RANGE[6:0] ;
0x33E2,0x84,//FBC_SUSP_RANGE[1:0]/FBC_SUSP_OFF/FBC_IN_LINES[4:0] ;
0x33E3,0x5F,//FBC_OUT_RANGE[1:0]/-/FBC_OUT_LINES[4:0] ;
0x33E4,0x32,//-/FBC_STOP_CND[2:0]/-/FBC_START_CND[2:0] ;
0x33E5,0x11,//VFB_STEP_RNG4[3:0]/VFB_STEP_RNG3[3:0] ;
0x33E6,0x11,//VFB_STEP_RNG2[3:0]/VFB_STEP_RNG1[3:0] ;
0x33E7,0x8E,//FBC_SUSP_CND[1:0]/-/EN_PS_VREFI_FB[4:0] ;
0x33E8,0x00,//-/PS_VFB_10B_RNG4[6:0] ;
0x33E9,0x00,//-/PS_VFB_10B_RNG3[6:0] ;
0x33EA,0x00,//-/PS_VFB_10B_RNG2[6:0] ;
0x33EB,0x00,//-/PS_VFB_10B_RNG1[6:0] ;
0x33EC,0x00,//-/PS_VFB_M10_RNG4[6:0] ;
0x33ED,0x00,//-/PS_VFB_M10_RNG3[6:0] ;
0x33EE,0x00,//-/PS_VFB_M10_RNG2[6:0] ;
0x33EF,0x00,//-/PS_VFB_M10_RNG1[6:0] ;
0x33F0,0x00,//DCLAMP_ON/-/-/-/-/-/DCLAMP_CND[1:0] ;
0x33F1,0x06,//GBL_HCNT_MAX_SEL[1:0]/GBLESTGRESET_U[5:0] ;
0x33F2,0x00,//-/-/-/-/-/-/GBLESTGRESET_W[9:8] ;
0x33F3,0x37,//GBLESTGRESET_W[7:0] ;
0x33F4,0x00,//-/-/-/-/-/-/-/GBLESREAD_1W[8] ;
0x33F5,0x27,//GBLESREAD_1W[7:0] ;
0x33F6,0x00,//-/-/-/-/-/-/-/GBLESREAD_1D[8] ;
0x33F7,0x14,//GBLESREAD_1D[7:0] ;
0x33F8,0x00,//-/-/-/-/-/-/-/GBLESREAD_2W[8] ;
0x33F9,0x38,//GBLESREAD_2W[7:0] ;
0x33FA,0x00,//-/-/-/-/GBLESREAD_2D[3:0] ;
0x33FC,0x00,//-/-/ST_CKI[5:0] ;
0x33FD,0x00,//BSOUT_EN/MONI_BCODE_SEL/BSCODE_CALC_ON/BSCODE_CALC_MODE/BSOUT_MSB/;
0x33FE,0x30,//ST_BLACK_LEVEL[7:0] ;
0x33FF,0x00,//ST_RSVD_REG[7:0] ;
0x3600,0x00,//[RO] -/-/-/-/ob_ave[11:8] ;
0x3601,0x00,//[RO] ob_ave[7:0] ;
0x3602,0x04,//[RO] -/-/-/-/agadj_coef[11:8] ;
0x3603,0x00,//[RO] agadj_coef[7:0] ;
0x3604,0x00,//[RO] -/-/-/-/-/-/vrefi_zs[9:8] ;
0x3605,0x00,//[RO] vrefi_zs[7:0] ;
0x3606,0x00,//[RO] -/-/-/-/-/-/vrefi_fb[9:8] ;
0x3607,0x00,//[RO] vrefi_fb[7:0] ;
0x3608,0x00,//[RO] -/-/-/zsv_operation/-/-/-/fbc_operation ;
0x3609,0x03,//[RO] -/-/-/-/-/-/vref_code[9:8] ;
0x360A,0xFF,//[RO] vref_code[7:0] ;
0x360B,0x00,//[RO] -/-/-/-/-/tdac_c1val[10:8] ;
0x360C,0x00,//[RO] tdac_c1val[7:0] ;
0x360D,0x00,//[RO] -/-/-/-/-/tdac_c2val[10:8] ;
0x360E,0x00,//[RO] tdac_c2val[7:0] ;
0x360F,0x00,//[RO] -/-/-/-/hcnt_max[19:16] ;
0x3610,0x0D,//[RO] hcnt_max[15:8] ;
0x3611,0x80,//[RO] hcnt_max[7:0] ;
0x3612,0x00,//[RO] tstr_vreg_exp[7:0] ;
0x3613,0x00,//[RO] -/-/-/-/num_bloom_gb[11:8] ;
0x3614,0x00,//[RO] num_bloom_gb[7:0] ;
0x3615,0x00,//[RO] -/-/-/-/num_bloom_rg[11:8] ;
0x3616,0x00,//[RO] num_bloom_rg[7:0] ;
0x3617,0x00,//[RO] -/-/-/-/ob_ave_last[11:8] ;
0x3618,0x00,//[RO] ob_ave_last[7:0] ;
0x3619,0x55,//[RO] freq_ck_st[7:0] ;
0x361A,0x2A,//[RO] freq_ck_sp[7:0] ;
0x3500,0x00,//DFCT_TYP0[2:0]/DFCT_XADR0[12:8] ;
0x3501,0x00,//DFCT_XADR0[7:0] ;
0x3502,0x00,//-/-/-/-/DFCT_YADR0[11:8] ;
0x3503,0x00,//DFCT_YADR0[7:0] ;
0x3504,0x00,//DFCT_TYP1[2:0]/DFCT_XADR1[12:8] ;
0x3505,0x00,//DFCT_XADR1[7:0] ;
0x3506,0x00,//-/-/-/-/DFCT_YADR1[11:8] ;
0x3507,0x00,//DFCT_YADR1[7:0] ;
0x3508,0x00,//DFCT_TYP2[2:0]/DFCT_XADR2[12:8] ;
0x3509,0x00,//DFCT_XADR2[7:0] ;
0x350A,0x00,//-/-/-/-/DFCT_YADR2[11:8] ;
0x350B,0x00,//DFCT_YADR2[7:0] ;
0x350C,0x00,//DFCT_TYP3[2:0]/DFCT_XADR3[12:8] ;
0x350D,0x00,//DFCT_XADR3[7:0] ;
0x350E,0x00,//-/-/-/-/DFCT_YADR3[11:8] ;
0x350F,0x00,//DFCT_YADR3[7:0] ;
0x3510,0x00,//DFCT_TYP4[2:0]/DFCT_XADR4[12:8] ;
0x3511,0x00,//DFCT_XADR4[7:0] ;
0x3512,0x00,//-/-/-/-/DFCT_YADR4[11:8] ;
0x3513,0x00,//DFCT_YADR4[7:0] ;
0x3514,0x00,//DFCT_TYP5[2:0]/DFCT_XADR5[12:8] ;
0x3515,0x00,//DFCT_XADR5[7:0] ;
0x3516,0x00,//-/-/-/-/DFCT_YADR5[11:8] ;
0x3517,0x00,//DFCT_YADR5[7:0] ;
0x3518,0x00,//DFCT_TYP6[2:0]/DFCT_XADR6[12:8] ;
0x3519,0x00,//DFCT_XADR6[7:0] ;
0x351A,0x00,//-/-/-/-/DFCT_YADR6[11:8] ;
0x351B,0x00,//DFCT_YADR6[7:0] ;
0x351C,0x00,//DFCT_TYP7[2:0]/DFCT_XADR7[12:8] ;
0x351D,0x00,//DFCT_XADR7[7:0] ;
0x351E,0x00,//-/-/-/-/DFCT_YADR7[11:8] ;
0x351F,0x00,//DFCT_YADR7[7:0] ;
0x3520,0x00,//DFCT_TYP8[2:0]/DFCT_XADR8[12:8] ;
0x3521,0x00,//DFCT_XADR8[7:0] ;
0x3522,0x00,//-/-/-/-/DFCT_YADR8[11:8] ;
0x3523,0x00,//DFCT_YADR8[7:0] ;
0x3524,0x00,//DFCT_TYP9[2:0]/DFCT_XADR9[12:8] ;
0x3525,0x00,//DFCT_XADR9[7:0] ;
0x3526,0x00,//-/-/-/-/DFCT_YADR9[11:8] ;
0x3527,0x00,//DFCT_YADR9[7:0] ;
0x3528,0x00,//DFCT_TYP10[2:0]/DFCT_XADR10[12:8] ;
0x3529,0x00,//DFCT_XADR10[7:0] ;
0x352A,0x00,//-/-/-/-/DFCT_YADR10[11:8] ;
0x352B,0x00,//DFCT_YADR10[7:0] ;
0x352C,0x00,//DFCT_TYP11[2:0]/DFCT_XADR11[12:8] ;
0x352D,0x00,//DFCT_XADR11[7:0] ;
0x352E,0x00,//-/-/-/-/DFCT_YADR11[11:8] ;
0x352F,0x00,//DFCT_YADR11[7:0] ;
0x3530,0x00,//DFCT_TYP12[2:0]/DFCT_XADR12[12:8] ;
0x3531,0x00,//DFCT_XADR12[7:0] ;
0x3532,0x00,//-/-/-/-/DFCT_YADR12[11:8] ;
0x3533,0x00,//DFCT_YADR12[7:0] ;
0x3534,0x00,//DFCT_TYP13[2:0]/DFCT_XADR13[12:8] ;
0x3535,0x00,//DFCT_XADR13[7:0] ;
0x3536,0x00,//-/-/-/-/DFCT_YADR13[11:8] ;
0x3537,0x00,//DFCT_YADR13[7:0] ;
0x3538,0x00,//DFCT_TYP14[2:0]/DFCT_XADR14[12:8] ;
0x3539,0x00,//DFCT_XADR14[7:0] ;
0x353A,0x00,//-/-/-/-/DFCT_YADR14[11:8] ;
0x353B,0x00,//DFCT_YADR14[7:0] ;
0x353C,0x00,//DFCT_TYP15[2:0]/DFCT_XADR15[12:8] ;
0x353D,0x00,//DFCT_XADR15[7:0] ;
0x353E,0x00,//-/-/-/-/DFCT_YADR15[11:8] ;
0x353F,0x00,//DFCT_YADR15[7:0] ;
0x3540,0x00,//DFCT_TYP16[2:0]/DFCT_XADR16[12:8] ;
0x3541,0x00,//DFCT_XADR16[7:0] ;
0x3542,0x00,//-/-/-/-/DFCT_YADR16[11:8] ;
0x3543,0x00,//DFCT_YADR16[7:0] ;
0x3544,0x00,//DFCT_TYP17[2:0]/DFCT_XADR17[12:8] ;
0x3545,0x00,//DFCT_XADR17[7:0] ;
0x3546,0x00,//-/-/-/-/DFCT_YADR17[11:8] ;
0x3547,0x00,//DFCT_YADR17[7:0] ;
0x3548,0x00,//DFCT_TYP18[2:0]/DFCT_XADR18[12:8] ;
0x3549,0x00,//DFCT_XADR18[7:0] ;
0x354A,0x00,//-/-/-/-/DFCT_YADR18[11:8] ;
0x354B,0x00,//DFCT_YADR18[7:0] ;
0x354C,0x00,//DFCT_TYP19[2:0]/DFCT_XADR19[12:8] ;
0x354D,0x00,//DFCT_XADR19[7:0] ;
0x354E,0x00,//-/-/-/-/DFCT_YADR19[11:8] ;
0x354F,0x00,//DFCT_YADR19[7:0] ;
0x3550,0x00,//DFCT_TYP20[2:0]/DFCT_XADR20[12:8] ;
0x3551,0x00,//DFCT_XADR20[7:0] ;
0x3552,0x00,//-/-/-/-/DFCT_YADR20[11:8] ;
0x3553,0x00,//DFCT_YADR20[7:0] ;
0x3554,0x00,//DFCT_TYP21[2:0]/DFCT_XADR21[12:8] ;
0x3555,0x00,//DFCT_XADR21[7:0] ;
0x3556,0x00,//-/-/-/-/DFCT_YADR21[11:8] ;
0x3557,0x00,//DFCT_YADR21[7:0] ;
0x3558,0x00,//DFCT_TYP22[2:0]/DFCT_XADR22[12:8] ;
0x3559,0x00,//DFCT_XADR22[7:0] ;
0x355A,0x00,//-/-/-/-/DFCT_YADR22[11:8] ;
0x355B,0x00,//DFCT_YADR22[7:0] ;
0x355C,0x00,//DFCT_TYP23[2:0]/DFCT_XADR23[12:8] ;
0x355D,0x00,//DFCT_XADR23[7:0] ;
0x355E,0x00,//-/-/-/-/DFCT_YADR23[11:8] ;
0x355F,0x00,//DFCT_YADR23[7:0] ;
0x3560,0x00,//DFCT_TYP24[2:0]/DFCT_XADR24[12:8] ;
0x3561,0x00,//DFCT_XADR24[7:0] ;
0x3562,0x00,//-/-/-/-/DFCT_YADR24[11:8] ;
0x3563,0x00,//DFCT_YADR24[7:0] ;
0x3564,0x00,//DFCT_TYP25[2:0]/DFCT_XADR25[12:8] ;
0x3565,0x00,//DFCT_XADR25[7:0] ;
0x3566,0x00,//-/-/-/-/DFCT_YADR25[11:8] ;
0x3567,0x00,//DFCT_YADR25[7:0] ;
0x3568,0x00,//DFCT_TYP26[2:0]/DFCT_XADR26[12:8] ;
0x3569,0x00,//DFCT_XADR26[7:0] ;
0x356A,0x00,//-/-/-/-/DFCT_YADR26[11:8] ;
0x356B,0x00,//DFCT_YADR26[7:0] ;
0x356C,0x00,//DFCT_TYP27[2:0]/DFCT_XADR27[12:8] ;
0x356D,0x00,//DFCT_XADR27[7:0] ;
0x356E,0x00,//-/-/-/-/DFCT_YADR27[11:8] ;
0x356F,0x00,//DFCT_YADR27[7:0] ;
0x3570,0x00,//DFCT_TYP28[2:0]/DFCT_XADR28[12:8] ;
0x3571,0x00,//DFCT_XADR28[7:0] ;
0x3572,0x00,//-/-/-/-/DFCT_YADR28[11:8] ;
0x3573,0x00,//DFCT_YADR28[7:0] ;
0x3574,0x00,//DFCT_TYP29[2:0]/DFCT_XADR29[12:8] ;
0x3575,0x00,//DFCT_XADR29[7:0] ;
0x3576,0x00,//-/-/-/-/DFCT_YADR29[11:8] ;
0x3577,0x00,//DFCT_YADR29[7:0] ;
0x3578,0x00,//DFCT_TYP30[2:0]/DFCT_XADR30[12:8] ;
0x3579,0x00,//DFCT_XADR30[7:0] ;
0x357A,0x00,//-/-/-/-/DFCT_YADR30[11:8] ;
0x357B,0x00,//DFCT_YADR30[7:0] ;
0x357C,0x00,//DFCT_TYP31[2:0]/DFCT_XADR31[12:8] ;
0x357D,0x00,//DFCT_XADR31[7:0] ;
0x357E,0x00,//-/-/-/-/DFCT_YADR31[11:8] ;
0x357F,0x00,//DFCT_YADR31[7:0] ;
0x3580,0x00,//DFCT_TYP32[2:0]/DFCT_XADR32[12:8] ;
0x3581,0x00,//DFCT_XADR32[7:0] ;
0x3582,0x00,//-/-/-/-/DFCT_YADR32[11:8] ;
0x3583,0x00,//DFCT_YADR32[7:0] ;
0x3584,0x00,//DFCT_TYP33[2:0]/DFCT_XADR33[12:8] ;
0x3585,0x00,//DFCT_XADR33[7:0] ;
0x3586,0x00,//-/-/-/-/DFCT_YADR33[11:8] ;
0x3587,0x00,//DFCT_YADR33[7:0] ;
0x3588,0x00,//DFCT_TYP34[2:0]/DFCT_XADR34[12:8] ;
0x3589,0x00,//DFCT_XADR34[7:0] ;
0x358A,0x00,//-/-/-/-/DFCT_YADR34[11:8] ;
0x358B,0x00,//DFCT_YADR34[7:0] ;
0x358C,0x00,//DFCT_TYP35[2:0]/DFCT_XADR35[12:8] ;
0x358D,0x00,//DFCT_XADR35[7:0] ;
0x358E,0x00,//-/-/-/-/DFCT_YADR35[11:8] ;
0x358F,0x00,//DFCT_YADR35[7:0] ;
0x3590,0x00,//DFCT_TYP36[2:0]/DFCT_XADR36[12:8] ;
0x3591,0x00,//DFCT_XADR36[7:0] ;
0x3592,0x00,//-/-/-/-/DFCT_YADR36[11:8] ;
0x3593,0x00,//DFCT_YADR36[7:0] ;
0x3594,0x00,//DFCT_TYP37[2:0]/DFCT_XADR37[12:8] ;
0x3595,0x00,//DFCT_XADR37[7:0] ;
0x3596,0x00,//-/-/-/-/DFCT_YADR37[11:8] ;
0x3597,0x00,//DFCT_YADR37[7:0] ;
0x3598,0x00,//DFCT_TYP38[2:0]/DFCT_XADR38[12:8] ;
0x3599,0x00,//DFCT_XADR38[7:0] ;
0x359A,0x00,//-/-/-/-/DFCT_YADR38[11:8] ;
0x359B,0x00,//DFCT_YADR38[7:0] ;
0x359C,0x00,//DFCT_TYP39[2:0]/DFCT_XADR39[12:8] ;
0x359D,0x00,//DFCT_XADR39[7:0] ;
0x359E,0x00,//-/-/-/-/DFCT_YADR39[11:8] ;
0x359F,0x00,//DFCT_YADR39[7:0] ;
0x35A0,0x00,//DFCT_TYP40[2:0]/DFCT_XADR40[12:8] ;
0x35A1,0x00,//DFCT_XADR40[7:0] ;
0x35A2,0x00,//-/-/-/-/DFCT_YADR40[11:8] ;
0x35A3,0x00,//DFCT_YADR40[7:0] ;
0x35A4,0x00,//DFCT_TYP41[2:0]/DFCT_XADR41[12:8] ;
0x35A5,0x00,//DFCT_XADR41[7:0] ;
0x35A6,0x00,//-/-/-/-/DFCT_YADR41[11:8] ;
0x35A7,0x00,//DFCT_YADR41[7:0] ;
0x35A8,0x00,//DFCT_TYP42[2:0]/DFCT_XADR42[12:8] ;
0x35A9,0x00,//DFCT_XADR42[7:0] ;
0x35AA,0x00,//-/-/-/-/DFCT_YADR42[11:8] ;
0x35AB,0x00,//DFCT_YADR42[7:0] ;
0x35AC,0x00,//DFCT_TYP43[2:0]/DFCT_XADR43[12:8] ;
0x35AD,0x00,//DFCT_XADR43[7:0] ;
0x35AE,0x00,//-/-/-/-/DFCT_YADR43[11:8] ;
0x35AF,0x00,//DFCT_YADR43[7:0] ;
0x35B0,0x00,//DFCT_TYP44[2:0]/DFCT_XADR44[12:8] ;
0x35B1,0x00,//DFCT_XADR44[7:0] ;
0x35B2,0x00,//-/-/-/-/DFCT_YADR44[11:8] ;
0x35B3,0x00,//DFCT_YADR44[7:0] ;
0x35B4,0x00,//DFCT_TYP45[2:0]/DFCT_XADR45[12:8] ;
0x35B5,0x00,//DFCT_XADR45[7:0] ;
0x35B6,0x00,//-/-/-/-/DFCT_YADR45[11:8] ;
0x35B7,0x00,//DFCT_YADR45[7:0] ;
0x35B8,0x00,//DFCT_TYP46[2:0]/DFCT_XADR46[12:8] ;
0x35B9,0x00,//DFCT_XADR46[7:0] ;
0x35BA,0x00,//-/-/-/-/DFCT_YADR46[11:8] ;
0x35BB,0x00,//DFCT_YADR46[7:0] ;
0x35BC,0x00,//DFCT_TYP47[2:0]/DFCT_XADR47[12:8] ;
0x35BD,0x00,//DFCT_XADR47[7:0] ;
0x35BE,0x00,//-/-/-/-/DFCT_YADR47[11:8] ;
0x35BF,0x00,//DFCT_YADR47[7:0] ;
0x35C0,0x00,//DFCT_TYP48[2:0]/DFCT_XADR48[12:8] ;
0x35C1,0x00,//DFCT_XADR48[7:0] ;
0x35C2,0x00,//-/-/-/-/DFCT_YADR48[11:8] ;
0x35C3,0x00,//DFCT_YADR48[7:0] ;
0x35C4,0x00,//DFCT_TYP49[2:0]/DFCT_XADR49[12:8] ;
0x35C5,0x00,//DFCT_XADR49[7:0] ;
0x35C6,0x00,//-/-/-/-/DFCT_YADR49[11:8] ;
0x35C7,0x00,//DFCT_YADR49[7:0] ;
0x35C8,0x00,//DFCT_TYP50[2:0]/DFCT_XADR50[12:8] ;
0x35C9,0x00,//DFCT_XADR50[7:0] ;
0x35CA,0x00,//-/-/-/-/DFCT_YADR50[11:8] ;
0x35CB,0x00,//DFCT_YADR50[7:0] ;
0x35CC,0x00,//DFCT_TYP51[2:0]/DFCT_XADR51[12:8] ;
0x35CD,0x00,//DFCT_XADR51[7:0] ;
0x35CE,0x00,//-/-/-/-/DFCT_YADR51[11:8] ;
0x35CF,0x00,//DFCT_YADR51[7:0] ;
0x35D0,0x00,//DFCT_TYP52[2:0]/DFCT_XADR52[12:8] ;
0x35D1,0x00,//DFCT_XADR52[7:0] ;
0x35D2,0x00,//-/-/-/-/DFCT_YADR52[11:8] ;
0x35D3,0x00,//DFCT_YADR52[7:0] ;
0x35D4,0x00,//DFCT_TYP53[2:0]/DFCT_XADR53[12:8] ;
0x35D5,0x00,//DFCT_XADR53[7:0] ;
0x35D6,0x00,//-/-/-/-/DFCT_YADR53[11:8] ;
0x35D7,0x00,//DFCT_YADR53[7:0] ;
0x35D8,0x00,//DFCT_TYP54[2:0]/DFCT_XADR54[12:8] ;
0x35D9,0x00,//DFCT_XADR54[7:0] ;
0x35DA,0x00,//-/-/-/-/DFCT_YADR54[11:8] ;
0x35DB,0x00,//DFCT_YADR54[7:0] ;
0x35DC,0x00,//DFCT_TYP55[2:0]/DFCT_XADR55[12:8] ;
0x35DD,0x00,//DFCT_XADR55[7:0] ;
0x35DE,0x00,//-/-/-/-/DFCT_YADR55[11:8] ;
0x35DF,0x00,//DFCT_YADR55[7:0] ;
0x35E0,0x00,//DFCT_TYP56[2:0]/DFCT_XADR56[12:8] ;
0x35E1,0x00,//DFCT_XADR56[7:0] ;
0x35E2,0x00,//-/-/-/-/DFCT_YADR56[11:8] ;
0x35E3,0x00,//DFCT_YADR56[7:0] ;
0x35E4,0x00,//DFCT_TYP57[2:0]/DFCT_XADR57[12:8] ;
0x35E5,0x00,//DFCT_XADR57[7:0] ;
0x35E6,0x00,//-/-/-/-/DFCT_YADR57[11:8] ;
0x35E7,0x00,//DFCT_YADR57[7:0] ;
0x35E8,0x00,//DFCT_TYP58[2:0]/DFCT_XADR58[12:8] ;
0x35E9,0x00,//DFCT_XADR58[7:0] ;
0x35EA,0x00,//-/-/-/-/DFCT_YADR58[11:8] ;
0x35EB,0x00,//DFCT_YADR58[7:0] ;
0x35EC,0x00,//DFCT_TYP59[2:0]/DFCT_XADR59[12:8] ;
0x35ED,0x00,//DFCT_XADR59[7:0] ;
0x35EE,0x00,//-/-/-/-/DFCT_YADR59[11:8] ;
0x35EF,0x00,//DFCT_YADR59[7:0] ;
0x35F0,0x00,//DFCT_TYP60[2:0]/DFCT_XADR60[12:8] ;
0x35F1,0x00,//DFCT_XADR60[7:0] ;
0x35F2,0x00,//-/-/-/-/DFCT_YADR60[11:8] ;
0x35F3,0x00,//DFCT_YADR60[7:0] ;
0x35F4,0x00,//DFCT_TYP61[2:0]/DFCT_XADR61[12:8] ;
0x35F5,0x00,//DFCT_XADR61[7:0] ;
0x35F6,0x00,//-/-/-/-/DFCT_YADR61[11:8] ;
0x35F7,0x00,//DFCT_YADR61[7:0] ;
0x35F8,0x00,//DFCT_TYP62[2:0]/DFCT_XADR62[12:8] ;
0x35F9,0x00,//DFCT_XADR62[7:0] ;
0x35FA,0x00,//-/-/-/-/DFCT_YADR62[11:8] ;
0x35FB,0x00,//DFCT_YADR62[7:0] ;
0x35FC,0x00,//DFCT_TYP63[2:0]/DFCT_XADR63[12:8] ;
0x35FD,0x00,//DFCT_XADR63[7:0] ;
0x35FE,0x00,//-/-/-/-/DFCT_YADR63[11:8] ;
0x35FF,0x00,//DFCT_YADR63[7:0] ;
0xA700,0x00,//-/-/-/-/-/-/DAC_CODE[9:8] ;
0xA701,0x00,//DAC_CODE[7:0] ;
0xA702,0x00,//-/-/MODE[1:0]/-/STEP[2:0] ;
0xA703,0x80,//SRST/-/-/-/-/-/-/- ;
0xA704,0x00,//T_DAC_FAST/-/T_AMP_FAST/-/BGR_TST/-/DC_TST/- ;
0xA705,0x00,//RSEL[3:0]/-/-/-/DACOUT_P_TST ;
0xA707,0x03,//-/-/-/-/-/-/VCMCK_DIV[1:0] ;
0xA709,0x00,//-/-/-/-/-/-/-/PD_X ;
0xA70A,0x00,//-/-/TEST_RSW/ADCCNT[4:0] ;
0xA70B,0x00,//-/-/-/-/-/-/ADCOUT[9:8] ;
0xA70C,0x00,//ADCOUT[7:0] ;
};
                                                                         
static struct regval_list sensor_8M_regs[] = {
// FPS = 30fps   Size = 3280x2464
0x0104,0x01,//-/-/-/-/-/-/-/GROUP_PARA_HOLD ;
0x0301,0x06,//-/-/-/-/VT_PIX_CLK_DIV[3:0] ;
0x0303,0x00,//-/-/-/-/VT_SYS_CLK_DIV[3:0] ;
0x0305,0x01,//-/-/-/-/-/PRE_PLL_CLK_DIV[2:0] ;
0x0306,0x00,//-/-/-/-/-/-/-/PLL_MULTIPLIER[8] ;
0x0307,0x41,//PLL_MULTIPLIER[7:0]  0x41:780Mbps 0x35:636Mbps 0x53:996Mbps 0x5b:1092Mbps
0x0309,0x08,//-/-/-/-/OP_PIX_CLK_DIV[3:0] ;
0x030B,0x00,//-/-/-/-/OP_SYS_CLK_DIV[3:0] ;
0x30AC,0x18,//MHZ_EXTCLK_TB[15:8] ;
0x30AD,0x00,//MHZ_EXTCLK_TB[7:0] ;
0x30AE,0x00,//-/-/-/-/-/-/-/PLL_MULT_ST[8] ;
0x30AF,0x41,//PLL_MULT_ST[7:0] ;
0x30B0,0x01,//-/-/-/-/-/PRE_PLL_CNTL_ST[2:0] ;
0x0340,0x09,//FR_LENGTH_LINES[15:8] ; 0x000b 
0x0341,0xce,//FR_LENGTH_LINES[7:0] ; 0x00b8
0x0342,0x0d,//LINE_LENGTH_PCK[15:8] ;0x001F 0x0017 0x001b 0x0e
0x0343,0x7e,//LINE_LENGTH_PCK[7:0] ;0x0040 0x0070  0x009a 0x74
0x0346,0x00,//Y_ADDR_START[15:8] ;
0x0347,0x00,//Y_ADDR_START[7:0] ;
0x034A,0x09,//Y_ADDR_END[15:8] ; 
0x034B,0x9f,//Y_ADDR_END[7:0] ;
0x034C,0x0c,//(3280>>8),//X_OUTPUT_SIZE[15:8] ; 0x000c
0x034D,0xd0,//(3280&0xff),//X_OUTPUT_SIZE[7:0] ; 0x00D0
0x034E,0x09,//(2464>>8),//Y_OUTPUT_SIZE[15:8] ; 0x0009
0x034F,0xa0,//(2464&0xff),//Y_OUTPUT_SIZE[7:0] ; 0x00A0
0x0350,0x00,//CONT_FRCNT[7:0] ;
0x0381,0x00,//-/-/-/-/-/-/H_MONI[1:0] ;
0x0382,0x00,//-/-/-/-/-/-/V_MONI[1:0] ;
0x0383,0x00,//-/-/-/-/-/-/BINNING_WEIGHTING[1:0] ;
0x0401,0x02,//-/-/-/-/-/-/SCALING_MODE[1:0] ;
0x0405,0x10,//(0xcd0/(3280>>4)),//SCALE_M[7:0] ;0x10: scale1:1
0x0408,0x00,//-/-/-/DCROP_XOFS[12:8] ;
0x0409,0x64,//DCROP_XOFS[7:0] ;
0x040A,0x00,//-/-/-/-/DCROP_YOFS[11:8] ;
0x040B,0x64,//DCROP_YOFS[7:0] ;
0x040C,0x0B,//-/-/-/DCROP_WIDTH[12:8] ;
0x040D,0xB8,//DCROP_WIDTH[7:0] ;
0x040E,0x08,//-/-/-/-/DCROP_HIGT[11:8] ;
0x040F,0x98,//DCROP_HIGT[7:0] ;
0x3030,0x00,//-/-/-/-/-/H_CROP[2:0] ;
0x321C,0x00,//-/-/-/-/-/-/-/DCROP_SEL ;
0x30A6,0x0B,//PLL_SNR_CNTL[1:0]/PLL_SYS_CNTL[1:0]/PLL_SINGLE_CKSP/PLL_SINGLE_SW/;
0x0104,0x00,//-/-/-/-/-/-/-/GROUP_PARA_HOLD ;

0x0800,0x80,//TCLK_POST[7:3]/-/-/- ; 
0x0801,0x10,//THS_PREPARE[7:3]/-/-/- ; 
0x0802,0x80,//THS_ZERO[7:3]/-/-/- ; 
0x0803,0xF0,//THS_TRAIL[7:3]/-/-/- ; 
0x0804,0xF8,//TCLK_TRAIL[7:3]/-/-/- ; 
0x0805,0x30,//TCLK_PREPARE[7:3]/-/-/- ; 
0x0806,0xF8,//TCLK_ZERO[7:3]/-/-/- ; 
0x0807,0x38,//TLPX[7:3]/-/-/- ; 

0x0808,0x00,//-/-/-/-/-/-/DPHY_CTRL[1:0] ;0x0000:auto control 0x0002:ctl by reg
0x0820,0x0c,//MSB_LBRATE[15:8] ; 0xfb8:1006Mbps x4 0x9f0: 636Mpbs x4 0xf90:996Mbps x4 0xc30 780Mbps x4
0x0821,0x30,//MSB_LBRATE[7:0] ;          

0x0112,0x0C,//CSI_DATA_FORMAT[15:8] ;
0x0113,0x0C,//CSI_DATA_FORMAT[7:0] ;
0x2112,0x0C,//CSI_DATA_FORMAT_1B[15:8] ;
0x2113,0x0C,//CSI_DATA_FORMAT_1B[7:0] ;

0x0114,0x00|(4-1),//-/-/-/-/-/-/CSI_LANE_MODE[1:0] ;
0x2114,0x00|(4-1),//-/-/-/-/-/-/CSI_LANE_MODE_1B[1:0] ;
0x3009,0x20&(~(0<<5)),//-/-/MIPI_CLK_MODE/CCP2BLKD/-/CCP2_4L/CCP2_3L/CCP2_2L ;
0x300A,0x00,//-/-/-/-/LVDS_CLK_DELAY[3:0] ;
0x300B,0x00,//LVDS_D1_DELAY[3:0]/LVDS_D2_DELAY[3:0] ;
0x300C,0x00,//LVDS_D3_DELAY[3:0]/LVDS_D4_DELAY[3:0] ;

//0x0601,0x01,//colorbar
0x0104,0x00,//-/-/-/-/-/-/-/GROUP_PARA_HOLD ;
0x0100,0x00,//-/-/-/-/-/-/-/MODE_SELECT;

//stream on
0x0100,0x01,//-/-/-/-/-/-/-/MODE_SELECT;
};

static struct regval_list sensor_1080p_regs[] = {
// Extclk= 24Mhz  SPCK = 260Mhz   MIPI CLK = 780MHz
// FPS = 30.15   Size = 1920x1080
//stream off
0x0100,0x00,//-/-/-/-/-/-/-/MODE_SELECT;

0x0104,0x01, //-/-/-/-/-/-/-/GROUP_PARA_HOLD ;
0x0301,0x06, //-/-/-/-/VT_PIX_CLK_DIV[3:0] ;
0x0303,0x00, //-/-/-/-/VT_SYS_CLK_DIV[3:0] ;
0x0305,0x01, //-/-/-/-/-/PRE_PLL_CLK_DIV[2:0] ;
0x0306,0x00, //-/-/-/-/-/-/-/PLL_MULTIPLIER[8] ;
0x0307,0x41, //PLL_MULTIPLIER[7:0] ;
0x0309,0x08, //-/-/-/-/OP_PIX_CLK_DIV[3:0] ;
0x030B,0x00, //-/-/-/-/OP_SYS_CLK_DIV[3:0] ;
0x30AC,0x18, //MHZ_EXTCLK_TB[15:8] ;
0x30AD,0x00, //MHZ_EXTCLK_TB[7:0] ;
0x30AE,0x00, //-/-/-/-/-/-/-/PLL_MULT_ST[8] ;
0x30AF,0x41, //PLL_MULT_ST[7:0] ;
0x30B0,0x01, //-/-/-/-/-/PRE_PLL_CNTL_ST[2:0] ;
0x0340,0x09, //FR_LENGTH_LINES[15:8] ;
0x0341,0xce, //FR_LENGTH_LINES[7:0] ;
0x0342,0x0D, //LINE_LENGTH_PCK[15:8] ;
0x0343,0x7E, //LINE_LENGTH_PCK[7:0] ;
0x0346,0x01, //Y_ADDR_START[15:8] ;
0x0347,0x34, //Y_ADDR_START[7:0] ;
0x034A,0x08, //Y_ADDR_END[15:8] ;
0x034B,0x6e, //Y_ADDR_END[7:0] ;
0x034C,0x07, //X_OUTPUT_SIZE[15:8] ;
0x034D,0x90, //X_OUTPUT_SIZE[7:0] ;
0x034E,0x04, //Y_OUTPUT_SIZE[15:8] ;
0x034F,0x48, //Y_OUTPUT_SIZE[7:0] ;
0x0350,0x00, //CONT_FRCNT[7:0] ;
0x0381,0x00, //-/-/-/-/-/-/H_MONI[1:0] ;
0x0382,0x00, //-/-/-/-/-/-/V_MONI[1:0] ;
0x0383,0x00, //-/-/-/-/-/-/BINNING_WEIGHTING[1:0] ;
0x0401,0x02, //-/-/-/-/-/-/SCALING_MODE[1:0] ;
0x0405,0x1B, //SCALE_M[7:0] ;
0x0408,0x00, //-/-/-/DCROP_XOFS[12:8] ;
0x0409,0x06, //DCROP_XOFS[7:0] ;
0x040A,0x00, //-/-/-/-/DCROP_YOFS[11:8] ;
0x040B,0x00, //DCROP_YOFS[7:0] ;
0x040C,0x0C, //-/-/-/DCROP_WIDTH[12:8] ;
0x040D,0xC4, //DCROP_WIDTH[7:0] ;
0x040E,0x07, //-/-/-/-/DCROP_HIGT[11:8] ;
0x040F,0x3A, //DCROP_HIGT[7:0] ;
0x3030,0x00, //-/-/-/-/-/H_CROP[2:0] ;
0x321C,0x01, //-/-/-/-/-/-/-/DCROP_SEL ;
0x30A6,0x0B, //PLL_SNR_CNTL[1:0]/PLL_SYS_CNTL[1:0]/PLL_SINGLE_CKSP/PLL_SINGLE_SW/;
0x0104,0x00, //-/-/-/-/-/-/-/GROUP_PARA_HOLD ;
0x0800,0x80, //TCLK_POST[7:3]/-/-/- ;
0x0801,0x18, //THS_PREPARE[7:3]/-/-/- ;
0x0802,0x80, //THS_ZERO[7:3]/-/-/- ;
0x0803,0xF0, //THS_TRAIL[7:3]/-/-/- ;
0x0804,0xF8, //TCLK_TRAIL[7:3]/-/-/- ;
0x0805,0x30, //TCLK_PREPARE[7:3]/-/-/- ;
0x0806,0xF8, //TCLK_ZERO[7:3]/-/-/- ;
0x0807,0x38, //TLPX[7:3]/-/-/- ;
0x0808,0x00, //-/-/-/-/-/-/DPHY_CTRL[1:0] ;
0x0820,0x0C, //MSB_LBRATE[15:8] ;
0x0821,0x30, //MSB_LBRATE[7:0] ;
0x0112,0x0C, //CSI_DATA_FORMAT[15:8] ;
0x0113,0x0C, //CSI_DATA_FORMAT[7:0] ;
0x0114,0x03, //-/-/-/-/-/-/CSI_LANE_MODE[1:0] ;
0x2112,0x0C, //CSI_DATA_FORMAT_1B[15:8] ;
0x2113,0x0C, //CSI_DATA_FORMAT_1B[7:0] ;
0x2114,0x03, //-/-/-/-/-/-/CSI_LANE_MODE_1B[1:0] ;
0x3009,0x00, //-/-/MIPI_CLK_MODE/CCP2BLKD/-/CCP2_4L/CCP2_3L/CCP2_2L ;
0x300A,0x00, //-/-/-/-/LVDS_CLK_DELAY[3:0] ;
0x300B,0x00, //LVDS_D1_DELAY[3:0]/LVDS_D2_DELAY[3:0] ;
0x300C,0x00, //LVDS_D3_DELAY[3:0]/LVDS_D4_DELAY[3:0] ;
0x0104,0x00, //-/-/-/-/-/-/-/GROUP_PARA_HOLD ;

//stream on
0x0100,0x01,//-/-/-/-/-/-/-/MODE_SELECT;
};

static struct regval_list sensor_1080p_crop_regs[] = {
// Extclk= 24Mhz  SPCK = 260Mhz   MIPI CLK = 780MHz
// FPS = 60.15   Size = 1920x1080
//stream off
0x0100,0x00,//-/-/-/-/-/-/-/MODE_SELECT;

0x0104,0x01, //-/-/-/-/-/-/-/GROUP_PARA_HOLD ;
0x0301,0x06, //-/-/-/-/VT_PIX_CLK_DIV[3:0] ;
0x0303,0x00, //-/-/-/-/VT_SYS_CLK_DIV[3:0] ;
0x0305,0x01, //-/-/-/-/-/PRE_PLL_CLK_DIV[2:0] ;
0x0306,0x00, //-/-/-/-/-/-/-/PLL_MULTIPLIER[8] ;
0x0307,0x41, //PLL_MULTIPLIER[7:0] ;
0x0309,0x08, //-/-/-/-/OP_PIX_CLK_DIV[3:0] ;
0x030B,0x00, //-/-/-/-/OP_SYS_CLK_DIV[3:0] ;
0x30AC,0x18, //MHZ_EXTCLK_TB[15:8] ;
0x30AD,0x00, //MHZ_EXTCLK_TB[7:0] ;
0x30AE,0x00, //-/-/-/-/-/-/-/PLL_MULT_ST[8] ;
0x30AF,0x41, //PLL_MULT_ST[7:0] ;
0x30B0,0x01, //-/-/-/-/-/PRE_PLL_CNTL_ST[2:0] ;
0x0340,0x04, //FR_LENGTH_LINES[15:8] ; //vts = 1235    60fps: hts * vts = 4333333
0x0341,0xd3, //FR_LENGTH_LINES[7:0] ;
0x0342,0x0d, //LINE_LENGTH_PCK[15:8] ; //hts = 3500
0x0343,0xac, //LINE_LENGTH_PCK[7:0] ;
0x0346,0x02, //Y_ADDR_START[15:8] ; //sensor out height = 1156
0x0347,0xAC, //Y_ADDR_START[7:0] ;
0x034A,0x06, //Y_ADDR_END[15:8] ;
0x034B,0xF4, //Y_ADDR_END[7:0] ;
0x034C,0x07, //X_OUTPUT_SIZE[15:8] ;
0x034D,0x90, //X_OUTPUT_SIZE[7:0] ;
0x034E,0x04, //Y_OUTPUT_SIZE[15:8] ;
0x034F,0x48, //Y_OUTPUT_SIZE[7:0] ;
0x0350,0x00, //CONT_FRCNT[7:0] ;
0x0381,0x00, //-/-/-/-/-/-/H_MONI[1:0] ;
0x0382,0x00, //-/-/-/-/-/-/V_MONI[1:0] ;
0x0383,0x00, //-/-/-/-/-/-/BINNING_WEIGHTING[1:0] ;
0x0401,0x00, //-/-/-/-/-/-/SCALING_MODE[1:0] ;
0x0405,0x10, //SCALE_M[7:0] ;
0x0408,0x01, //-/-/-/DCROP_XOFS[12:8] ;
0x0409,0x44, //DCROP_XOFS[7:0] ;
0x040A,0x00, //-/-/-/-/DCROP_YOFS[11:8] ;
0x040B,0x00, //DCROP_YOFS[7:0] ;
0x040C,0x07, //-/-/-/DCROP_WIDTH[12:8] ;
0x040D,0x90, //DCROP_WIDTH[7:0] ;
0x040E,0x04, //-/-/-/-/DCROP_HIGT[11:8] ;
0x040F,0x48, //DCROP_HIGT[7:0] ;
0x3030,0x03, //-/-/-/-/-/H_CROP[2:0] ; //sensor out width = 2584
0x321C,0x01, //-/-/-/-/-/-/-/DCROP_SEL ;
0x30A6,0x0B, //PLL_SNR_CNTL[1:0]/PLL_SYS_CNTL[1:0]/PLL_SINGLE_CKSP/PLL_SINGLE_SW/;
0x0104,0x00, //-/-/-/-/-/-/-/GROUP_PARA_HOLD ;
0x0800,0x80, //TCLK_POST[7:3]/-/-/- ;
0x0801,0x18, //THS_PREPARE[7:3]/-/-/- ;
0x0802,0x80, //THS_ZERO[7:3]/-/-/- ;
0x0803,0xF0, //THS_TRAIL[7:3]/-/-/- ;
0x0804,0xF8, //TCLK_TRAIL[7:3]/-/-/- ;
0x0805,0x30, //TCLK_PREPARE[7:3]/-/-/- ;
0x0806,0xF8, //TCLK_ZERO[7:3]/-/-/- ;
0x0807,0x38, //TLPX[7:3]/-/-/- ;
0x0808,0x00, //-/-/-/-/-/-/DPHY_CTRL[1:0] ;
0x0820,0x0C, //MSB_LBRATE[15:8] ;
0x0821,0x30, //MSB_LBRATE[7:0] ;
0x0112,0x0C, //CSI_DATA_FORMAT[15:8] ;
0x0113,0x0C, //CSI_DATA_FORMAT[7:0] ;
0x0114,0x03, //-/-/-/-/-/-/CSI_LANE_MODE[1:0] ;
0x2112,0x0C, //CSI_DATA_FORMAT_1B[15:8] ;
0x2113,0x0C, //CSI_DATA_FORMAT_1B[7:0] ;
0x2114,0x03, //-/-/-/-/-/-/CSI_LANE_MODE_1B[1:0] ;
0x3009,0x00, //-/-/MIPI_CLK_MODE/CCP2BLKD/-/CCP2_4L/CCP2_3L/CCP2_2L ;
0x300A,0x00, //-/-/-/-/LVDS_CLK_DELAY[3:0] ;
0x300B,0x00, //LVDS_D1_DELAY[3:0]/LVDS_D2_DELAY[3:0] ;
0x300C,0x00, //LVDS_D3_DELAY[3:0]/LVDS_D4_DELAY[3:0] ;
0x0104,0x00, //-/-/-/-/-/-/-/GROUP_PARA_HOLD ;

//stream on
0x0100,0x01,//-/-/-/-/-/-/-/MODE_SELECT;
};

//misc
static struct regval_list sensor_oe_disable_regs[] = {

};

static struct regval_list sensor_oe_enable_regs[] = {

};

/*
 * Here we'll try to encapsulate the changes for just the output
 * video format.
 * 
 */

static struct regval_list sensor_fmt_raw[] = {

};

/*
 * Low-level register I/O.
 *
 */


/*
 * On most platforms, we'd rather do straight i2c I/O.
 */
static int sensor_read(struct v4l2_subdev *sd, unsigned short reg,
    unsigned char *value) //!!!!be careful of the para type!!!
{
	int ret=0;
	int cnt=0;
	
  ret = cci_read_a16_d8(sd,reg,value);
  while(ret!=0&&cnt<2)
  {
  	ret = cci_read_a16_d8(sd,reg,value);
  	cnt++;
  }
  if(cnt>0)
  	vfe_dev_dbg("sensor read retry=%d\n",cnt);
  
  return ret;
}

static int sensor_write(struct v4l2_subdev *sd, unsigned short reg,
    unsigned char value)
{
	int ret=0;
	int cnt=0;
	
  ret = cci_write_a16_d8(sd,reg,value);
  while(ret!=0&&cnt<2)
  {
  	ret = cci_write_a16_d8(sd,reg,value);
  	cnt++;
  }
  if(cnt>0)
  	vfe_dev_dbg("sensor write retry=%d\n",cnt);
  
  return ret;
}

/*
 * Write a list of register settings;
 */
static int sensor_write_array(struct v4l2_subdev *sd, struct regval_list *regs, int array_size)
{
	int i=0;
	
  if(!regs)
  	return 0;
  
  while(i<array_size)
  {
    if(regs->addr == REG_DLY) {
      msleep(regs->data);
    } 
    else {
      LOG_ERR_RET(sensor_write(sd, regs->addr, regs->data))
    }
    i++;
    regs++;
  }
  return 0;
}

/* 
 * Code for dealing with controls.
 * fill with different sensor module
 * different sensor module has different settings here
 * if not support the follow function ,retrun -EINVAL
 */

/* *********************************************begin of ******************************************** */
/*
static int sensor_g_hflip(struct v4l2_subdev *sd, __s32 *value)
{
  struct sensor_info *info = to_state(sd);
  unsigned char rdval;
    
  LOG_ERR_RET(sensor_read(sd, 0x3821, &rdval))
  
  rdval &= (1<<1);
  rdval >>= 1;
    
  *value = rdval;

  info->hflip = *value;
  return 0;
}

static int sensor_s_hflip(struct v4l2_subdev *sd, int value)
{
  struct sensor_info *info = to_state(sd);
  unsigned char rdval;
  
  if(info->hflip == value)
    return 0;
    
  LOG_ERR_RET(sensor_read(sd, 0x3821, &rdval))
  
  switch (value) {
    case 0:
      rdval &= 0xf9;
      break;
    case 1:
      rdval |= 0x06;
      break;
    default:
      return -EINVAL;
  }
  
  LOG_ERR_RET(sensor_write(sd, 0x3821, rdval))
  
  mdelay(10);
  info->hflip = value;
  return 0;
}

static int sensor_g_vflip(struct v4l2_subdev *sd, __s32 *value)
{
  struct sensor_info *info = to_state(sd);
  unsigned char rdval;
  
  LOG_ERR_RET(sensor_read(sd, 0x3820, &rdval))
  
  rdval &= (1<<1);  
  *value = rdval;
  rdval >>= 1;
  
  info->vflip = *value;
  return 0;
}

static int sensor_s_vflip(struct v4l2_subdev *sd, int value)
{
  struct sensor_info *info = to_state(sd);
  unsigned char rdval;
  
  if(info->vflip == value)
    return 0;
  
  LOG_ERR_RET(sensor_read(sd, 0x3820, &rdval))

  switch (value) {
    case 0:
      rdval &= 0xf9;
      break;
    case 1:
      rdval |= 0x06;
      break;
    default:
      return -EINVAL;
  }

  LOG_ERR_RET(sensor_write(sd, 0x3820, rdval))
  
  mdelay(10);
  info->vflip = value;
  return 0;
}
*/
static int sensor_g_exp(struct v4l2_subdev *sd, __s32 *value)
{
	struct sensor_info *info = to_state(sd);
	unsigned char explow,exphigh;
	unsigned int exp_tmp;
	
	sensor_read(sd, 0x0202, &exphigh);	
	sensor_read(sd, 0x0203, &explow);
	
	exp_tmp = ((exphigh<<8) + explow)<<4;
	
	info->exp = exp_tmp;
	*value = info->exp;
	vfe_dev_dbg("sensor_get_exposure = %d\n", info->exp);
	return 0;
}

static int sensor_s_exp(struct v4l2_subdev *sd, unsigned int exp_val)
{
	struct sensor_info *info = to_state(sd);
	unsigned char explow,exphigh;
	unsigned int exp_tmp;

	vfe_dev_dbg("sensor_set_exposure = %d\n", exp_val);
	
	//max 
	if(exp_val > 0xffffff)
		exp_val = 0xffff00;
	
	//min	= 1
	if(exp_val < 16)
		exp_val = 16;
	
	exp_tmp=(exp_val+8)>>4;//rounding to 1
	
	vfe_dev_dbg("sensor_set_exposure real= %d\n", exp_tmp);
	
	if(info->exp == exp_tmp)
		return 0;
  
  exphigh = (unsigned char) ( (0xff00&exp_tmp)>>8);
  explow  = (unsigned char) ( (0x00ff&exp_tmp) );
	
	sensor_write(sd, 0x0202, exphigh);	
	sensor_write(sd, 0x0203, explow);

	info->exp = exp_tmp;
	return 0;
}

static int sensor_g_gain(struct v4l2_subdev *sd, __s32 *value)
{
	struct sensor_info *info = to_state(sd);
	unsigned char gainlow=0;
	unsigned char gainhigh=0;
	unsigned int gain_tmp;
	
	sensor_read(sd, 0x0208, &gainhigh);
	sensor_read(sd, 0x0209, &gainlow);
	
	gain_tmp = ((gainhigh<<8) + gainlow)<<4;
	
	info->gain = gain_tmp;
	*value = info->gain;
	
	vfe_dev_dbg("sensor_get_gain = %d\n", info->gain);
	return 0;
}

static int sensor_s_gain(struct v4l2_subdev *sd, int gain_val)
{
	struct sensor_info *info = to_state(sd);
	unsigned char gainlow=0;
	unsigned char gainhigh=0;
	unsigned int gain_tmp;
	
	vfe_dev_dbg("sensor_set_gain = %d\n", gain_val);
	
	if(gain_val < (1<<4)) //min gain = 1x
	  gain_val = (1<<4);
	
	if(info->gain == gain_val)
		return 0;
	
	gain_tmp=((gain_val)*65)>>4;	
	gainlow=(unsigned char)(gain_tmp&0xff);
	gainhigh=(unsigned char)((gain_tmp>>8)&0xff);
	
	sensor_write(sd, 0x0208, gainhigh);
	sensor_write(sd, 0x0209, gainlow);
	
	info->gain = gain_val;
	
	return 0;
}

static int sensor_s_sw_stby(struct v4l2_subdev *sd, int on_off)
{
//	int ret;
//	unsigned char rdval;
//	
//	ret=sensor_read(sd, 0x00, &rdval);
//	if(ret!=0)
//		return ret;
//	
//	if(on_off!=0)//sw stby on
//	{
//		ret=sensor_write(sd, 0x00, rdval&0x7f);
//	}
//	else//sw stby off
//	{
//		ret=sensor_write(sd, 0x00, rdval|0x80);
//	}
//	return ret;
}

/*
 * Stuff that knows about the sensor.
 */
 
static int sensor_power(struct v4l2_subdev *sd, int on)
{
  int ret;
  
  //insure that clk_disable() and clk_enable() are called in pair 
  //when calling CSI_SUBDEV_STBY_ON/OFF and CSI_SUBDEV_PWR_ON/OFF
  ret = 0;
  switch(on)
  {
    case CSI_SUBDEV_STBY_ON:
      vfe_dev_dbg("CSI_SUBDEV_STBY_ON!\n");
//      //disable io oe
//      vfe_dev_print("disalbe oe!\n");
//      ret = sensor_write_array(sd, sensor_oe_disable_regs, ARRAY_SIZE(sensor_oe_disable_regs));
//      if(ret < 0)
//        vfe_dev_err("disalbe oe falied!\n");
      //software standby on
      ret = sensor_s_sw_stby(sd, CSI_STBY_ON);
      if(ret < 0)
        vfe_dev_err("soft stby falied!\n");
      mdelay(10);
      //make sure that no device can access i2c bus during sensor initial or power down
      //when using i2c_lock_adpater function, the following codes must not access i2c bus before calling i2c_unlock_adapter
      cci_lock(sd);
      //standby on io
      vfe_gpio_write(sd,PWDN,CSI_STBY_ON);
      //remember to unlock i2c adapter, so the device can access the i2c bus again
      cci_unlock(sd);  
      //inactive mclk after stadby in
      vfe_set_mclk(sd,OFF);
      break;
    case CSI_SUBDEV_STBY_OFF:
      vfe_dev_dbg("CSI_SUBDEV_STBY_OFF!\n");
      //make sure that no device can access i2c bus during sensor initial or power down
      //when using i2c_lock_adpater function, the following codes must not access i2c bus before calling i2c_unlock_adapter
      cci_lock(sd);    
      //active mclk before stadby out
      vfe_set_mclk_freq(sd,MCLK);
      vfe_set_mclk(sd,ON);
      mdelay(10);
      //standby off io
      vfe_gpio_write(sd,PWDN,CSI_STBY_OFF);
      mdelay(10);
      //remember to unlock i2c adapter, so the device can access the i2c bus again
      cci_unlock(sd);        
      //software standby
      ret = sensor_s_sw_stby(sd, CSI_STBY_OFF);
      if(ret < 0)
        vfe_dev_err("soft stby off falied!\n");
      mdelay(10);
//      vfe_dev_print("enable oe!\n");
//      ret = sensor_write_array(sd, sensor_oe_enable_regs);
//      if(ret < 0)
//        vfe_dev_err("enable oe falied!\n");
      break;
    case CSI_SUBDEV_PWR_ON:
      vfe_dev_dbg("CSI_SUBDEV_PWR_ON!\n");
      //make sure that no device can access i2c bus during sensor initial or power down
      //when using i2c_lock_adpater function, the following codes must not access i2c bus before calling i2c_unlock_adapter
      cci_lock(sd);
      //power on reset
      vfe_gpio_set_status(sd,PWDN,1);//set the gpio to output
      vfe_gpio_set_status(sd,RESET,1);//set the gpio to output
      //power down io
      vfe_gpio_write(sd,PWDN,CSI_STBY_ON);
      //reset on io
      vfe_gpio_write(sd,RESET,CSI_RST_ON);
      mdelay(1);
      //active mclk before power on
      vfe_set_mclk_freq(sd,MCLK);
      vfe_set_mclk(sd,ON);
      mdelay(10);
      //power supply
      vfe_gpio_write(sd,POWER_EN,CSI_PWR_ON);
      vfe_set_pmu_channel(sd,IOVDD,ON);
      vfe_set_pmu_channel(sd,AVDD,ON);
      vfe_set_pmu_channel(sd,DVDD,ON);
      vfe_set_pmu_channel(sd,AFVDD,ON);
      //standby off io
      vfe_gpio_write(sd,PWDN,CSI_STBY_OFF);
      mdelay(10);
      //reset after power on
      vfe_gpio_write(sd,RESET,CSI_RST_OFF);
      mdelay(30);
      //remember to unlock i2c adapter, so the device can access the i2c bus again
      cci_unlock(sd);  
      break;
    case CSI_SUBDEV_PWR_OFF:
      vfe_dev_dbg("CSI_SUBDEV_PWR_OFF!\n");
      //make sure that no device can access i2c bus during sensor initial or power down
      //when using i2c_lock_adpater function, the following codes must not access i2c bus before calling i2c_unlock_adapter
      cci_lock(sd);
      //inactive mclk before power off
      vfe_set_mclk(sd,OFF);
      //power supply off
      vfe_gpio_write(sd,POWER_EN,CSI_PWR_OFF);
      vfe_set_pmu_channel(sd,AFVDD,OFF);
      vfe_set_pmu_channel(sd,DVDD,OFF);
      vfe_set_pmu_channel(sd,AVDD,OFF);
      vfe_set_pmu_channel(sd,IOVDD,OFF);  
      //standby and reset io
      mdelay(10);
      vfe_gpio_write(sd,POWER_EN,CSI_STBY_OFF);
      vfe_gpio_write(sd,RESET,CSI_RST_ON);
      //set the io to hi-z
      vfe_gpio_set_status(sd,RESET,0);//set the gpio to input
      vfe_gpio_set_status(sd,PWDN,0);//set the gpio to input
      //remember to unlock i2c adapter, so the device can access the i2c bus again
      cci_unlock(sd);  
      break;
    default:
      return -EINVAL;
  }   

  return 0;
}
 
static int sensor_reset(struct v4l2_subdev *sd, u32 val)
{
  switch(val)
  {
    case 0:
      vfe_gpio_write(sd,RESET,CSI_RST_OFF);
      mdelay(10);
      break;
    case 1:
      vfe_gpio_write(sd,RESET,CSI_RST_ON);
      mdelay(10);
      break;
    default:
      return -EINVAL;
  }
    
  return 0;
}

static int sensor_detect(struct v4l2_subdev *sd)
{
  unsigned char rdval;
  
  LOG_ERR_RET(sensor_read(sd, 0x0000, &rdval))
  vfe_dev_dbg("sensor read id=0x%x\n",rdval);
  if(rdval != 0x14)
    return -ENODEV;
 	
 	LOG_ERR_RET(sensor_read(sd, 0x0001, &rdval))
  vfe_dev_dbg("sensor read id=0x%x\n",rdval);
  if(rdval != 0x61)
    return -ENODEV;
 	
  return 0;
}

static int sensor_init(struct v4l2_subdev *sd, u32 val)
{
  int ret;
  struct sensor_info *info = to_state(sd);
  
  vfe_dev_dbg("sensor_init\n");
  
  /*Make sure it is a target sensor*/
  ret = sensor_detect(sd);
  if (ret) {
    vfe_dev_err("chip found is not an target chip.\n");
    return ret;
  }
  
  vfe_get_standby_mode(sd,&info->stby_mode);
  
  if((info->stby_mode == HW_STBY || info->stby_mode == SW_STBY) \
      && info->init_first_flag == 0) {
    vfe_dev_print("stby_mode and init_first_flag = 0\n");
    return 0;
  } 
  
  info->focus_status = 0;
  info->low_speed = 0;
  info->width = QSXGA_WIDTH;
  info->height = QSXGA_HEIGHT;
  info->hflip = 0;
  info->vflip = 0;
  info->gain = 0;

  info->tpf.numerator = 1;            
  info->tpf.denominator = 15;    /* 30fps */    
  
  ret = sensor_write_array(sd, sensor_default_regs, ARRAY_SIZE(sensor_default_regs));  
  if(ret < 0) {
    vfe_dev_err("write sensor_default_regs error\n");
    return ret;
  }
  
  if(info->stby_mode == 0)
    info->init_first_flag = 0;
  
  info->preview_first_flag = 1;
  
  return 0;
}

static long sensor_ioctl(struct v4l2_subdev *sd, unsigned int cmd, void *arg)
{
  int ret=0;
  struct sensor_info *info = to_state(sd);
  vfe_dev_dbg("cmd=%d\n",cmd);
  vfe_dev_dbg("arg=%0x\n",arg);
  switch(cmd) {
    case GET_CURRENT_WIN_CFG:
      if(info->current_wins != NULL)
      {
        memcpy( arg,
                info->current_wins,
                sizeof(struct sensor_win_size) );
        ret=0;
      }
      else
      {
        vfe_dev_err("empty wins!\n");
        ret=-1;
      }
      break;
    default:
      return -EINVAL;
  }
  return ret;
}


/*
 * Store information about the video data format. 
 */
static struct sensor_format_struct {
  __u8 *desc;
  //__u32 pixelformat;
  enum v4l2_mbus_pixelcode mbus_code;
  struct regval_list *regs;
  int regs_size;
  int bpp;   /* Bytes per pixel */
}sensor_formats[] = {
	{
		.desc				= "Raw RGB Bayer",
		.mbus_code	= V4L2_MBUS_FMT_SGRBG12_12X1,
		.regs 			= sensor_fmt_raw,
		.regs_size 	= ARRAY_SIZE(sensor_fmt_raw),
		.bpp				= 1
	},
};
#define N_FMTS ARRAY_SIZE(sensor_formats)

  

/*
 * Then there is the issue of window sizes.  Try to capture the info here.
 */


static struct sensor_win_size sensor_win_sizes[] = {
	  /* 8M: 3280*2464 */
	  {
      .width      = 3280,
      .height     = 2464,
      .hoffset    = 0,
      .voffset    = 0,
      .hts        = 3454,
      .vts        = 2510,
      .pclk       = 260*1000*1000,
      .mipi_bps		= 780*1000*1000,
      .fps_fixed  = 1,
      .bin_factor = 1,
      .intg_min   = 1<<4,
      .intg_max   = 2510<<4,
      .gain_min   = 1<<4,
      .gain_max   = 8<<4,
      .regs       = sensor_8M_regs,
      .regs_size  = ARRAY_SIZE(sensor_8M_regs),
      .set_size   = NULL,
    },
    /* 1080p crop */
    {
      .width      = 1920,
      .height     = 1080,
      .hoffset    = 0,
      .voffset    = 0,
      .hts        = 3500,
      .vts        = 1235,
      .pclk       = 260*1000*1000,
      .mipi_bps		= 780*1000*1000,
      .fps_fixed  = 1,
      .bin_factor = 1,
      .intg_min   = 1<<4,
      .intg_max   = 1235<<4,
      .gain_min   = 1<<4,
      .gain_max   = 8<<4,
      .regs       = sensor_1080p_crop_regs,
      .regs_size  = ARRAY_SIZE(sensor_1080p_crop_regs),
      .set_size   = NULL,
    },
    /* 1080p */
    {
      .width      = 1920,
      .height     = 1080,
      .hoffset    = 0,
      .voffset    = 0,
      .hts        = 3454,
      .vts        = 2510,
      .pclk       = 260*1000*1000,
      .mipi_bps		= 780*1000*1000,
      .fps_fixed  = 1,
      .bin_factor = 1,
      .intg_min   = 1<<4,
      .intg_max   = 2510<<4,
      .gain_min   = 1<<4,
      .gain_max   = 8<<4,
      .regs       = sensor_1080p_regs,
      .regs_size  = ARRAY_SIZE(sensor_1080p_regs),
      .set_size   = NULL,
    },
    
};

#define N_WIN_SIZES (ARRAY_SIZE(sensor_win_sizes))

static int sensor_enum_fmt(struct v4l2_subdev *sd, unsigned index,
                 enum v4l2_mbus_pixelcode *code)
{
  if (index >= N_FMTS)
    return -EINVAL;

  *code = sensor_formats[index].mbus_code;
  return 0;
}


static int sensor_try_fmt_internal(struct v4l2_subdev *sd,
    struct v4l2_mbus_framefmt *fmt,
    struct sensor_format_struct **ret_fmt,
    struct sensor_win_size **ret_wsize)
{
  int index;
  struct sensor_win_size *wsize;
	struct sensor_info *info = to_state(sd);
	
  for (index = 0; index < N_FMTS; index++)
    if (sensor_formats[index].mbus_code == fmt->code)
      break;

  if (index >= N_FMTS) 
    return -EINVAL;
  
  if (ret_fmt != NULL)
    *ret_fmt = sensor_formats + index;
    
  /*
   * Fields: the sensor devices claim to be progressive.
   */
  
  fmt->field = V4L2_FIELD_NONE;
  
  /*
   * Round requested image size down to the nearest
   * we support, but not below the smallest.
   */
  for (wsize = sensor_win_sizes; wsize < sensor_win_sizes + N_WIN_SIZES;
       wsize++)
    if (fmt->width >= wsize->width && fmt->height >= wsize->height)
      break;
    
  if (wsize >= sensor_win_sizes + N_WIN_SIZES)
    wsize--;   /* Take the smallest one */
  if (ret_wsize != NULL)
    *ret_wsize = wsize;
  
  info->current_wins = wsize;  
    
  /*
   * Note the size we'll actually handle.
   */
  fmt->width = wsize->width;
  fmt->height = wsize->height;
  //pix->bytesperline = pix->width*sensor_formats[index].bpp;
  //pix->sizeimage = pix->height*pix->bytesperline;

  return 0;
}

static int sensor_try_fmt(struct v4l2_subdev *sd, 
             struct v4l2_mbus_framefmt *fmt)
{
  return sensor_try_fmt_internal(sd, fmt, NULL, NULL);
}

static int sensor_g_mbus_config(struct v4l2_subdev *sd,
           struct v4l2_mbus_config *cfg)
{
  cfg->type = V4L2_MBUS_CSI2;
  cfg->flags = 0|V4L2_MBUS_CSI2_4_LANE|V4L2_MBUS_CSI2_CHANNEL_0;
  
  return 0;
}


/*
 * Set a format.
 */
static int sensor_s_fmt(struct v4l2_subdev *sd, 
             struct v4l2_mbus_framefmt *fmt)
{
  int ret;
  struct sensor_format_struct *sensor_fmt;
  struct sensor_win_size *wsize;
  struct sensor_info *info = to_state(sd);
  
  vfe_dev_dbg("sensor_s_fmt\n");
  
  //sensor_write_array(sd, sensor_oe_disable_regs, ARRAY_SIZE(sensor_oe_disable_regs));
  
  ret = sensor_try_fmt_internal(sd, fmt, &sensor_fmt, &wsize);
  if (ret)
    return ret;

  if(info->capture_mode == V4L2_MODE_VIDEO)
  {
    //video
  }
  else if(info->capture_mode == V4L2_MODE_IMAGE)
  {
    //image 
    
  }

  sensor_write_array(sd, sensor_fmt->regs, sensor_fmt->regs_size);

  ret = 0;
  printk("wsize->regs=0x%x\n",wsize->regs);
  if (wsize->regs)
    LOG_ERR_RET(sensor_write_array(sd, wsize->regs, wsize->regs_size))
  
  if (wsize->set_size)
    LOG_ERR_RET(wsize->set_size(sd))

  info->fmt = sensor_fmt;
  info->width = wsize->width;
  info->height = wsize->height;

  vfe_dev_print("s_fmt set width = %d, height = %d\n",wsize->width,wsize->height);

  if(info->capture_mode == V4L2_MODE_VIDEO)
  {
    //video
   
  } else {
    //capture image

  }
	
	//sensor_write_array(sd, sensor_oe_enable_regs, ARRAY_SIZE(sensor_oe_enable_regs));
	printk("s_fmt end\n");
	return 0;
}

/*
 * Implement G/S_PARM.  There is a "high quality" mode we could try
 * to do someday; for now, we just do the frame rate tweak.
 */
static int sensor_g_parm(struct v4l2_subdev *sd, struct v4l2_streamparm *parms)
{
  struct v4l2_captureparm *cp = &parms->parm.capture;
  struct sensor_info *info = to_state(sd);

  if (parms->type != V4L2_BUF_TYPE_VIDEO_CAPTURE)
    return -EINVAL;
  
  memset(cp, 0, sizeof(struct v4l2_captureparm));
  cp->capability = V4L2_CAP_TIMEPERFRAME;
  cp->capturemode = info->capture_mode;
     
  return 0;
}

static int sensor_s_parm(struct v4l2_subdev *sd, struct v4l2_streamparm *parms)
{
  struct v4l2_captureparm *cp = &parms->parm.capture;
  //struct v4l2_fract *tpf = &cp->timeperframe;
  struct sensor_info *info = to_state(sd);
  //unsigned char div;
  
  vfe_dev_dbg("sensor_s_parm\n");
  
  if (parms->type != V4L2_BUF_TYPE_VIDEO_CAPTURE)
    return -EINVAL;
  
  if (info->tpf.numerator == 0)
    return -EINVAL;
    
  info->capture_mode = cp->capturemode;
  
  return 0;
}


static int sensor_queryctrl(struct v4l2_subdev *sd,
    struct v4l2_queryctrl *qc)
{
  /* Fill in min, max, step and default value for these controls. */
  /* see include/linux/videodev2.h for details */
  
  switch (qc->id) {
	case V4L2_CID_GAIN:
		return v4l2_ctrl_query_fill(qc, 1*16, 8*16, 1, 16);
	case V4L2_CID_EXPOSURE:
		return v4l2_ctrl_query_fill(qc, 0, 65535*16, 1, 0);
  }
  return -EINVAL;
}

static int sensor_g_ctrl(struct v4l2_subdev *sd, struct v4l2_control *ctrl)
{
  switch (ctrl->id) {
  case V4L2_CID_GAIN:
    return sensor_g_gain(sd, &ctrl->value);
  case V4L2_CID_EXPOSURE:
  	return sensor_g_exp(sd, &ctrl->value);
  }
  return -EINVAL;
}

static int sensor_s_ctrl(struct v4l2_subdev *sd, struct v4l2_control *ctrl)
{
  struct v4l2_queryctrl qc;
  int ret;
  
  qc.id = ctrl->id;
  ret = sensor_queryctrl(sd, &qc);
  if (ret < 0) {
    return ret;
  }

  if (ctrl->value < qc.minimum || ctrl->value > qc.maximum) {
    return -ERANGE;
  }
  
  switch (ctrl->id) {
    case V4L2_CID_GAIN:
      return sensor_s_gain(sd, ctrl->value);
    case V4L2_CID_EXPOSURE:
	  return sensor_s_exp(sd, ctrl->value);
  }
  return -EINVAL;
}


static int sensor_g_chip_ident(struct v4l2_subdev *sd,
    struct v4l2_dbg_chip_ident *chip)
{
  struct i2c_client *client = v4l2_get_subdevdata(sd);

  return v4l2_chip_ident_i2c_client(client, chip, V4L2_IDENT_SENSOR, 0);
}


/* ----------------------------------------------------------------------- */

static const struct v4l2_subdev_core_ops sensor_core_ops = {
  .g_chip_ident = sensor_g_chip_ident,
  .g_ctrl = sensor_g_ctrl,
  .s_ctrl = sensor_s_ctrl,
  .queryctrl = sensor_queryctrl,
  .reset = sensor_reset,
  .init = sensor_init,
  .s_power = sensor_power,
  .ioctl = sensor_ioctl,
};

static const struct v4l2_subdev_video_ops sensor_video_ops = {
  .enum_mbus_fmt = sensor_enum_fmt,
  .try_mbus_fmt = sensor_try_fmt,
  .s_mbus_fmt = sensor_s_fmt,
  .s_parm = sensor_s_parm,
  .g_parm = sensor_g_parm,
  .g_mbus_config = sensor_g_mbus_config,
};

static const struct v4l2_subdev_ops sensor_ops = {
  .core = &sensor_core_ops,
  .video = &sensor_video_ops,
};

/* ----------------------------------------------------------------------- */
static struct cci_driver cci_drv = {
	.name = SENSOR_NAME,
};

static int sensor_probe(struct i2c_client *client,
      const struct i2c_device_id *id)
{
  struct v4l2_subdev *sd;
  struct sensor_info *info;
//  int ret;

  info = kzalloc(sizeof(struct sensor_info), GFP_KERNEL);
  if (info == NULL)
    return -ENOMEM;
  sd = &info->sd;
  glb_sd = sd;
  cci_dev_probe_helper(sd, client, &sensor_ops, &cci_drv);

  info->fmt = &sensor_formats[0];
  info->af_first_flag = 1;
  info->init_first_flag = 1;

  return 0;
}

static int sensor_remove(struct i2c_client *client)
{
  struct v4l2_subdev *sd;
  sd = cci_dev_remove_helper(client, &cci_drv);
  kfree(to_state(sd));
  return 0;
}

static const struct i2c_device_id sensor_id[] = {
  { SENSOR_NAME, 0 },
  { }
};
MODULE_DEVICE_TABLE(i2c, sensor_id);


static struct i2c_driver sensor_driver = {
  .driver = {
    .owner = THIS_MODULE,
  .name = SENSOR_NAME,
  },
  .probe = sensor_probe,
  .remove = sensor_remove,
  .id_table = sensor_id,
};
static __init int init_sensor(void)
{
	return cci_dev_init_helper(&sensor_driver);
}

static __exit void exit_sensor(void)
{
	cci_dev_exit_helper(&sensor_driver);
}

module_init(init_sensor);
module_exit(exit_sensor);

