#include "axp-rw.h"

static uint8_t axp_reg_addr = 0;

static void axp15_mfd_irq_work(struct work_struct *work)
{
	return;
}

static int axp15_disable_irqs(struct axp_dev *chip, uint64_t irqs)
{
	uint8_t v[3];
	int ret;
	unsigned char devaddr = RSB_RTSADDR_AXP806;

	chip->irqs_enabled &= ~irqs;

	v[0] = ((chip->irqs_enabled) & 0xff);
	v[1] = AXP15_INTEN2;
	v[2] = ((chip->irqs_enabled) >> 8) & 0xff;

	ret =  __axp_writes(&devaddr, chip->client, AXP15_INTEN1, 3, v, false);

	return ret;
}

static int axp15_enable_irqs(struct axp_dev *chip, uint64_t irqs)
{
	uint8_t v[3];
	int ret;
	unsigned char devaddr = RSB_RTSADDR_AXP806;

	chip->irqs_enabled |=  irqs;

	v[0] = ((chip->irqs_enabled) & 0xff);
	v[1] = AXP15_INTEN2;
	v[2] = ((chip->irqs_enabled) >> 8) & 0xff;

	ret =  __axp_writes(&devaddr, chip->client, AXP15_INTEN1, 3, v, false);

	return ret;
}

static int axp15_read_irqs(struct axp_dev *chip, uint64_t *irqs)
{
	uint8_t v[2] = {0, 0};
	int ret;
	unsigned char devaddr = RSB_RTSADDR_AXP806;
	ret =  __axp_reads(&devaddr, chip->client, AXP15_INTSTS1, 2, v, false);
	if (ret < 0)
		return ret;

	*irqs =((((uint64_t)v[1]) << 8) | ((uint64_t) v[0]));
	return 0;
}

static int  axp15_init_chip(struct axp_dev *chip)
{
	uint8_t chip_id;
	int err;
	unsigned char devaddr = RSB_RTSADDR_AXP806;

	INIT_WORK(&chip->irq_work, axp15_mfd_irq_work);

	/*read chip id*/	//???which int should enable must check with SD4
	err =  __axp_read(&devaddr, chip->client, AXP15_IC_TYPE, &chip_id, false);
	if (err) {
	    printk("[AXP15-MFD] try to read chip id failed!\n");
		return err;
	}
	dev_info(chip->dev, "AXP (CHIP ID: 0x%02x) detected\n", chip_id);
	if(((chip_id & 0xc0) == 0x40) && ((chip_id & 0x0f) == 0x00))
		chip->type = AXP15;
	else
		chip->type = 0;

	/* mask and clear all IRQs */
	chip->irqs_enabled = 0xffff;
	chip->ops->disable_irqs(chip, chip->irqs_enabled);

	return 0;
}

static ssize_t axp15_reg_show(struct device *dev,
		struct device_attribute *attr, char *buf)
{
	uint8_t val;

	axp_read(dev,axp_reg_addr,&val);
	return sprintf(buf,"REG[%x]=%x\n",axp_reg_addr,val);
}

static ssize_t axp15_reg_store(struct device *dev,
				struct device_attribute *attr, const char *buf, size_t count)
{
	int tmp;
	uint8_t val;

	tmp = simple_strtoul(buf, NULL, 16);
	if( tmp < 256 )
		axp_reg_addr = tmp;
	else {
		val = tmp & 0x00FF;
		axp_reg_addr= (tmp >> 8) & 0x00FF;
		axp_write(dev,axp_reg_addr, val);
	}
	return count;
}

static ssize_t axp15_regs_show(struct device *dev,
		struct device_attribute *attr, char *buf)
{
	uint8_t val[2];

	axp_reads(dev,axp_reg_addr,2,val);
	return sprintf(buf,"REG[0x%x]=0x%x,REG[0x%x]=0x%x\n",axp_reg_addr,val[0],axp_reg_addr+1,val[1]);
}

static ssize_t axp15_regs_store(struct device *dev,
				struct device_attribute *attr, const char *buf, size_t count)
{
	int tmp;
	uint8_t val[3];

	tmp = simple_strtoul(buf, NULL, 16);
	if( tmp < 256 )
		axp_reg_addr = tmp;
	else {
		axp_reg_addr= (tmp >> 16) & 0xFF;
		val[0] = (tmp >> 8) & 0xFF;
		val[1] = axp_reg_addr + 1;
		val[2] = tmp & 0xFF;
		axp_writes(dev,axp_reg_addr,3,val);
	}
	return count;
}

static struct device_attribute axp15_mfd_attrs[] = {
	AXP_MFD_ATTR(axp15_reg),
	AXP_MFD_ATTR(axp15_regs),
};

