/*************************************************************************/ /*!
@Title          Hardware definition file emu_cr_defs.h
@Copyright      Copyright (c) Imagination Technologies Ltd. All Rights Reserved
@License        Dual MIT/GPLv2

The contents of this file are subject to the MIT license as set out below.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

Alternatively, the contents of this file may be used under the terms of
the GNU General Public License Version 2 ("GPL") in which case the provisions
of GPL are applicable instead of those above.

If you wish to allow use of your version of this file only under the terms of
GPL, and not to allow others to use your version of this file under the terms
of the MIT license, indicate your decision by deleting the provisions above
and replace them with the notice and other provisions required by GPL as set
out in the file called "GPL-COPYING" included in this distribution. If you do
not delete the provisions above, a recipient may use your version of this file
under the terms of either the MIT license or GPL.

This License is also included in this distribution in the file called
"MIT-COPYING".

EXCEPT AS OTHERWISE STATED IN A NEGOTIATED AGREEMENT: (A) THE SOFTWARE IS
PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE AND NONINFRINGEMENT; AND (B) IN NO EVENT SHALL THE AUTHORS OR
COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/ /**************************************************************************/

/*               ****   Autogenerated C -- do not edit    ****               */

/*
 * Generated by regconv version MAIN@809368
 *   from files:
 *      (null) (null)
 */


#ifndef _EMU_CR_DEFS_H_
#define _EMU_CR_DEFS_H_

/*

	Soft reset control register which drives the Rogue core and IMGBUS4 memory model
	Write a '1' to reset and a '0' to clear

*/
/*
	Register EMU_CR_SOFT_RESET
*/
#define EMU_CR_SOFT_RESET                                 (0x0000U)
#define EMU_CR_SOFT_RESET_MASKFULL                        (IMG_UINT64_C(0x0000000000000007))
/*
Resets system + Cache Invalidate/Host write block
*/
#define EMU_CR_SOFT_RESET_SYS_SHIFT                       (2U)
#define EMU_CR_SOFT_RESET_SYS_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFB))
#define EMU_CR_SOFT_RESET_SYS_EN                          (IMG_UINT64_C(0X0000000000000004))
/*
Resets memory + Random Stallers
*/
#define EMU_CR_SOFT_RESET_MEM_SHIFT                       (1U)
#define EMU_CR_SOFT_RESET_MEM_CLRMSK                      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFD))
#define EMU_CR_SOFT_RESET_MEM_EN                          (IMG_UINT64_C(0X0000000000000002))
/*
Resets Core
*/
#define EMU_CR_SOFT_RESET_CORE_SHIFT                      (0U)
#define EMU_CR_SOFT_RESET_CORE_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define EMU_CR_SOFT_RESET_CORE_EN                         (IMG_UINT64_C(0X0000000000000001))

/*

	Programming this register to '1' enables PCI Master Mode
	All external memory accesses from Rogue will be routed over the PCI bus to the hosts system memory

*/
/*
	Register EMU_CR_PCI_MASTER
*/
#define EMU_CR_PCI_MASTER                                 (0x0008U)
#define EMU_CR_PCI_MASTER_MASKFULL                        (IMG_UINT64_C(0x0000000000000001))
#define EMU_CR_PCI_MASTER_MODE_SHIFT                      (0U)
#define EMU_CR_PCI_MASTER_MODE_CLRMSK                     (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define EMU_CR_PCI_MASTER_MODE_EN                         (IMG_UINT64_C(0X0000000000000001))

/*

	Load seed values for the random stallers

*/
/*
	Register EMU_CR_RANDOM
*/
#define EMU_CR_RANDOM                                     (0x0010U)
#define EMU_CR_RANDOM_MASKFULL                            (IMG_UINT64_C(0x0000000000000001))
/*
Initialise random seeds
*/
#define EMU_CR_RANDOM_INITIALISE_SHIFT                    (0U)
#define EMU_CR_RANDOM_INITIALISE_CLRMSK                   (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define EMU_CR_RANDOM_INITIALISE_EN                       (IMG_UINT64_C(0X0000000000000001))

/*

	Random address stall seed
   Random address stall cycles
	Random address burst seed
   Random address burst cycles

*/
/*
	Register EMU_CR_RANDOM_ADDR
*/
#define EMU_CR_RANDOM_ADDR                                (0x0018U)
#define EMU_CR_RANDOM_ADDR_MASKFULL                       (IMG_UINT64_C(0x00000000FF1FFF1F))
/*
Seed value
*/
#define EMU_CR_RANDOM_ADDR_STALL_SEED_SHIFT               (24U)
#define EMU_CR_RANDOM_ADDR_STALL_SEED_CLRMSK              (IMG_UINT64_C(0XFFFFFFFF00FFFFFF))
/*
Cycle values
*/
#define EMU_CR_RANDOM_ADDR_STALL_CYCLES_SHIFT             (16U)
#define EMU_CR_RANDOM_ADDR_STALL_CYCLES_CLRMSK            (IMG_UINT64_C(0XFFFFFFFFFFE0FFFF))
/*
Seed value
*/
#define EMU_CR_RANDOM_ADDR_BUSRT_SEED_SHIFT               (8U)
#define EMU_CR_RANDOM_ADDR_BUSRT_SEED_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFFFFF00FF))
/*
Cycle values
*/
#define EMU_CR_RANDOM_ADDR_BUSRT_CYCLES_SHIFT             (0U)
#define EMU_CR_RANDOM_ADDR_BUSRT_CYCLES_CLRMSK            (IMG_UINT64_C(0XFFFFFFFFFFFFFFE0))

/*

	Enable random address staller

*/
/*
	Register EMU_CR_RANDOM_ADDR_STALL_ENABLE
*/
#define EMU_CR_RANDOM_ADDR_STALL_ENABLE                   (0x0020U)
#define EMU_CR_RANDOM_ADDR_STALL_ENABLE_MASKFULL          (IMG_UINT64_C(0x0000000000000001))
/*
Enable random address staller
*/
#define EMU_CR_RANDOM_ADDR_STALL_ENABLE_ENABLE_SHIFT      (0U)
#define EMU_CR_RANDOM_ADDR_STALL_ENABLE_ENABLE_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define EMU_CR_RANDOM_ADDR_STALL_ENABLE_ENABLE_EN         (IMG_UINT64_C(0X0000000000000001))

/*

	Random write data stall seed
   Random write data stall cycles
 	Random write data burst seed
   Random write data burst cycles


*/
/*
	Register EMU_CR_RANDOM_WDATA
*/
#define EMU_CR_RANDOM_WDATA                               (0x0028U)
#define EMU_CR_RANDOM_WDATA_MASKFULL                      (IMG_UINT64_C(0x00000000FF1FFF1F))
/*
Seed value
*/
#define EMU_CR_RANDOM_WDATA_STALL_SEED_SHIFT              (24U)
#define EMU_CR_RANDOM_WDATA_STALL_SEED_CLRMSK             (IMG_UINT64_C(0XFFFFFFFF00FFFFFF))
/*
Cycle values
*/
#define EMU_CR_RANDOM_WDATA_STALL_CYCLES_SHIFT            (16U)
#define EMU_CR_RANDOM_WDATA_STALL_CYCLES_CLRMSK           (IMG_UINT64_C(0XFFFFFFFFFFE0FFFF))
/*
Seed value
*/
#define EMU_CR_RANDOM_WDATA_BUSRT_SEED_SHIFT              (8U)
#define EMU_CR_RANDOM_WDATA_BUSRT_SEED_CLRMSK             (IMG_UINT64_C(0XFFFFFFFFFFFF00FF))
/*
Cycle values
*/
#define EMU_CR_RANDOM_WDATA_BUSRT_CYCLES_SHIFT            (0U)
#define EMU_CR_RANDOM_WDATA_BUSRT_CYCLES_CLRMSK           (IMG_UINT64_C(0XFFFFFFFFFFFFFFE0))

/*

	Enable random wdata staller

*/
/*
	Register EMU_CR_RANDOM_WDATA_STALL_ENABLE
*/
#define EMU_CR_RANDOM_WDATA_STALL_ENABLE                  (0x0030U)
#define EMU_CR_RANDOM_WDATA_STALL_ENABLE_MASKFULL         (IMG_UINT64_C(0x0000000000000001))
/*
Enable random wdata staller
*/
#define EMU_CR_RANDOM_WDATA_STALL_ENABLE_ENABLE_SHIFT     (0U)
#define EMU_CR_RANDOM_WDATA_STALL_ENABLE_ENABLE_CLRMSK    (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define EMU_CR_RANDOM_WDATA_STALL_ENABLE_ENABLE_EN        (IMG_UINT64_C(0X0000000000000001))

/*

	Random write response stall seed
   Random write response stall cycles
 	Random write response burst seed
   Random write response burst cycles

*/
/*
	Register EMU_CR_RANDOM_WRESP
*/
#define EMU_CR_RANDOM_WRESP                               (0x0038U)
#define EMU_CR_RANDOM_WRESP_MASKFULL                      (IMG_UINT64_C(0x00000000FF1FFF1F))
/*
Seed value
*/
#define EMU_CR_RANDOM_WRESP_STALL_SEED_SHIFT              (24U)
#define EMU_CR_RANDOM_WRESP_STALL_SEED_CLRMSK             (IMG_UINT64_C(0XFFFFFFFF00FFFFFF))
/*
Cycle values
*/
#define EMU_CR_RANDOM_WRESP_STALL_CYCLES_SHIFT            (16U)
#define EMU_CR_RANDOM_WRESP_STALL_CYCLES_CLRMSK           (IMG_UINT64_C(0XFFFFFFFFFFE0FFFF))
/*
Seed value
*/
#define EMU_CR_RANDOM_WRESP_BUSRT_SEED_SHIFT              (8U)
#define EMU_CR_RANDOM_WRESP_BUSRT_SEED_CLRMSK             (IMG_UINT64_C(0XFFFFFFFFFFFF00FF))
/*
Cycle values
*/
#define EMU_CR_RANDOM_WRESP_BUSRT_CYCLES_SHIFT            (0U)
#define EMU_CR_RANDOM_WRESP_BUSRT_CYCLES_CLRMSK           (IMG_UINT64_C(0XFFFFFFFFFFFFFFE0))

/*

	Enable random wresp tagID staller

*/
/*
	Register EMU_CR_RANDOM_WRESP_STALL_ENABLE
*/
#define EMU_CR_RANDOM_WRESP_STALL_ENABLE                  (0x0040U)
#define EMU_CR_RANDOM_WRESP_STALL_ENABLE_MASKFULL         (IMG_UINT64_C(0x0000000000000001))
/*
Enable random wresp tagID staller
*/
#define EMU_CR_RANDOM_WRESP_STALL_ENABLE_ENABLE_SHIFT     (0U)
#define EMU_CR_RANDOM_WRESP_STALL_ENABLE_ENABLE_CLRMSK    (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define EMU_CR_RANDOM_WRESP_STALL_ENABLE_ENABLE_EN        (IMG_UINT64_C(0X0000000000000001))

/*

	Random read data stall seed
   Random read data stall cycles
 	Random read data burst seed
   Random read data burst cycles

*/
/*
	Register EMU_CR_RANDOM_RDATA
*/
#define EMU_CR_RANDOM_RDATA                               (0x0048U)
#define EMU_CR_RANDOM_RDATA_MASKFULL                      (IMG_UINT64_C(0x00000000FF1FFF1F))
/*
Seed value
*/
#define EMU_CR_RANDOM_RDATA_STALL_SEED_SHIFT              (24U)
#define EMU_CR_RANDOM_RDATA_STALL_SEED_CLRMSK             (IMG_UINT64_C(0XFFFFFFFF00FFFFFF))
/*
Cycle values
*/
#define EMU_CR_RANDOM_RDATA_STALL_CYCLES_SHIFT            (16U)
#define EMU_CR_RANDOM_RDATA_STALL_CYCLES_CLRMSK           (IMG_UINT64_C(0XFFFFFFFFFFE0FFFF))
/*
Seed value
*/
#define EMU_CR_RANDOM_RDATA_BUSRT_SEED_SHIFT              (8U)
#define EMU_CR_RANDOM_RDATA_BUSRT_SEED_CLRMSK             (IMG_UINT64_C(0XFFFFFFFFFFFF00FF))
/*
Cycle values
*/
#define EMU_CR_RANDOM_RDATA_BUSRT_CYCLES_SHIFT            (0U)
#define EMU_CR_RANDOM_RDATA_BUSRT_CYCLES_CLRMSK           (IMG_UINT64_C(0XFFFFFFFFFFFFFFE0))

/*

	Enable random rdata staller

*/
/*
	Register EMU_CR_RANDOM_RDATA_STALL_ENABLE
*/
#define EMU_CR_RANDOM_RDATA_STALL_ENABLE                  (0x0050U)
#define EMU_CR_RANDOM_RDATA_STALL_ENABLE_MASKFULL         (IMG_UINT64_C(0x0000000000000001))
/*
Enable random rdata staller
*/
#define EMU_CR_RANDOM_RDATA_STALL_ENABLE_ENABLE_SHIFT     (0U)
#define EMU_CR_RANDOM_RDATA_STALL_ENABLE_ENABLE_CLRMSK    (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define EMU_CR_RANDOM_RDATA_STALL_ENABLE_ENABLE_EN        (IMG_UINT64_C(0X0000000000000001))

/*

   Behaviour is selected with the following:
   - Set latency to 0 for bypass mode (ie no latency, no reordering - same as disabling reordering with 0x0060)
   - Set latency to 63 for max latency

*/
/*
	Register EMU_CR_RDATA_REORDER
*/
#define EMU_CR_RDATA_REORDER                              (0x0058U)
#define EMU_CR_RDATA_REORDER_MASKFULL                     (IMG_UINT64_C(0x000000000000003F))
/*
Latency value
*/
#define EMU_CR_RDATA_REORDER_LATENCY_SHIFT                (0U)
#define EMU_CR_RDATA_REORDER_LATENCY_CLRMSK               (IMG_UINT64_C(0XFFFFFFFFFFFFFFC0))

/*

	Enable/disable reordering of read data and latency insertion

*/
/*
	Register EMU_CR_RDATA_REORDER_ENABLE
*/
#define EMU_CR_RDATA_REORDER_ENABLE                       (0x0060U)
#define EMU_CR_RDATA_REORDER_ENABLE_MASKFULL              (IMG_UINT64_C(0x0000000000000001))
/*
Enable reordering of read data
*/
#define EMU_CR_RDATA_REORDER_ENABLE_ENABLE_SHIFT          (0U)
#define EMU_CR_RDATA_REORDER_ENABLE_ENABLE_CLRMSK         (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define EMU_CR_RDATA_REORDER_ENABLE_ENABLE_EN             (IMG_UINT64_C(0X0000000000000001))

/*

	Report errors in emulator wrapper

*/
/*
	Register EMU_CR_WRAPPER_ERROR
*/
#define EMU_CR_WRAPPER_ERROR                              (0x0068U)
#define EMU_CR_WRAPPER_ERROR_MASKFULL                     (IMG_UINT64_C(0x00000000000000FF))
/*
Port3: Reordering fifos not empty when fifo_out_en is de-asserted
*/
#define EMU_CR_WRAPPER_ERROR_REORDERING3_ERR1_SHIFT       (7U)
#define EMU_CR_WRAPPER_ERROR_REORDERING3_ERR1_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFFFFFF7F))
#define EMU_CR_WRAPPER_ERROR_REORDERING3_ERR1_EN          (IMG_UINT64_C(0X0000000000000080))
/*
Port3: Reordering fifos not empty while reordering is turned off
*/
#define EMU_CR_WRAPPER_ERROR_REORDERING3_ERR0_SHIFT       (6U)
#define EMU_CR_WRAPPER_ERROR_REORDERING3_ERR0_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFFFFFFBF))
#define EMU_CR_WRAPPER_ERROR_REORDERING3_ERR0_EN          (IMG_UINT64_C(0X0000000000000040))
/*
Port2: Reordering fifos not empty when fifo_out_en is de-asserted
*/
#define EMU_CR_WRAPPER_ERROR_REORDERING2_ERR1_SHIFT       (5U)
#define EMU_CR_WRAPPER_ERROR_REORDERING2_ERR1_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFFFFFFDF))
#define EMU_CR_WRAPPER_ERROR_REORDERING2_ERR1_EN          (IMG_UINT64_C(0X0000000000000020))
/*
Port2: Reordering fifos not empty while reordering is turned off
*/
#define EMU_CR_WRAPPER_ERROR_REORDERING2_ERR0_SHIFT       (4U)
#define EMU_CR_WRAPPER_ERROR_REORDERING2_ERR0_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFFFFFFEF))
#define EMU_CR_WRAPPER_ERROR_REORDERING2_ERR0_EN          (IMG_UINT64_C(0X0000000000000010))
/*
Port1: Reordering fifos not empty when fifo_out_en is de-asserted
*/
#define EMU_CR_WRAPPER_ERROR_REORDERING1_ERR1_SHIFT       (3U)
#define EMU_CR_WRAPPER_ERROR_REORDERING1_ERR1_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFFFFFFF7))
#define EMU_CR_WRAPPER_ERROR_REORDERING1_ERR1_EN          (IMG_UINT64_C(0X0000000000000008))
/*
Port1: Reordering fifos not empty while reordering is turned off
*/
#define EMU_CR_WRAPPER_ERROR_REORDERING1_ERR0_SHIFT       (2U)
#define EMU_CR_WRAPPER_ERROR_REORDERING1_ERR0_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFB))
#define EMU_CR_WRAPPER_ERROR_REORDERING1_ERR0_EN          (IMG_UINT64_C(0X0000000000000004))
/*
Port0: Reordering fifos not empty when fifo_out_en is de-asserted
*/
#define EMU_CR_WRAPPER_ERROR_REORDERING0_ERR1_SHIFT       (1U)
#define EMU_CR_WRAPPER_ERROR_REORDERING0_ERR1_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFD))
#define EMU_CR_WRAPPER_ERROR_REORDERING0_ERR1_EN          (IMG_UINT64_C(0X0000000000000002))
/*
Port0: Reordering fifos not empty while reordering is turned off
*/
#define EMU_CR_WRAPPER_ERROR_REORDERING0_ERR0_SHIFT       (0U)
#define EMU_CR_WRAPPER_ERROR_REORDERING0_ERR0_CLRMSK      (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define EMU_CR_WRAPPER_ERROR_REORDERING0_ERR0_EN          (IMG_UINT64_C(0X0000000000000001))

/*

   Dusts enabled. This is a one hot enable for dusts and is used for Power Islanding of Dusts.
   The valid values are 0x1, 0x3, and 0x7. All the other values should not be used.
   1: DustA enabled.
   3: DustB enabled.
   7: DustC enabled.


*/
/*
	Register EMU_CR_DUSTS_ENABLE
*/
#define EMU_CR_DUSTS_ENABLE                               (0x0070U)
#define EMU_CR_DUSTS_ENABLE_MASKFULL                      (IMG_UINT64_C(0x00000000000000FF))
/*
Dusts enabled
*/
#define EMU_CR_DUSTS_ENABLE_ENABLE_SHIFT                  (0U)
#define EMU_CR_DUSTS_ENABLE_ENABLE_CLRMSK                 (0XFFFFFF00U)

/*

	Random host write seed
	Random host write addresses to populate and invalidate
	Random host write scale - Controls gaps between invalidates as follow:
      b'00 => new_gap = previous_gap + previous_gap       - less frequently
      b'01 => new_gap = previous_gap + 1/4(previous_gap)
      b'10 => new_gap = previous_gap + 1/8(previous_gap)
      b'11 => new_gap = previous_gap + 1/16(previous_gap) - more frequently

*/
/*
	Register EMU_CR_RANDOM_HOST_WRITE
*/
#define EMU_CR_RANDOM_HOST_WRITE                          (0x0100U)
#define EMU_CR_RANDOM_HOST_WRITE_MASKFULL                 (IMG_UINT64_C(0x00000000001FF3F3))
/*
Seed values
*/
#define EMU_CR_RANDOM_HOST_WRITE_SEED_SHIFT               (12U)
#define EMU_CR_RANDOM_HOST_WRITE_SEED_CLRMSK              (IMG_UINT64_C(0XFFFFFFFFFFE00FFF))
/*
Number of addresses to populate
*/
#define EMU_CR_RANDOM_HOST_WRITE_ADDR_NO_SHIFT            (4U)
#define EMU_CR_RANDOM_HOST_WRITE_ADDR_NO_CLRMSK           (IMG_UINT64_C(0XFFFFFFFFFFFFFC0F))
/*
Scale write
*/
#define EMU_CR_RANDOM_HOST_WRITE_SCALE_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_WRITE_SCALE_CLRMSK             (IMG_UINT64_C(0XFFFFFFFFFFFFFFFC))

/*

	Enable random host write

*/
/*
	Register EMU_CR_RANDOM_HOST_WRITE_ENABLE
*/
#define EMU_CR_RANDOM_HOST_WRITE_ENABLE                   (0x0108U)
#define EMU_CR_RANDOM_HOST_WRITE_ENABLE_MASKFULL          (IMG_UINT64_C(0x0000000000000001))
/*
Enable random host write
*/
#define EMU_CR_RANDOM_HOST_WRITE_ENABLE_ENABLE_SHIFT      (0U)
#define EMU_CR_RANDOM_HOST_WRITE_ENABLE_ENABLE_CLRMSK     (IMG_UINT64_C(0XFFFFFFFFFFFFFFFE))
#define EMU_CR_RANDOM_HOST_WRITE_ENABLE_ENABLE_EN         (IMG_UINT64_C(0X0000000000000001))

/*

	Random host write address 0

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR0
*/
#define EMU_CR_RANDOM_HOST_ADDR0                          (0x0118U)
#define EMU_CR_RANDOM_HOST_ADDR0_MASKFULL                 (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 0 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR0_ADDR0_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_ADDR0_ADDR0_CLRMSK             (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 1

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR1
*/
#define EMU_CR_RANDOM_HOST_ADDR1                          (0x0120U)
#define EMU_CR_RANDOM_HOST_ADDR1_MASKFULL                 (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 1 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR1_ADDR1_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_ADDR1_ADDR1_CLRMSK             (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 2

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR2
*/
#define EMU_CR_RANDOM_HOST_ADDR2                          (0x0128U)
#define EMU_CR_RANDOM_HOST_ADDR2_MASKFULL                 (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 2 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR2_ADDR2_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_ADDR2_ADDR2_CLRMSK             (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 3

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR3
*/
#define EMU_CR_RANDOM_HOST_ADDR3                          (0x0130U)
#define EMU_CR_RANDOM_HOST_ADDR3_MASKFULL                 (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 3 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR3_ADDR3_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_ADDR3_ADDR3_CLRMSK             (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 4

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR4
*/
#define EMU_CR_RANDOM_HOST_ADDR4                          (0x0138U)
#define EMU_CR_RANDOM_HOST_ADDR4_MASKFULL                 (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 4 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR4_ADDR4_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_ADDR4_ADDR4_CLRMSK             (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 5

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR5
*/
#define EMU_CR_RANDOM_HOST_ADDR5                          (0x0140U)
#define EMU_CR_RANDOM_HOST_ADDR5_MASKFULL                 (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 5 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR5_ADDR5_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_ADDR5_ADDR5_CLRMSK             (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 6

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR6
*/
#define EMU_CR_RANDOM_HOST_ADDR6                          (0x0148U)
#define EMU_CR_RANDOM_HOST_ADDR6_MASKFULL                 (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 6 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR6_ADDR6_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_ADDR6_ADDR6_CLRMSK             (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 7

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR7
*/
#define EMU_CR_RANDOM_HOST_ADDR7                          (0x0150U)
#define EMU_CR_RANDOM_HOST_ADDR7_MASKFULL                 (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 7 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR7_ADDR7_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_ADDR7_ADDR7_CLRMSK             (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 8

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR8
*/
#define EMU_CR_RANDOM_HOST_ADDR8                          (0x0158U)
#define EMU_CR_RANDOM_HOST_ADDR8_MASKFULL                 (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 8 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR8_ADDR8_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_ADDR8_ADDR8_CLRMSK             (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 9

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR9
*/
#define EMU_CR_RANDOM_HOST_ADDR9                          (0x0160U)
#define EMU_CR_RANDOM_HOST_ADDR9_MASKFULL                 (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 9 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR9_ADDR9_SHIFT              (0U)
#define EMU_CR_RANDOM_HOST_ADDR9_ADDR9_CLRMSK             (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 10

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR10
*/
#define EMU_CR_RANDOM_HOST_ADDR10                         (0x0168U)
#define EMU_CR_RANDOM_HOST_ADDR10_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 10 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR10_ADDR10_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR10_ADDR10_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 11

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR11
*/
#define EMU_CR_RANDOM_HOST_ADDR11                         (0x0170U)
#define EMU_CR_RANDOM_HOST_ADDR11_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 11 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR11_ADDR11_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR11_ADDR11_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 12

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR12
*/
#define EMU_CR_RANDOM_HOST_ADDR12                         (0x0178U)
#define EMU_CR_RANDOM_HOST_ADDR12_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 12 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR12_ADDR12_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR12_ADDR12_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 13

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR13
*/
#define EMU_CR_RANDOM_HOST_ADDR13                         (0x0180U)
#define EMU_CR_RANDOM_HOST_ADDR13_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 13 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR13_ADDR13_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR13_ADDR13_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 14

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR14
*/
#define EMU_CR_RANDOM_HOST_ADDR14                         (0x0188U)
#define EMU_CR_RANDOM_HOST_ADDR14_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 14 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR14_ADDR14_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR14_ADDR14_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 15

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR15
*/
#define EMU_CR_RANDOM_HOST_ADDR15                         (0x0190U)
#define EMU_CR_RANDOM_HOST_ADDR15_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 15 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR15_ADDR15_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR15_ADDR15_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 16

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR16
*/
#define EMU_CR_RANDOM_HOST_ADDR16                         (0x0198U)
#define EMU_CR_RANDOM_HOST_ADDR16_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 16 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR16_ADDR16_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR16_ADDR16_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 17

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR17
*/
#define EMU_CR_RANDOM_HOST_ADDR17                         (0x01A0U)
#define EMU_CR_RANDOM_HOST_ADDR17_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 17 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR17_ADDR17_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR17_ADDR17_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 18

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR18
*/
#define EMU_CR_RANDOM_HOST_ADDR18                         (0x01A8U)
#define EMU_CR_RANDOM_HOST_ADDR18_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 18 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR18_ADDR18_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR18_ADDR18_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 19

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR19
*/
#define EMU_CR_RANDOM_HOST_ADDR19                         (0x01B0U)
#define EMU_CR_RANDOM_HOST_ADDR19_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 19 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR19_ADDR19_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR19_ADDR19_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 20

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR20
*/
#define EMU_CR_RANDOM_HOST_ADDR20                         (0x01B8U)
#define EMU_CR_RANDOM_HOST_ADDR20_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 20 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR20_ADDR20_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR20_ADDR20_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 21

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR21
*/
#define EMU_CR_RANDOM_HOST_ADDR21                         (0x01C0U)
#define EMU_CR_RANDOM_HOST_ADDR21_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 21 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR21_ADDR21_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR21_ADDR21_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 22

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR22
*/
#define EMU_CR_RANDOM_HOST_ADDR22                         (0x01C8U)
#define EMU_CR_RANDOM_HOST_ADDR22_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 22 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR22_ADDR22_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR22_ADDR22_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 23

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR23
*/
#define EMU_CR_RANDOM_HOST_ADDR23                         (0x01D0U)
#define EMU_CR_RANDOM_HOST_ADDR23_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 23 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR23_ADDR23_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR23_ADDR23_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 24

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR24
*/
#define EMU_CR_RANDOM_HOST_ADDR24                         (0x01D8U)
#define EMU_CR_RANDOM_HOST_ADDR24_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 24 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR24_ADDR24_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR24_ADDR24_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 25

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR25
*/
#define EMU_CR_RANDOM_HOST_ADDR25                         (0x01E0U)
#define EMU_CR_RANDOM_HOST_ADDR25_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 25 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR25_ADDR25_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR25_ADDR25_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 26

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR26
*/
#define EMU_CR_RANDOM_HOST_ADDR26                         (0x01E8U)
#define EMU_CR_RANDOM_HOST_ADDR26_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 26 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR26_ADDR26_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR26_ADDR26_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 27

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR27
*/
#define EMU_CR_RANDOM_HOST_ADDR27                         (0x01F0U)
#define EMU_CR_RANDOM_HOST_ADDR27_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 27 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR27_ADDR27_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR27_ADDR27_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 28

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR28
*/
#define EMU_CR_RANDOM_HOST_ADDR28                         (0x01F8U)
#define EMU_CR_RANDOM_HOST_ADDR28_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 28 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR28_ADDR28_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR28_ADDR28_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 29

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR29
*/
#define EMU_CR_RANDOM_HOST_ADDR29                         (0x0200U)
#define EMU_CR_RANDOM_HOST_ADDR29_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 29 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR29_ADDR29_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR29_ADDR29_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 30

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR30
*/
#define EMU_CR_RANDOM_HOST_ADDR30                         (0x0208U)
#define EMU_CR_RANDOM_HOST_ADDR30_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 30 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR30_ADDR30_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR30_ADDR30_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write address 31

*/
/*
	Register EMU_CR_RANDOM_HOST_ADDR31
*/
#define EMU_CR_RANDOM_HOST_ADDR31                         (0x0210U)
#define EMU_CR_RANDOM_HOST_ADDR31_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Address 31 to be populated
*/
#define EMU_CR_RANDOM_HOST_ADDR31_ADDR31_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_ADDR31_ADDR31_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 0

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA0
*/
#define EMU_CR_RANDOM_HOST_WDATA0                         (0x0218U)
#define EMU_CR_RANDOM_HOST_WDATA0_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 0 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA0_WDATA0_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_WDATA0_WDATA0_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 1

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA1
*/
#define EMU_CR_RANDOM_HOST_WDATA1                         (0x0220U)
#define EMU_CR_RANDOM_HOST_WDATA1_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 1 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA1_WDATA1_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_WDATA1_WDATA1_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 2

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA2
*/
#define EMU_CR_RANDOM_HOST_WDATA2                         (0x0228U)
#define EMU_CR_RANDOM_HOST_WDATA2_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 2 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA2_WDATA2_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_WDATA2_WDATA2_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 3

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA3
*/
#define EMU_CR_RANDOM_HOST_WDATA3                         (0x0230U)
#define EMU_CR_RANDOM_HOST_WDATA3_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 3 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA3_WDATA3_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_WDATA3_WDATA3_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 4

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA4
*/
#define EMU_CR_RANDOM_HOST_WDATA4                         (0x0238U)
#define EMU_CR_RANDOM_HOST_WDATA4_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 4 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA4_WDATA4_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_WDATA4_WDATA4_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 5

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA5
*/
#define EMU_CR_RANDOM_HOST_WDATA5                         (0x0240U)
#define EMU_CR_RANDOM_HOST_WDATA5_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 5 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA5_WDATA5_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_WDATA5_WDATA5_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 6

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA6
*/
#define EMU_CR_RANDOM_HOST_WDATA6                         (0x0248U)
#define EMU_CR_RANDOM_HOST_WDATA6_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 6 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA6_WDATA6_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_WDATA6_WDATA6_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 7

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA7
*/
#define EMU_CR_RANDOM_HOST_WDATA7                         (0x0250U)
#define EMU_CR_RANDOM_HOST_WDATA7_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 7 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA7_WDATA7_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_WDATA7_WDATA7_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 8

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA8
*/
#define EMU_CR_RANDOM_HOST_WDATA8                         (0x0258U)
#define EMU_CR_RANDOM_HOST_WDATA8_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 8 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA8_WDATA8_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_WDATA8_WDATA8_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 9

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA9
*/
#define EMU_CR_RANDOM_HOST_WDATA9                         (0x0260U)
#define EMU_CR_RANDOM_HOST_WDATA9_MASKFULL                (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 9 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA9_WDATA9_SHIFT            (0U)
#define EMU_CR_RANDOM_HOST_WDATA9_WDATA9_CLRMSK           (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 10

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA10
*/
#define EMU_CR_RANDOM_HOST_WDATA10                        (0x0268U)
#define EMU_CR_RANDOM_HOST_WDATA10_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 10 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA10_WDATA10_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA10_WDATA10_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 11

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA11
*/
#define EMU_CR_RANDOM_HOST_WDATA11                        (0x0270U)
#define EMU_CR_RANDOM_HOST_WDATA11_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 11 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA11_WDATA11_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA11_WDATA11_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 12

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA12
*/
#define EMU_CR_RANDOM_HOST_WDATA12                        (0x0278U)
#define EMU_CR_RANDOM_HOST_WDATA12_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 12 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA12_WDATA12_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA12_WDATA12_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 13

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA13
*/
#define EMU_CR_RANDOM_HOST_WDATA13                        (0x0280U)
#define EMU_CR_RANDOM_HOST_WDATA13_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 13 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA13_WDATA13_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA13_WDATA13_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 14

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA14
*/
#define EMU_CR_RANDOM_HOST_WDATA14                        (0x0288U)
#define EMU_CR_RANDOM_HOST_WDATA14_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 14 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA14_WDATA14_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA14_WDATA14_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 15

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA15
*/
#define EMU_CR_RANDOM_HOST_WDATA15                        (0x0290U)
#define EMU_CR_RANDOM_HOST_WDATA15_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 15 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA15_WDATA15_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA15_WDATA15_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 16

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA16
*/
#define EMU_CR_RANDOM_HOST_WDATA16                        (0x0298U)
#define EMU_CR_RANDOM_HOST_WDATA16_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 16 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA16_WDATA16_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA16_WDATA16_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 17

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA17
*/
#define EMU_CR_RANDOM_HOST_WDATA17                        (0x02A0U)
#define EMU_CR_RANDOM_HOST_WDATA17_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 17 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA17_WDATA17_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA17_WDATA17_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 18

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA18
*/
#define EMU_CR_RANDOM_HOST_WDATA18                        (0x02A8U)
#define EMU_CR_RANDOM_HOST_WDATA18_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 18 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA18_WDATA18_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA18_WDATA18_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 19

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA19
*/
#define EMU_CR_RANDOM_HOST_WDATA19                        (0x02B0U)
#define EMU_CR_RANDOM_HOST_WDATA19_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 19 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA19_WDATA19_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA19_WDATA19_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 20

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA20
*/
#define EMU_CR_RANDOM_HOST_WDATA20                        (0x02B8U)
#define EMU_CR_RANDOM_HOST_WDATA20_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 20 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA20_WDATA20_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA20_WDATA20_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 21

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA21
*/
#define EMU_CR_RANDOM_HOST_WDATA21                        (0x02C0U)
#define EMU_CR_RANDOM_HOST_WDATA21_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 21 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA21_WDATA21_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA21_WDATA21_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 22

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA22
*/
#define EMU_CR_RANDOM_HOST_WDATA22                        (0x02C8U)
#define EMU_CR_RANDOM_HOST_WDATA22_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 22 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA22_WDATA22_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA22_WDATA22_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 23

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA23
*/
#define EMU_CR_RANDOM_HOST_WDATA23                        (0x02D0U)
#define EMU_CR_RANDOM_HOST_WDATA23_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 23 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA23_WDATA23_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA23_WDATA23_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 24

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA24
*/
#define EMU_CR_RANDOM_HOST_WDATA24                        (0x02D8U)
#define EMU_CR_RANDOM_HOST_WDATA24_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 24 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA24_WDATA24_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA24_WDATA24_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 25

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA25
*/
#define EMU_CR_RANDOM_HOST_WDATA25                        (0x02E0U)
#define EMU_CR_RANDOM_HOST_WDATA25_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 25 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA25_WDATA25_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA25_WDATA25_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 26

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA26
*/
#define EMU_CR_RANDOM_HOST_WDATA26                        (0x02E8U)
#define EMU_CR_RANDOM_HOST_WDATA26_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 26 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA26_WDATA26_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA26_WDATA26_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 27

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA27
*/
#define EMU_CR_RANDOM_HOST_WDATA27                        (0x02F0U)
#define EMU_CR_RANDOM_HOST_WDATA27_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 27 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA27_WDATA27_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA27_WDATA27_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 28

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA28
*/
#define EMU_CR_RANDOM_HOST_WDATA28                        (0x02F8U)
#define EMU_CR_RANDOM_HOST_WDATA28_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 28 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA28_WDATA28_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA28_WDATA28_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 29

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA29
*/
#define EMU_CR_RANDOM_HOST_WDATA29                        (0x0300U)
#define EMU_CR_RANDOM_HOST_WDATA29_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 29 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA29_WDATA29_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA29_WDATA29_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 30

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA30
*/
#define EMU_CR_RANDOM_HOST_WDATA30                        (0x0308U)
#define EMU_CR_RANDOM_HOST_WDATA30_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 30 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA30_WDATA30_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA30_WDATA30_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	Random host write data 31

*/
/*
	Register EMU_CR_RANDOM_HOST_WDATA31
*/
#define EMU_CR_RANDOM_HOST_WDATA31                        (0x0310U)
#define EMU_CR_RANDOM_HOST_WDATA31_MASKFULL               (IMG_UINT64_C(0xFFFFFFFFFFFFFFFF))
/*
Data for address 31 to be populated
*/
#define EMU_CR_RANDOM_HOST_WDATA31_WDATA31_SHIFT          (0U)
#define EMU_CR_RANDOM_HOST_WDATA31_WDATA31_CLRMSK         (IMG_UINT64_C(0000000000000000))

/*

	The number of outstanding reads to the emulator memory bank interface on port0
	If EMU_CR_PCI_MASTER_MODE = 0, the count will be the number of outstanding reads to local memory
	If EMU_CR_PCI_MASTER_MODE = 1, the count will be the number of outstanding reads to the PCI interface

*/
/*
	Register EMU_CR_BANK_OUTSTANDING0
*/
#define EMU_CR_BANK_OUTSTANDING0                          (0x0500U)
#define EMU_CR_BANK_OUTSTANDING0_MASKFULL                 (IMG_UINT64_C(0x000000000000FFFF))
/*
Number of outstanding reads
*/
#define EMU_CR_BANK_OUTSTANDING0_READS_SHIFT              (0U)
#define EMU_CR_BANK_OUTSTANDING0_READS_CLRMSK             (0XFFFF0000U)

/*

	The number of outstanding reads in the IMGBUSv4 interface module on port 0
	Only applies to certain Rogue configurations

*/
/*
	Register EMU_CR_IMGBV4_OUTSTANDING0
*/
#define EMU_CR_IMGBV4_OUTSTANDING0                        (0x0508U)
#define EMU_CR_IMGBV4_OUTSTANDING0_MASKFULL               (IMG_UINT64_C(0x000000000000FFFF))
/*
Number of outstanding reads
*/
#define EMU_CR_IMGBV4_OUTSTANDING0_READS_SHIFT            (0U)
#define EMU_CR_IMGBV4_OUTSTANDING0_READS_CLRMSK           (0XFFFF0000U)

/*

	The number of outstanding reads to the emulator memory bank interface on port1
	If EMU_CR_PCI_MASTER_MODE = 0, the count will be the number of outstanding reads to local memory
	If EMU_CR_PCI_MASTER_MODE = 1, the count will be the number of outstanding reads to the PCI interface

*/
/*
	Register EMU_CR_BANK_OUTSTANDING1
*/
#define EMU_CR_BANK_OUTSTANDING1                          (0x0510U)
#define EMU_CR_BANK_OUTSTANDING1_MASKFULL                 (IMG_UINT64_C(0x000000000000FFFF))
/*
Number of outstanding reads
*/
#define EMU_CR_BANK_OUTSTANDING1_READS_SHIFT              (0U)
#define EMU_CR_BANK_OUTSTANDING1_READS_CLRMSK             (0XFFFF0000U)

/*

	The number of outstanding reads in the IMGBUSv4 interface module on port 1
	Only applies to certain Rogue configurations

*/
/*
	Register EMU_CR_IMGBV4_OUTSTANDING1
*/
#define EMU_CR_IMGBV4_OUTSTANDING1                        (0x0518U)
#define EMU_CR_IMGBV4_OUTSTANDING1_MASKFULL               (IMG_UINT64_C(0x000000000000FFFF))
/*
Number of outstanding reads
*/
#define EMU_CR_IMGBV4_OUTSTANDING1_READS_SHIFT            (0U)
#define EMU_CR_IMGBV4_OUTSTANDING1_READS_CLRMSK           (0XFFFF0000U)

/*

	The number of outstanding reads to the emulator memory bank interface on port2
	If EMU_CR_PCI_MASTER_MODE = 0, the count will be the number of outstanding reads to local memory
	If EMU_CR_PCI_MASTER_MODE = 1, the count will be the number of outstanding reads to the PCI interface

*/
/*
	Register EMU_CR_BANK_OUTSTANDING2
*/
#define EMU_CR_BANK_OUTSTANDING2                          (0x0520U)
#define EMU_CR_BANK_OUTSTANDING2_MASKFULL                 (IMG_UINT64_C(0x000000000000FFFF))
/*
Number of outstanding reads
*/
#define EMU_CR_BANK_OUTSTANDING2_READS_SHIFT              (0U)
#define EMU_CR_BANK_OUTSTANDING2_READS_CLRMSK             (0XFFFF0000U)

/*

	The number of outstanding reads in the IMGBUSv4 interface module on port 2
	Only applies to certain Rogue configurations

*/
/*
	Register EMU_CR_IMGBV4_OUTSTANDING2
*/
#define EMU_CR_IMGBV4_OUTSTANDING2                        (0x0528U)
#define EMU_CR_IMGBV4_OUTSTANDING2_MASKFULL               (IMG_UINT64_C(0x000000000000FFFF))
/*
Number of outstanding reads
*/
#define EMU_CR_IMGBV4_OUTSTANDING2_READS_SHIFT            (0U)
#define EMU_CR_IMGBV4_OUTSTANDING2_READS_CLRMSK           (0XFFFF0000U)

/*

	The number of outstanding reads to the emulator memory bank interface on port3
	If EMU_CR_PCI_MASTER_MODE = 0, the count will be the number of outstanding reads to local memory
	If EMU_CR_PCI_MASTER_MODE = 1, the count will be the number of outstanding reads to the PCI interface

*/
/*
	Register EMU_CR_BANK_OUTSTANDING3
*/
#define EMU_CR_BANK_OUTSTANDING3                          (0x0530U)
#define EMU_CR_BANK_OUTSTANDING3_MASKFULL                 (IMG_UINT64_C(0x000000000000FFFF))
/*
Number of outstanding reads
*/
#define EMU_CR_BANK_OUTSTANDING3_READS_SHIFT              (0U)
#define EMU_CR_BANK_OUTSTANDING3_READS_CLRMSK             (0XFFFF0000U)

/*

	The number of outstanding reads in the IMGBUSv4 interface module on port 3
	Only applies to certain Rogue configurations

*/
/*
	Register EMU_CR_IMGBV4_OUTSTANDING3
*/
#define EMU_CR_IMGBV4_OUTSTANDING3                        (0x0538U)
#define EMU_CR_IMGBV4_OUTSTANDING3_MASKFULL               (IMG_UINT64_C(0x000000000000FFFF))
/*
Number of outstanding reads
*/
#define EMU_CR_IMGBV4_OUTSTANDING3_READS_SHIFT            (0U)
#define EMU_CR_IMGBV4_OUTSTANDING3_READS_CLRMSK           (0XFFFF0000U)

/*

	Memory latency control for return data

*/
/*
	Register EMU_CR_MEMORY_LATENCY
*/
#define EMU_CR_MEMORY_LATENCY                             (0x1548U)
#define EMU_CR_MEMORY_LATENCY_MASKFULL                    (IMG_UINT64_C(0x00000000000001FF))
/*
Return Data
*/
#define EMU_CR_MEMORY_LATENCY_RDATA_SHIFT                 (0U)
#define EMU_CR_MEMORY_LATENCY_RDATA_CLRMSK                (IMG_UINT64_C(0XFFFFFFFFFFFFFE00))

#endif /* _EMU_CR_DEFS_H_ */

/*****************************************************************************
 End of file (emu_cr_defs.h)
*****************************************************************************/

