/*
 * (C) Copyright 2007-2013
 * Allwinner Technology Co., Ltd. <www.allwinnertech.com>
 * Jerry Wang <wangflord@allwinnertech.com>
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef	_NAND_MBR_H_
#define	_NAND_MBR_H_

#define     DOWNLOAD_MAP_NAME   "dlinfo.fex"
/* MBR       */
#define     MBR_SIZE			1024
#define   	MBR_MAGIC			"softw311"
#define     MBR_START_ADDRESS	0x00000000
#define     MBR_MAX_PART_COUNT	15
#define     MBR_COPY_NUM        4    //mbrı
#define     MBR_RESERVED        (MBR_SIZE - 20 - (MBR_MAX_PART_COUNT * sizeof(PARTITION)))   //mbrĿռ

//Ϣ, 64byte
typedef struct tag_PARTITION
{
	unsigned  int       addrhi;				//ʼַ, Ϊλ
	unsigned  int       addrlo;				//
	unsigned  int       lenhi;				//
	unsigned  int       lenlo;				//
	unsigned  char      classname[12];		//豸
	unsigned  char      name[12];			//豸
	unsigned  int       user_type;          //û
	unsigned  int       ro;                 //д
	unsigned  char      res[16];			//
} __attribute__ ((packed))PARTITION;
//MBRϢ
typedef struct tag_MBR
{
	unsigned  int       crc32;				        // crc 1k - 4
	unsigned  int       version;			        // 汾Ϣ 0x00000100
	unsigned  char 	    magic[8];			        //"softw311"
	unsigned  char 	    copy;				        //
	unsigned  char 	    index;				        //ڼMBR
	unsigned  short     PartCount;			        //
	PARTITION           array[MBR_MAX_PART_COUNT];	//
	unsigned  char      res[MBR_RESERVED];
}__attribute__ ((packed)) MBR;

typedef struct tag_one_part_info
{
	unsigned  char      classname[12];      //дĴ豸
	unsigned  char      name[12];           //д豸
	unsigned  int       addrhi;             //дĸߵַλ
	unsigned  int       addrlo;             //дĵ͵ַλ
	unsigned  int       lenhi;				//дĳȣ32λλ
	unsigned  int       lenlo;				//дĳȣ32λλ
	unsigned  char      part_name[12];      //дƣMBRеķ classname Ӧ
	unsigned  char      dl_filename[16];    //дļƣȹ̶16ֽ
	unsigned  char      vf_filename[16];    //дУļƣȹ̶16ֽ
	unsigned  int       encrypt;            //дǷм 0:   1
}
dl_one_part_info;
//дϢ
typedef struct tag_download_info
{
	unsigned  int       crc32;				        		//crc
	unsigned  int       version;                            //汾  0x00000101
	unsigned  char 	    magic[8];			        		//"softw311"
	unsigned  int       download_count;             		//Ҫдķ
	dl_one_part_info	one_part_info[MBR_MAX_PART_COUNT];	//дϢ
}
download_info;

#endif	//_NAND_MBR_H_

/* end of _NAND_MBR_H_ */

